/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.CalculationPeriodToDays;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg1FixedFixedDefault.class)
public abstract class InterestRateLeg1FixedFixed
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculationPeriodToDays calculationPeriodToDays;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg1;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1Builder = this.doEvaluate(product);
        if (interestRateLeg1Builder == null) {
            interestRateLeg1 = null;
        } else {
            interestRateLeg1 = interestRateLeg1Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg1);
        }
        return interestRateLeg1;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> interestRatePayouts(Product var1);

    public static class InterestRateLeg1FixedFixedDefault
    extends InterestRateLeg1FixedFixed {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg1, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1, Product product) {
            interestRateLeg1 = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).min(item -> MapperS.of((Object)this.calculationPeriodToDays.evaluate((InterestRatePayout)item.get()))).get()) : (ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).max(item -> item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate()).map("getRateSchedule", fixedRateSpecification -> fixedRateSpecification.getRateSchedule()).map("getPrice", rateSchedule -> rateSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue())).get()) : null);
            return Optional.ofNullable(interestRateLeg1).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRatePayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }
    }
}

