/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.trade.quantity.NotionalPeriod;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.functions.LegToCommonLeg;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.IndexEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=LegEnrichmentDefault.class)
public abstract class LegEnrichment
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected LegToCommonLeg legToCommonLeg;

    public CommonLeg evaluate(Leg leg, List<? extends NotionalPeriod> notionalAmountSchedule, List<? extends NotionalPeriod> notionalQuantitySchedule, BigDecimal notionalQuantity, FrequencyPeriodEnum floatingRateResetFrequencyPeriod, Integer floatingRateResetFrequencyMultiplier, ZonedDateTime fixingDate, FrequencyPeriodEnum quantityFrequency, Integer quantityFrequencyMultiplier, IndexEnum floatingRateIndicator, String floatingRateIdentifier, FrequencyPeriodEnum floatingRateReferencePeriod, Integer floatingRateReferencePeriodMultiplier, String nameOfTheFloatingRate) {
        CommonLeg enrichedLeg;
        CommonLeg.CommonLegBuilder enrichedLegBuilder = this.doEvaluate(leg, notionalAmountSchedule, notionalQuantitySchedule, notionalQuantity, floatingRateResetFrequencyPeriod, floatingRateResetFrequencyMultiplier, fixingDate, quantityFrequency, quantityFrequencyMultiplier, floatingRateIndicator, floatingRateIdentifier, floatingRateReferencePeriod, floatingRateReferencePeriodMultiplier, nameOfTheFloatingRate);
        if (enrichedLegBuilder == null) {
            enrichedLeg = null;
        } else {
            enrichedLeg = enrichedLegBuilder.build();
            this.objectValidator.validate(CommonLeg.class, (RosettaModelObject)enrichedLeg);
        }
        return enrichedLeg;
    }

    protected abstract CommonLeg.CommonLegBuilder doEvaluate(Leg var1, List<? extends NotionalPeriod> var2, List<? extends NotionalPeriod> var3, BigDecimal var4, FrequencyPeriodEnum var5, Integer var6, ZonedDateTime var7, FrequencyPeriodEnum var8, Integer var9, IndexEnum var10, String var11, FrequencyPeriodEnum var12, Integer var13, String var14);

    public static class LegEnrichmentDefault
    extends LegEnrichment {
        @Override
        protected CommonLeg.CommonLegBuilder doEvaluate(Leg leg, List<? extends NotionalPeriod> notionalAmountSchedule, List<? extends NotionalPeriod> notionalQuantitySchedule, BigDecimal notionalQuantity, FrequencyPeriodEnum floatingRateResetFrequencyPeriod, Integer floatingRateResetFrequencyMultiplier, ZonedDateTime fixingDate, FrequencyPeriodEnum quantityFrequency, Integer quantityFrequencyMultiplier, IndexEnum floatingRateIndicator, String floatingRateIdentifier, FrequencyPeriodEnum floatingRateReferencePeriod, Integer floatingRateReferencePeriodMultiplier, String nameOfTheFloatingRate) {
            if (notionalAmountSchedule == null) {
                notionalAmountSchedule = Collections.emptyList();
            }
            if (notionalQuantitySchedule == null) {
                notionalQuantitySchedule = Collections.emptyList();
            }
            CommonLeg.CommonLegBuilder enrichedLeg = CommonLeg.builder();
            return this.assignOutput(enrichedLeg, leg, notionalAmountSchedule, notionalQuantitySchedule, notionalQuantity, floatingRateResetFrequencyPeriod, floatingRateResetFrequencyMultiplier, fixingDate, quantityFrequency, quantityFrequencyMultiplier, floatingRateIndicator, floatingRateIdentifier, floatingRateReferencePeriod, floatingRateReferencePeriodMultiplier, nameOfTheFloatingRate);
        }

        protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder enrichedLeg, Leg leg, List<? extends NotionalPeriod> notionalAmountSchedule, List<? extends NotionalPeriod> notionalQuantitySchedule, BigDecimal notionalQuantity, FrequencyPeriodEnum floatingRateResetFrequencyPeriod, Integer floatingRateResetFrequencyMultiplier, ZonedDateTime fixingDate, FrequencyPeriodEnum quantityFrequency, Integer quantityFrequencyMultiplier, IndexEnum floatingRateIndicator, String floatingRateIdentifier, FrequencyPeriodEnum floatingRateReferencePeriod, Integer floatingRateReferencePeriodMultiplier, String nameOfTheFloatingRate) {
            enrichedLeg = (CommonLeg.CommonLegBuilder)this.toBuilder(this.legToCommonLeg.evaluate(leg), () -> CommonLeg.builder());
            enrichedLeg.setNotionalAmountSchedule((List)notionalAmountSchedule);
            enrichedLeg.setNotionalQuantitySchedule((List)notionalQuantitySchedule);
            enrichedLeg.setNotionalQuantity(notionalQuantity);
            enrichedLeg.setFixingDate(fixingDate);
            enrichedLeg.setQuantityFrequency(quantityFrequency);
            enrichedLeg.setQuantityFrequencyMultiplier(quantityFrequencyMultiplier);
            enrichedLeg.getOrCreatePeriodicPayment().setFloatingRateResetFrequencyPeriod(floatingRateResetFrequencyPeriod);
            enrichedLeg.getOrCreatePeriodicPayment().setFloatingRateResetFrequencyMultiplier(floatingRateResetFrequencyMultiplier);
            enrichedLeg.getOrCreatePeriodicPayment().setFloatingRateIndicator(floatingRateIndicator);
            enrichedLeg.getOrCreatePeriodicPayment().setFloatingRateIdentifier(floatingRateIdentifier);
            enrichedLeg.getOrCreatePeriodicPayment().setFloatingRateReferencePeriod(floatingRateReferencePeriod);
            enrichedLeg.getOrCreatePeriodicPayment().setFloatingRateReferencePeriodMultiplier(floatingRateReferencePeriodMultiplier);
            enrichedLeg.getOrCreatePeriodicPayment().setNameOfTheFloatingRate(nameOfTheFloatingRate);
            return Optional.ofNullable(enrichedLeg).map(o -> o.prune()).orElse(null);
        }
    }
}

