/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.payment.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.payment.OtherPayment;
import drr.regulation.common.CommonAssetClass;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.PaymentType4Code;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=OtherPaymentType_01B_ValidationDefault.class)
public abstract class OtherPaymentType_01B_Validation
implements RosettaFunction {
    public Boolean evaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment) {
        Boolean result = this.doEvaluate(actionType, assetClass, otherPayment);
        return result;
    }

    protected abstract Boolean doEvaluate(ActionTypeEnum var1, CommonAssetClass var2, List<? extends OtherPayment> var3);

    public static class OtherPaymentType_01B_ValidationDefault
    extends OtherPaymentType_01B_Validation {
        @Override
        protected Boolean doEvaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment) {
            if (otherPayment == null) {
                otherPayment = Collections.emptyList();
            }
            Boolean result = null;
            return this.assignOutput(result, actionType, assetClass, otherPayment);
        }

        protected Boolean assignOutput(Boolean result, ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)actionType)), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.TERM)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonAssetClass.INTR)), MapperS.of((Object)((Object)CommonAssetClass.CURR)), MapperS.of((Object)((Object)CommonAssetClass.COMM)), MapperS.of((Object)((Object)CommonAssetClass.EQUI))}), (Mapper)MapperS.of((Object)((Object)assetClass)), (CardinalityOperator)CardinalityOperator.Any)).and(ExpressionOperators.exists((Mapper)MapperC.of(otherPayment).map("getAmount", _otherPayment -> _otherPayment.getAmount())).or(ExpressionOperators.exists((Mapper)MapperC.of(otherPayment).map("getCurrency", _otherPayment -> _otherPayment.getCurrency()))).or(ExpressionOperators.exists((Mapper)MapperC.of(otherPayment).map("getPayer", _otherPayment -> _otherPayment.getPayer()))).or(ExpressionOperators.exists((Mapper)MapperC.of(otherPayment).map("getReceiver", _otherPayment -> _otherPayment.getReceiver())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ComparisonResult ifThenElseResult = ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getAmount", _otherPayment -> _otherPayment.getAmount()).resultCount()), (CardinalityOperator)CardinalityOperator.Any).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getCurrency", _otherPayment -> _otherPayment.getCurrency()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getDate", _otherPayment -> _otherPayment.getDate()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPayer", _otherPayment -> _otherPayment.getPayer()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getReceiver", _otherPayment -> _otherPayment.getReceiver()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)) != false ? ComparisonResult.of((Mapper)MapperS.of((Object)false)) : ComparisonResult.successEmptyOperand((String)"");
                result = ExpressionOperators.exists((Mapper)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType())).and(ExpressionOperators.areEqual((Mapper)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()), (Mapper)MapperS.of((Object)((Object)PaymentType4Code.UWIN)), (CardinalityOperator)CardinalityOperator.All)).and(ifThenElseResult).get();
            } else {
                result = null;
            }
            return result;
        }
    }
}

