/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.quantity;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.trade.quantity.meta.QuantityFrequencyMeta;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="QuantityFrequency", builder=QuantityFrequencyBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="QuantityFrequency", model="drr", builder=QuantityFrequencyBuilderImpl.class, version="7.0.0-dev.52")
public interface QuantityFrequency
extends RosettaModelObject {
    public static final QuantityFrequencyMeta metaData = new QuantityFrequencyMeta();

    public FrequencyPeriodEnum getPeriod();

    public Integer getPeriodMultiplier();

    public QuantityFrequency build();

    public QuantityFrequencyBuilder toBuilder();

    public static QuantityFrequencyBuilder builder() {
        return new QuantityFrequencyBuilderImpl();
    }

    default public RosettaMetaData<? extends QuantityFrequency> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends QuantityFrequency> getType() {
        return QuantityFrequency.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("period"), FrequencyPeriodEnum.class, (Object)this.getPeriod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("periodMultiplier"), Integer.class, (Object)this.getPeriodMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class QuantityFrequencyBuilderImpl
    implements QuantityFrequencyBuilder {
        protected FrequencyPeriodEnum period;
        protected Integer periodMultiplier;

        @Override
        @RosettaAttribute(value="period")
        @RuneAttribute(value="period")
        public FrequencyPeriodEnum getPeriod() {
            return this.period;
        }

        @Override
        @RosettaAttribute(value="periodMultiplier")
        @RuneAttribute(value="periodMultiplier")
        public Integer getPeriodMultiplier() {
            return this.periodMultiplier;
        }

        @Override
        @RosettaAttribute(value="period")
        @RuneAttribute(value="period")
        public QuantityFrequencyBuilder setPeriod(FrequencyPeriodEnum _period) {
            this.period = _period == null ? null : _period;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodMultiplier")
        @RuneAttribute(value="periodMultiplier")
        public QuantityFrequencyBuilder setPeriodMultiplier(Integer _periodMultiplier) {
            this.periodMultiplier = _periodMultiplier == null ? null : _periodMultiplier;
            return this;
        }

        @Override
        public QuantityFrequency build() {
            return new QuantityFrequencyImpl(this);
        }

        @Override
        public QuantityFrequencyBuilder toBuilder() {
            return this;
        }

        @Override
        public QuantityFrequencyBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getPeriod() != null) {
                return true;
            }
            return this.getPeriodMultiplier() != null;
        }

        public QuantityFrequencyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            QuantityFrequencyBuilder o = (QuantityFrequencyBuilder)other;
            merger.mergeBasic((Object)this.getPeriod(), (Object)o.getPeriod(), this::setPeriod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPeriodMultiplier(), (Object)o.getPeriodMultiplier(), this::setPeriodMultiplier, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            QuantityFrequency _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.period, (Object)_that.getPeriod())) {
                return false;
            }
            return Objects.equals(this.periodMultiplier, _that.getPeriodMultiplier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.period != null ? ((Object)((Object)this.period)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.periodMultiplier != null ? this.periodMultiplier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuantityFrequencyBuilder {period=" + String.valueOf((Object)this.period) + ", periodMultiplier=" + this.periodMultiplier + "}";
        }
    }

    public static interface QuantityFrequencyBuilder
    extends QuantityFrequency,
    RosettaModelObjectBuilder {
        public QuantityFrequencyBuilder setPeriod(FrequencyPeriodEnum var1);

        public QuantityFrequencyBuilder setPeriodMultiplier(Integer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("period"), FrequencyPeriodEnum.class, (Object)this.getPeriod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("periodMultiplier"), Integer.class, (Object)this.getPeriodMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public QuantityFrequencyBuilder prune();
    }

    public static class QuantityFrequencyImpl
    implements QuantityFrequency {
        private final FrequencyPeriodEnum period;
        private final Integer periodMultiplier;

        protected QuantityFrequencyImpl(QuantityFrequencyBuilder builder) {
            this.period = builder.getPeriod();
            this.periodMultiplier = builder.getPeriodMultiplier();
        }

        @Override
        @RosettaAttribute(value="period")
        @RuneAttribute(value="period")
        public FrequencyPeriodEnum getPeriod() {
            return this.period;
        }

        @Override
        @RosettaAttribute(value="periodMultiplier")
        @RuneAttribute(value="periodMultiplier")
        public Integer getPeriodMultiplier() {
            return this.periodMultiplier;
        }

        @Override
        public QuantityFrequency build() {
            return this;
        }

        @Override
        public QuantityFrequencyBuilder toBuilder() {
            QuantityFrequencyBuilder builder = QuantityFrequency.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuantityFrequencyBuilder builder) {
            Optional.ofNullable(this.getPeriod()).ifPresent(builder::setPeriod);
            Optional.ofNullable(this.getPeriodMultiplier()).ifPresent(builder::setPeriodMultiplier);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            QuantityFrequency _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.period, (Object)_that.getPeriod())) {
                return false;
            }
            return Objects.equals(this.periodMultiplier, _that.getPeriodMultiplier());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.period != null ? ((Object)((Object)this.period)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.periodMultiplier != null ? this.periodMultiplier.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuantityFrequency {period=" + String.valueOf((Object)this.period) + ", periodMultiplier=" + this.periodMultiplier + "}";
        }
    }
}

