/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.underlier.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.RateOption;
import drr.standards.iso.functions.FormatToMax3Number;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=FloatingRateReferencePeriodMultiplierRuleDefault.class)
public abstract class FloatingRateReferencePeriodMultiplierRule
implements ReportFunction<InterestRatePayout, BigDecimal> {
    @Inject
    protected FormatToMax3Number formatToMax3Number;
    @Inject
    protected RateOption rateOption;

    public BigDecimal evaluate(InterestRatePayout input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(InterestRatePayout var1);

    public static class FloatingRateReferencePeriodMultiplierRuleDefault
    extends FloatingRateReferencePeriodMultiplierRule {
        @Override
        protected BigDecimal doEvaluate(InterestRatePayout input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, InterestRatePayout input) {
            MapperS thenArg = MapperS.of((Object)this.rateOption.evaluate(input)).map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier());
            Integer integer = (Integer)thenArg.get();
            output = (BigDecimal)MapperS.of((Object)this.formatToMax3Number.evaluate(integer == null ? null : BigDecimal.valueOf(integer.intValue()))).get();
            return output;
        }
    }
}

