/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.underlier.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsCreditSwaption;
import drr.base.qualification.product.functions.IsIRSwaption;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.base.trade.underlier.functions.UnderlierProductIdentifier;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

@ImplementedBy(value=UnderlyingIdentificationRuleDefault.class)
public abstract class UnderlyingIdentificationRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected IsIRSwaption isIRSwaption;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;
    @Inject
    protected UnderlierProductIdentifier underlierProductIdentifier;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class UnderlyingIdentificationRuleDefault
    extends UnderlyingIdentificationRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = ComparisonResult.of((Mapper)MapperS.of((Object)this.isCreditSwaption.evaluate(this.productForEvent.evaluate(input)))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isIRSwaption.evaluate(this.productForEvent.evaluate(input))))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.underlierForProduct.evaluate(this.productForEvent.evaluate(input))) : MapperS.of((Object)this.productForEvent.evaluate(input));
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)MapperC.of(this.underlierProductIdentifier.evaluate((Product)item.get(), ProductIdTypeEnum.ISIN))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((FieldWithMetaString)MapperC.of(this.underlierProductIdentifier.evaluate((Product)item.get(), ProductIdTypeEnum.ISIN)).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get()));
                }
                return MapperS.ofNull();
            }).get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

