/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.functions;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.payment.CommonPeriodicPayment;
import drr.regulation.csa.rewrite.trade.CSALeg;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CSALegEnrichmentDefault.class)
public abstract class CSALegEnrichment
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public CSALeg evaluate(CommonLeg legEnrichment, String quantityUnitOfMeasure, String underlierIDOther, String underlierIDOtherSource, String underlyingAssetTradingPlatformIdentifier, String underlyingAssetPriceSource, Boolean cryptoAssetUnderlyingIndicator, String payerIdentifier, String receiverIdentifier, ISOCountryCodeEnum settlementLocation, String commodityUnderlyerID, String commodityInstrumentID, String floatingRateIndex) {
        CSALeg csaEnrichedLeg;
        CSALeg.CSALegBuilder csaEnrichedLegBuilder = this.doEvaluate(legEnrichment, quantityUnitOfMeasure, underlierIDOther, underlierIDOtherSource, underlyingAssetTradingPlatformIdentifier, underlyingAssetPriceSource, cryptoAssetUnderlyingIndicator, payerIdentifier, receiverIdentifier, settlementLocation, commodityUnderlyerID, commodityInstrumentID, floatingRateIndex);
        if (csaEnrichedLegBuilder == null) {
            csaEnrichedLeg = null;
        } else {
            csaEnrichedLeg = csaEnrichedLegBuilder.build();
            this.objectValidator.validate(CSALeg.class, (RosettaModelObject)csaEnrichedLeg);
        }
        return csaEnrichedLeg;
    }

    protected abstract CSALeg.CSALegBuilder doEvaluate(CommonLeg var1, String var2, String var3, String var4, String var5, String var6, Boolean var7, String var8, String var9, ISOCountryCodeEnum var10, String var11, String var12, String var13);

    public static class CSALegEnrichmentDefault
    extends CSALegEnrichment {
        @Override
        protected CSALeg.CSALegBuilder doEvaluate(CommonLeg legEnrichment, String quantityUnitOfMeasure, String underlierIDOther, String underlierIDOtherSource, String underlyingAssetTradingPlatformIdentifier, String underlyingAssetPriceSource, Boolean cryptoAssetUnderlyingIndicator, String payerIdentifier, String receiverIdentifier, ISOCountryCodeEnum settlementLocation, String commodityUnderlyerID, String commodityInstrumentID, String floatingRateIndex) {
            CSALeg.CSALegBuilder csaEnrichedLeg = CSALeg.builder();
            return this.assignOutput(csaEnrichedLeg, legEnrichment, quantityUnitOfMeasure, underlierIDOther, underlierIDOtherSource, underlyingAssetTradingPlatformIdentifier, underlyingAssetPriceSource, cryptoAssetUnderlyingIndicator, payerIdentifier, receiverIdentifier, settlementLocation, commodityUnderlyerID, commodityInstrumentID, floatingRateIndex);
        }

        protected CSALeg.CSALegBuilder assignOutput(CSALeg.CSALegBuilder csaEnrichedLeg, CommonLeg legEnrichment, String quantityUnitOfMeasure, String underlierIDOther, String underlierIDOtherSource, String underlyingAssetTradingPlatformIdentifier, String underlyingAssetPriceSource, Boolean cryptoAssetUnderlyingIndicator, String payerIdentifier, String receiverIdentifier, ISOCountryCodeEnum settlementLocation, String commodityUnderlyerID, String commodityInstrumentID, String floatingRateIndex) {
            csaEnrichedLeg.setPeriodicPayment((CommonPeriodicPayment)MapperS.of((Object)legEnrichment).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).get());
            csaEnrichedLeg.setNotionalAmountSchedule(MapperS.of((Object)legEnrichment).mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).getMulti());
            csaEnrichedLeg.setNotionalQuantitySchedule(MapperS.of((Object)legEnrichment).mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).getMulti());
            csaEnrichedLeg.setNotionalCurrency((ISOCurrencyCodeEnum)MapperS.of((Object)legEnrichment).map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).get());
            csaEnrichedLeg.setFixedRate((BigDecimal)MapperS.of((Object)legEnrichment).map("getFixedRate", commonLeg -> commonLeg.getFixedRate()).get());
            csaEnrichedLeg.setSettlementCurrency((ISOCurrencyCodeEnum)MapperS.of((Object)legEnrichment).map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).get());
            csaEnrichedLeg.setSpread((PriceFormat)MapperS.of((Object)legEnrichment).map("getSpread", commonLeg -> commonLeg.getSpread()).get());
            csaEnrichedLeg.setSpreadNotation((PriceNotationEnum)((Object)MapperS.of((Object)legEnrichment).map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation()).get()));
            csaEnrichedLeg.setSpreadCurrency((ISOCurrencyCodeEnum)MapperS.of((Object)legEnrichment).map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()).get());
            csaEnrichedLeg.setDirection2(null);
            csaEnrichedLeg.setNotionalQuantity((BigDecimal)MapperS.of((Object)legEnrichment).map("getNotionalQuantity", commonLeg -> commonLeg.getNotionalQuantity()).get());
            csaEnrichedLeg.setFixingDate((ZonedDateTime)MapperS.of((Object)legEnrichment).map("getFixingDate", commonLeg -> commonLeg.getFixingDate()).get());
            csaEnrichedLeg.setQuantityFrequency((FrequencyPeriodEnum)((Object)MapperS.of((Object)legEnrichment).map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()).get()));
            csaEnrichedLeg.setQuantityFrequencyMultiplier((Integer)MapperS.of((Object)legEnrichment).map("getQuantityFrequencyMultiplier", commonLeg -> commonLeg.getQuantityFrequencyMultiplier()).get());
            csaEnrichedLeg.setPayerIdentifier(payerIdentifier);
            csaEnrichedLeg.setReceiverIdentifier(receiverIdentifier);
            csaEnrichedLeg.setSettlementLocation(settlementLocation);
            csaEnrichedLeg.setUnderlierIDOther(underlierIDOther);
            csaEnrichedLeg.setUnderlierIDOtherSource(underlierIDOtherSource);
            csaEnrichedLeg.setUnderlyingAssetTradingPlatformIdentifier(underlyingAssetTradingPlatformIdentifier);
            csaEnrichedLeg.setCryptoAssetUnderlyingIndicator(cryptoAssetUnderlyingIndicator);
            csaEnrichedLeg.setQuantityUnitOfMeasure(quantityUnitOfMeasure);
            csaEnrichedLeg.setTotalNotionalQuantity((BigDecimal)MapperS.of((Object)legEnrichment).map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()).get());
            csaEnrichedLeg.setNotionalAmount((BigDecimal)MapperS.of((Object)legEnrichment).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get());
            csaEnrichedLeg.setCommodityUnderlyerID(commodityUnderlyerID);
            csaEnrichedLeg.setCommodityInstrumentID(commodityInstrumentID);
            csaEnrichedLeg.setFloatingRateIndex(floatingRateIndex);
            return Optional.ofNullable(csaEnrichedLeg).map(o -> o.prune()).orElse(null);
        }
    }
}

