/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.dtcc.reports.DTCC_ClearingVenueIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_Comment1Rule;
import drr.regulation.common.dtcc.reports.DTCC_CorporateActionNewTradeParty1LEIRule;
import drr.regulation.common.dtcc.reports.DTCC_DeliveryLocationRule;
import drr.regulation.common.dtcc.reports.DTCC_MaturityDateOfTheUnderlyingRule;
import drr.regulation.common.dtcc.reports.DTCC_OptionStyleRule;
import drr.regulation.common.dtcc.reports.DTCC_OptionTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_OtherPaymentPayerIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_OtherPaymentReceiverIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_PrimaryAssetClassRule;
import drr.regulation.common.dtcc.reports.DTCC_ProductGradeRule;
import drr.regulation.common.dtcc.reports.DTCC_ProductIDRule;
import drr.regulation.common.dtcc.reports.DTCC_ResponsibleDataSubmitterIDRule;
import drr.regulation.common.dtcc.reports.DTCC_ResponsibleDataSubmitterIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_SEFOrDCMAnonymousExecutionIndicatorRule;
import drr.regulation.common.dtcc.reports.DTCC_SecondaryAssetClassRule;
import drr.regulation.common.dtcc.reports.DTCC_SettlementTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_SubmittedForPartyRule;
import drr.regulation.common.dtcc.reports.DTCC_SubmittingPartyIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeLegTypesRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ClearingBrokerIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ExecutionAgentIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ExecutionAgentIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ReportingDestinationRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1TransactionIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty2ExecutionAgentIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty2ExecutionAgentIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty2ReportingDestinationRule;
import drr.regulation.common.dtcc.reports.DTCC_UnderlyingAssetIDRule;
import drr.regulation.common.trade.contract.reports.UnderlyingAssetTypeRule;
import drr.regulation.common.trade.quantity.reports.NotionalScheduleRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_AllocationTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ExecutionVenueIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_ExecutionVenueIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_Leg1SettlementPeriodRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_LoadTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_MessageIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_MessageTypeTransactionRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_NewSDRIdentifierRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1BrokerIDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_TradeParty1IDTypeRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_USIIDPrefixRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_USIIDRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_UnderlyingAssetNameRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_UnderlyingAssetReportRule;
import drr.regulation.csa.rewrite.dtcc.reports.DTCC_VersionTransactionRule;
import drr.regulation.csa.rewrite.trade.CSATransactionReportTrade;
import drr.regulation.csa.rewrite.trade.labels.CSATradeLabelProvider;
import drr.regulation.csa.rewrite.trade.reports.AmendmentIndicatorRule;
import drr.regulation.csa.rewrite.trade.reports.BasketConstituentsRule;
import drr.regulation.csa.rewrite.trade.reports.BrokerIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.BuyerIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.CDSIndexAttachmentPointRule;
import drr.regulation.csa.rewrite.trade.reports.CDSIndexDetachmentPointRule;
import drr.regulation.csa.rewrite.trade.reports.CallAmountRule;
import drr.regulation.csa.rewrite.trade.reports.CallCurrencyRule;
import drr.regulation.csa.rewrite.trade.reports.CentralCounterpartyIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.ClearedRule;
import drr.regulation.csa.rewrite.trade.reports.ClearingAccountOriginRule;
import drr.regulation.csa.rewrite.trade.reports.ClearingExceptionsAndExemptionsCounterparty1Rule;
import drr.regulation.csa.rewrite.trade.reports.ClearingExceptionsAndExemptionsCounterparty2Rule;
import drr.regulation.csa.rewrite.trade.reports.ClearingMemberIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.ClearingReceiptTimestampRule;
import drr.regulation.csa.rewrite.trade.reports.Counterparty2IdentifierSourceRule;
import drr.regulation.csa.rewrite.trade.reports.CountryAndProvinceOrTerritoryOfIndividualRule;
import drr.regulation.csa.rewrite.trade.reports.CustomBasketCodeRule;
import drr.regulation.csa.rewrite.trade.reports.CustomBasketIndicatorRule;
import drr.regulation.csa.rewrite.trade.reports.EffectiveDateRule;
import drr.regulation.csa.rewrite.trade.reports.EmbeddedOptionTypeRule;
import drr.regulation.csa.rewrite.trade.reports.EventIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.EventTimestampRule;
import drr.regulation.csa.rewrite.trade.reports.EventTypeRule;
import drr.regulation.csa.rewrite.trade.reports.ExchangeRateRule;
import drr.regulation.csa.rewrite.trade.reports.ExecutionTimestampRule;
import drr.regulation.csa.rewrite.trade.reports.ExecutionVenueTypeRule;
import drr.regulation.csa.rewrite.trade.reports.ExpirationDateRule;
import drr.regulation.csa.rewrite.trade.reports.FinalContractualSettlementDateRule;
import drr.regulation.csa.rewrite.trade.reports.FirstExerciseDateRule;
import drr.regulation.csa.rewrite.trade.reports.IndexFactorRule;
import drr.regulation.csa.rewrite.trade.reports.InitialMarginCollateralPortfolioCodeRule;
import drr.regulation.csa.rewrite.trade.reports.InstrumentTypeRule;
import drr.regulation.csa.rewrite.trade.reports.InterAffiliateIndicatorRule;
import drr.regulation.csa.rewrite.trade.reports.JurisdictionOfCounterparty1Rule;
import drr.regulation.csa.rewrite.trade.reports.JurisdictionOfCounterparty2Rule;
import drr.regulation.csa.rewrite.trade.reports.Leg1ReportRule;
import drr.regulation.csa.rewrite.trade.reports.Leg2ReportRule;
import drr.regulation.csa.rewrite.trade.reports.LevelRule;
import drr.regulation.csa.rewrite.trade.reports.MasterAgreementTypeRule;
import drr.regulation.csa.rewrite.trade.reports.MasterAgreementVersionRule;
import drr.regulation.csa.rewrite.trade.reports.NonStandardizedTermIndicatorRule;
import drr.regulation.csa.rewrite.trade.reports.OptionPremiumAmountRule;
import drr.regulation.csa.rewrite.trade.reports.OptionPremiumCurrencyRule;
import drr.regulation.csa.rewrite.trade.reports.OptionPremiumPaymentDateRule;
import drr.regulation.csa.rewrite.trade.reports.OtherPaymentRule;
import drr.regulation.csa.rewrite.trade.reports.PackageIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.PackageIndicatorRule;
import drr.regulation.csa.rewrite.trade.reports.PackageTransactionPriceCurrencyRule;
import drr.regulation.csa.rewrite.trade.reports.PackageTransactionPriceNotationRule;
import drr.regulation.csa.rewrite.trade.reports.PackageTransactionPriceRule;
import drr.regulation.csa.rewrite.trade.reports.PackageTransactionSpreadCurrencyRule;
import drr.regulation.csa.rewrite.trade.reports.PackageTransactionSpreadNotationRule;
import drr.regulation.csa.rewrite.trade.reports.PackageTransactionSpreadRule;
import drr.regulation.csa.rewrite.trade.reports.PlatformAnonymousExecutionIndicatorRule;
import drr.regulation.csa.rewrite.trade.reports.PlatformIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.PriceCurrencyRule;
import drr.regulation.csa.rewrite.trade.reports.PriceNotationRule;
import drr.regulation.csa.rewrite.trade.reports.PriceRule;
import drr.regulation.csa.rewrite.trade.reports.PriceUnitOfMeasureRule;
import drr.regulation.csa.rewrite.trade.reports.PriorUSIRule;
import drr.regulation.csa.rewrite.trade.reports.PriorUTIRule;
import drr.regulation.csa.rewrite.trade.reports.PutAmountRule;
import drr.regulation.csa.rewrite.trade.reports.PutCurrencyRule;
import drr.regulation.csa.rewrite.trade.reports.ReportingTimestampRule;
import drr.regulation.csa.rewrite.trade.reports.ReturnorPayoutTriggerRule;
import drr.regulation.csa.rewrite.trade.reports.SellerIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.SettlementLocationRule;
import drr.regulation.csa.rewrite.trade.reports.StrikePriceCurrencyCurrencyPairRule;
import drr.regulation.csa.rewrite.trade.reports.StrikePriceNotationRule;
import drr.regulation.csa.rewrite.trade.reports.StrikePriceRule;
import drr.regulation.csa.rewrite.trade.reports.SubmitterIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.SubsequentPositionUTIRule;
import drr.regulation.csa.rewrite.trade.reports.UniqueTransactionIdentifierRule;
import drr.regulation.csa.rewrite.trade.reports.VariationMarginCollateralPortfolioCodeRule;
import drr.regulation.csa.rewrite.trade.reports.emptyRuleRule;
import drr.standards.iosco.cde.version3.event.reports.ActionTypeRule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty1Rule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty2Rule;
import drr.standards.iosco.cde.version3.price.reports.ExchangeRateBasisRule;
import drr.standards.iosco.cde.version3.price.reports.PriceScheduleRule;
import drr.standards.iosco.cde.version3.price.reports.StrikePriceScheduleRule;
import drr.standards.iosco.upi.reports.UniqueProductIdentifierRule;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.csa.rewrite.trade", body="CSA", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=CSATradeLabelProvider.class)
@ImplementedBy(value=CSATradeReportFunctionDefault.class)
public abstract class CSATradeReportFunction
implements ReportFunction<TransactionReportInstruction, CSATransactionReportTrade> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected AmendmentIndicatorRule amendmentIndicatorRule;
    @Inject
    protected BasketConstituentsRule basketConstituentsRule;
    @Inject
    protected BrokerIdentifierRule brokerIdentifierRule;
    @Inject
    protected BuyerIdentifierRule buyerIdentifierRule;
    @Inject
    protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
    @Inject
    protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
    @Inject
    protected CallAmountRule callAmountRule;
    @Inject
    protected CallCurrencyRule callCurrencyRule;
    @Inject
    protected CentralCounterpartyIdentifierRule centralCounterpartyIdentifierRule;
    @Inject
    protected ClearedRule clearedRule;
    @Inject
    protected ClearingAccountOriginRule clearingAccountOriginRule;
    @Inject
    protected ClearingExceptionsAndExemptionsCounterparty1Rule clearingExceptionsAndExemptionsCounterparty1Rule;
    @Inject
    protected ClearingExceptionsAndExemptionsCounterparty2Rule clearingExceptionsAndExemptionsCounterparty2Rule;
    @Inject
    protected ClearingMemberIdentifierRule clearingMemberIdentifierRule;
    @Inject
    protected ClearingReceiptTimestampRule clearingReceiptTimestampRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected CountryAndProvinceOrTerritoryOfIndividualRule countryAndProvinceOrTerritoryOfIndividualRule;
    @Inject
    protected CustomBasketCodeRule customBasketCodeRule;
    @Inject
    protected CustomBasketIndicatorRule customBasketIndicatorRule;
    @Inject
    protected DTCC_AllocationTypeRule dTCC_AllocationTypeRule;
    @Inject
    protected DTCC_ClearingVenueIDTypeRule dTCC_ClearingVenueIDTypeRule;
    @Inject
    protected DTCC_Comment1Rule dTCC_Comment1Rule;
    @Inject
    protected DTCC_CorporateActionNewTradeParty1LEIRule dTCC_CorporateActionNewTradeParty1LEIRule;
    @Inject
    protected DTCC_DeliveryLocationRule dTCC_DeliveryLocationRule;
    @Inject
    protected DTCC_ExecutionVenueIDRule dTCC_ExecutionVenueIDRule;
    @Inject
    protected DTCC_ExecutionVenueIDTypeRule dTCC_ExecutionVenueIDTypeRule;
    @Inject
    protected DTCC_Leg1SettlementPeriodRule dTCC_Leg1SettlementPeriodRule;
    @Inject
    protected DTCC_LoadTypeRule dTCC_LoadTypeRule;
    @Inject
    protected DTCC_MaturityDateOfTheUnderlyingRule dTCC_MaturityDateOfTheUnderlyingRule;
    @Inject
    protected DTCC_MessageIDRule dTCC_MessageIDRule;
    @Inject
    protected DTCC_MessageTypeTransactionRule dTCC_MessageTypeTransactionRule;
    @Inject
    protected DTCC_NewSDRIdentifierRule dTCC_NewSDRIdentifierRule;
    @Inject
    protected DTCC_OptionStyleRule dTCC_OptionStyleRule;
    @Inject
    protected DTCC_OptionTypeRule dTCC_OptionTypeRule;
    @Inject
    protected DTCC_OtherPaymentPayerIDTypeRule dTCC_OtherPaymentPayerIDTypeRule;
    @Inject
    protected DTCC_OtherPaymentReceiverIDTypeRule dTCC_OtherPaymentReceiverIDTypeRule;
    @Inject
    protected DTCC_PrimaryAssetClassRule dTCC_PrimaryAssetClassRule;
    @Inject
    protected DTCC_ProductGradeRule dTCC_ProductGradeRule;
    @Inject
    protected DTCC_ProductIDRule dTCC_ProductIDRule;
    @Inject
    protected DTCC_ResponsibleDataSubmitterIDRule dTCC_ResponsibleDataSubmitterIDRule;
    @Inject
    protected DTCC_ResponsibleDataSubmitterIDTypeRule dTCC_ResponsibleDataSubmitterIDTypeRule;
    @Inject
    protected DTCC_SEFOrDCMAnonymousExecutionIndicatorRule dTCC_SEFOrDCMAnonymousExecutionIndicatorRule;
    @Inject
    protected DTCC_SecondaryAssetClassRule dTCC_SecondaryAssetClassRule;
    @Inject
    protected DTCC_SettlementTypeRule dTCC_SettlementTypeRule;
    @Inject
    protected DTCC_SubmittedForPartyRule dTCC_SubmittedForPartyRule;
    @Inject
    protected DTCC_SubmittingPartyIDTypeRule dTCC_SubmittingPartyIDTypeRule;
    @Inject
    protected DTCC_TradeLegTypesRule dTCC_TradeLegTypesRule;
    @Inject
    protected DTCC_TradeParty1BrokerIDTypeRule dTCC_TradeParty1BrokerIDTypeRule;
    @Inject
    protected DTCC_TradeParty1ClearingBrokerIDTypeRule dTCC_TradeParty1ClearingBrokerIDTypeRule;
    @Inject
    protected DTCC_TradeParty1ExecutionAgentIDRule dTCC_TradeParty1ExecutionAgentIDRule;
    @Inject
    protected DTCC_TradeParty1ExecutionAgentIDTypeRule dTCC_TradeParty1ExecutionAgentIDTypeRule;
    @Inject
    protected DTCC_TradeParty1IDTypeRule dTCC_TradeParty1IDTypeRule;
    @Inject
    protected DTCC_TradeParty1ReportingDestinationRule dTCC_TradeParty1ReportingDestinationRule;
    @Inject
    protected DTCC_TradeParty1TransactionIDRule dTCC_TradeParty1TransactionIDRule;
    @Inject
    protected DTCC_TradeParty2ExecutionAgentIDRule dTCC_TradeParty2ExecutionAgentIDRule;
    @Inject
    protected DTCC_TradeParty2ExecutionAgentIDTypeRule dTCC_TradeParty2ExecutionAgentIDTypeRule;
    @Inject
    protected DTCC_TradeParty2ReportingDestinationRule dTCC_TradeParty2ReportingDestinationRule;
    @Inject
    protected DTCC_USIIDPrefixRule dTCC_USIIDPrefixRule;
    @Inject
    protected DTCC_USIIDRule dTCC_USIIDRule;
    @Inject
    protected DTCC_UnderlyingAssetIDRule dTCC_UnderlyingAssetIDRule;
    @Inject
    protected DTCC_UnderlyingAssetNameRule dTCC_UnderlyingAssetNameRule;
    @Inject
    protected DTCC_UnderlyingAssetReportRule dTCC_UnderlyingAssetReportRule;
    @Inject
    protected DTCC_VersionTransactionRule dTCC_VersionTransactionRule;
    @Inject
    protected EffectiveDateRule effectiveDateRule;
    @Inject
    protected EmbeddedOptionTypeRule embeddedOptionTypeRule;
    @Inject
    protected EnrichmentDataRule enrichmentDataRule;
    @Inject
    protected EventIdentifierRule eventIdentifierRule;
    @Inject
    protected EventTimestampRule eventTimestampRule;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected ExchangeRateBasisRule exchangeRateBasisRule;
    @Inject
    protected ExchangeRateRule exchangeRateRule;
    @Inject
    protected ExecutionTimestampRule executionTimestampRule;
    @Inject
    protected ExecutionVenueTypeRule executionVenueTypeRule;
    @Inject
    protected ExpirationDateRule expirationDateRule;
    @Inject
    protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
    @Inject
    protected FirstExerciseDateRule firstExerciseDateRule;
    @Inject
    protected IndexFactorRule indexFactorRule;
    @Inject
    protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
    @Inject
    protected InstrumentTypeRule instrumentTypeRule;
    @Inject
    protected InterAffiliateIndicatorRule interAffiliateIndicatorRule;
    @Inject
    protected JurisdictionOfCounterparty1Rule jurisdictionOfCounterparty1Rule;
    @Inject
    protected JurisdictionOfCounterparty2Rule jurisdictionOfCounterparty2Rule;
    @Inject
    protected Leg1ReportRule leg1ReportRule;
    @Inject
    protected Leg2ReportRule leg2ReportRule;
    @Inject
    protected LevelRule levelRule;
    @Inject
    protected MasterAgreementTypeRule masterAgreementTypeRule;
    @Inject
    protected MasterAgreementVersionRule masterAgreementVersionRule;
    @Inject
    protected NonStandardizedTermIndicatorRule nonStandardizedTermIndicatorRule;
    @Inject
    protected NotionalScheduleRule notionalScheduleRule;
    @Inject
    protected OptionPremiumAmountRule optionPremiumAmountRule;
    @Inject
    protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
    @Inject
    protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
    @Inject
    protected OtherPaymentRule otherPaymentRule;
    @Inject
    protected PackageIdentifierRule packageIdentifierRule;
    @Inject
    protected PackageIndicatorRule packageIndicatorRule;
    @Inject
    protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
    @Inject
    protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
    @Inject
    protected PackageTransactionPriceRule packageTransactionPriceRule;
    @Inject
    protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
    @Inject
    protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
    @Inject
    protected PackageTransactionSpreadRule packageTransactionSpreadRule;
    @Inject
    protected PlatformAnonymousExecutionIndicatorRule platformAnonymousExecutionIndicatorRule;
    @Inject
    protected PlatformIdentifierRule platformIdentifierRule;
    @Inject
    protected PriceCurrencyRule priceCurrencyRule;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected PriceRule priceRule;
    @Inject
    protected PriceScheduleRule priceScheduleRule;
    @Inject
    protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
    @Inject
    protected PriorUSIRule priorUSIRule;
    @Inject
    protected PriorUTIRule priorUTIRule;
    @Inject
    protected PutAmountRule putAmountRule;
    @Inject
    protected PutCurrencyRule putCurrencyRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected ReturnorPayoutTriggerRule returnorPayoutTriggerRule;
    @Inject
    protected SellerIdentifierRule sellerIdentifierRule;
    @Inject
    protected SettlementLocationRule settlementLocationRule;
    @Inject
    protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
    @Inject
    protected StrikePriceNotationRule strikePriceNotationRule;
    @Inject
    protected StrikePriceRule strikePriceRule;
    @Inject
    protected StrikePriceScheduleRule strikePriceScheduleRule;
    @Inject
    protected SubmitterIdentifierRule submitterIdentifierRule;
    @Inject
    protected SubsequentPositionUTIRule subsequentPositionUTIRule;
    @Inject
    protected UnderlyingAssetTypeRule underlyingAssetTypeRule;
    @Inject
    protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
    @Inject
    protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
    @Inject
    protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
    @Inject
    protected emptyRuleRule _emptyRuleRule;

    public CSATransactionReportTrade evaluate(TransactionReportInstruction input) {
        CSATransactionReportTrade output;
        CSATransactionReportTrade.CSATransactionReportTradeBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(CSATransactionReportTrade.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract CSATransactionReportTrade.CSATransactionReportTradeBuilder doEvaluate(TransactionReportInstruction var1);

    public static class CSATradeReportFunctionDefault
    extends CSATradeReportFunction {
        @Override
        protected CSATransactionReportTrade.CSATransactionReportTradeBuilder doEvaluate(TransactionReportInstruction input) {
            CSATransactionReportTrade.CSATransactionReportTradeBuilder output = CSATransactionReportTrade.builder();
            return this.assignOutput(output, input);
        }

        protected CSATransactionReportTrade.CSATransactionReportTradeBuilder assignOutput(CSATransactionReportTrade.CSATransactionReportTradeBuilder output, TransactionReportInstruction input) {
            output.setEffectiveDate(this.effectiveDateRule.evaluate(input));
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setExecutionTimestamp(this.executionTimestampRule.evaluate(input));
            output.setExpirationDate(this.expirationDateRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setBuyerIdentifier(this.buyerIdentifierRule.evaluate(input));
            output.setSellerIdentifier(this.sellerIdentifierRule.evaluate(input));
            output.setClearedOverriddenAsClearedEnum(this.clearedRule.evaluate(input));
            output.setCentralCounterparty(this.centralCounterpartyIdentifierRule.evaluate(input));
            output.setClearingMember(this.clearingMemberIdentifierRule.evaluate(input));
            output.setCallAmount(this.callAmountRule.evaluate(input));
            output.setPutAmount(this.putAmountRule.evaluate(input));
            output.setCallCurrency(this.callCurrencyRule.evaluate(input));
            output.setPutCurrency(this.putCurrencyRule.evaluate(input));
            output.setPriceSchedule((List)this.priceScheduleRule.evaluate(input));
            output.setStrikePriceSchedule((List)this.strikePriceScheduleRule.evaluate(input));
            output.setPrice(this.priceRule.evaluate(input));
            output.setPriceNotation(this.priceNotationRule.evaluate(input));
            output.setPriceCurrency(this.priceCurrencyRule.evaluate(input));
            output.setPackageTransactionPrice(this.packageTransactionPriceRule.evaluate(input));
            output.setPackageTransactionPriceNotation(this.packageTransactionPriceNotationRule.evaluate(input));
            output.setPackageTransactionPriceCurrency(this.packageTransactionPriceCurrencyRule.evaluate(input));
            output.setPackageTransactionSpread(this.packageTransactionSpreadRule.evaluate(input));
            output.setPackageTransactionSpreadNotation(this.packageTransactionSpreadNotationRule.evaluate(input));
            output.setPackageTransactionSpreadCurrency(this.packageTransactionSpreadCurrencyRule.evaluate(input));
            output.setPackageIdentifier(this.packageIdentifierRule.evaluate(input));
            output.setStrikePrice(this.strikePriceRule.evaluate(input));
            output.setStrikePriceNotation(this.strikePriceNotationRule.evaluate(input));
            output.setStrikePriceCurrency(this.strikePriceCurrencyCurrencyPairRule.evaluate(input));
            output.setPriceUnitOfMeasure(this.priceUnitOfMeasureRule.evaluate(input));
            output.setOptionPremiumAmount(this.optionPremiumAmountRule.evaluate(input));
            output.setOptionPremiumCurrency(this.optionPremiumCurrencyRule.evaluate(input));
            output.setOptionPremiumPaymentDate(this.optionPremiumPaymentDateRule.evaluate(input));
            output.setExchangeRate(this.exchangeRateRule.evaluate(input));
            output.setExchangeRateBasis(this.exchangeRateBasisRule.evaluate(input));
            output.setCdSIndexAttachmentPoint(this.cDSIndexAttachmentPointRule.evaluate(input));
            output.setCdSIndexDetachmentPoint(this.cDSIndexDetachmentPointRule.evaluate(input));
            output.setFirstExerciseDate(this.firstExerciseDateRule.evaluate(input));
            output.setFinalContractualSettlementDate(this.finalContractualSettlementDateRule.evaluate(input));
            output.setSettlementLocation(this.settlementLocationRule.evaluate(input));
            output.setPriorUTI(this.priorUTIRule.evaluate(input));
            output.setCustomBasketCode(this.customBasketCodeRule.evaluate(input));
            output.setBasketConstituents((List)this.basketConstituentsRule.evaluate(input));
            output.setOtherPayment((List)this.otherPaymentRule.evaluate(input));
            output.setLeg1(this.leg1ReportRule.evaluate(input));
            output.setLeg2(this.leg2ReportRule.evaluate(input));
            output.setLevel(this.levelRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setEventType(this.eventTypeRule.evaluate(input));
            output.setEventIdentifier(this.eventIdentifierRule.evaluate(input));
            output.setEventTimestampOverriddenAsZonedDateTime(this.eventTimestampRule.evaluate(input));
            output.setReportSubmittingEntityID(this.submitterIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueProductIdentifier(this.uniqueProductIdentifierRule.evaluate(input));
            output.setPlatformIdentifier(this.platformIdentifierRule.evaluate(input));
            output.setEmbeddedOptionType(this.embeddedOptionTypeRule.evaluate(input));
            output.setIndexFactor(this.indexFactorRule.evaluate(input));
            output.setClearingAccountOrigin(this.clearingAccountOriginRule.evaluate(input));
            output.setClearingReceiptTimestamp(this.clearingReceiptTimestampRule.evaluate(input));
            output.setPriorUSI(this.priorUSIRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.initialMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCode(this.variationMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setSubsequentPositionUTI(this.subsequentPositionUTIRule.evaluate(input));
            output.setMasterAgreementType(this.masterAgreementTypeRule.evaluate(input));
            output.setMasterAgreementVersion(this.masterAgreementVersionRule.evaluate(input));
            output.setNonStandardizedTermIndicator(this.nonStandardizedTermIndicatorRule.evaluate(input));
            output.setAmendmentIndicator(this.amendmentIndicatorRule.evaluate(input));
            output.setPackageIndicator(this.packageIndicatorRule.evaluate(input));
            output.setBrokerID(this.brokerIdentifierRule.evaluate(input));
            output.setClearingExceptionsAndExemptionsCounterparty1((List)this.clearingExceptionsAndExemptionsCounterparty1Rule.evaluate(input));
            output.setClearingExceptionsAndExemptionsCounterparty2((List)this.clearingExceptionsAndExemptionsCounterparty2Rule.evaluate(input));
            output.setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(this.counterparty2IdentifierSourceRule.evaluate(input));
            output.setCustomBasketIndicator(this.customBasketIndicatorRule.evaluate(input));
            output.getOrCreateNonReportable().setEnrichment(this.enrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setPreUpiData(this.upiPreEnrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setPostUpiData(this.upiPostEnrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setNotionalSchedule(this.notionalScheduleRule.evaluate(input));
            output.getOrCreateNonReportable().setUnderlyingAssetType(this.underlyingAssetTypeRule.evaluate(input));
            output.getOrCreateNonReportable().setInstrumentType(this.instrumentTypeRule.evaluate(input));
            output.getOrCreateNonReportable().setReturnorPayoutTrigger(this.returnorPayoutTriggerRule.evaluate(input));
            output.getOrCreateNonReportable().setExecutionVenueType(this.executionVenueTypeRule.evaluate(input));
            output.setCountryAndProvinceOrTerritoryOfIndividual(this.countryAndProvinceOrTerritoryOfIndividualRule.evaluate(input));
            output.setJurisdictionOfCounterparty1((List)this.jurisdictionOfCounterparty1Rule.evaluate(input));
            output.setJurisdictionOfCounterparty2((List)this.jurisdictionOfCounterparty2Rule.evaluate(input));
            output.setInterAffiliateIndicator(this.interAffiliateIndicatorRule.evaluate(input));
            output.setPlatformAnonymousExecutionIndicator(this.platformAnonymousExecutionIndicatorRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setClearingVenueIDType(this.dTCC_ClearingVenueIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty1ClearingBrokerIDType(this.dTCC_TradeParty1ClearingBrokerIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setSubmittingPartyIDType(this.dTCC_SubmittingPartyIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setSubmittedForParty(this.dTCC_SubmittedForPartyRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeLegTypes(this.dTCC_TradeLegTypesRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty1ReportingDestination((List)this.dTCC_TradeParty1ReportingDestinationRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty2ReportingDestination((List)this.dTCC_TradeParty2ReportingDestinationRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setPrimaryAssetClass(this.dTCC_PrimaryAssetClassRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setSecondaryAssetClass(this.dTCC_SecondaryAssetClassRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setComment1(null);
            output.getOrCreateDtccAdditionalFields().setOptionStyle(this.dTCC_OptionStyleRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setOptionType(this.dTCC_OptionTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setProductID(this.dTCC_ProductIDRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty2ExecutionAgentID(this.dTCC_TradeParty2ExecutionAgentIDRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty2ExecutionAgentIDType(this.dTCC_TradeParty2ExecutionAgentIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty1ExecutionAgentID(this.dTCC_TradeParty1ExecutionAgentIDRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty1ExecutionAgentIDType(this.dTCC_TradeParty1ExecutionAgentIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty1TransactionID(this.dTCC_TradeParty1TransactionIDRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setSettlementType(this.dTCC_SettlementTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setProductGrade((List)this.dTCC_ProductGradeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setDeliveryLocation(this.dTCC_DeliveryLocationRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setLeg1CommodityInstrumentID(null);
            output.getOrCreateDtccAdditionalFields().setLeg2CommodityInstrumentID(null);
            output.getOrCreateDtccAdditionalFields().setResponsibleDataSubmitterIDType(null);
            output.getOrCreateDtccAdditionalFields().setResponsibleDataSubmitterID(null);
            output.getOrCreateDtccAdditionalFields().setMaturityDateOfTheUnderlying(this.dTCC_MaturityDateOfTheUnderlyingRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setCorporateActionNewTradeParty1Lei(null);
            output.getOrCreateDtccAdditionalFields().setOtherPaymentPayerIDType((List)this.dTCC_OtherPaymentPayerIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setOtherPaymentReceiverIDType((List)this.dTCC_OtherPaymentReceiverIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setSefOrDcmAnonymousExecutionIndicator(this.dTCC_SEFOrDCMAnonymousExecutionIndicatorRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setExecutionVenueID(this.dTCC_ExecutionVenueIDRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setExecutionVenueIDType(this.dTCC_ExecutionVenueIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setLeg1FloatingRateIndex(null);
            output.getOrCreateDtccAdditionalFields().setLeg2FloatingRateIndex(null);
            output.getOrCreateDtccAdditionalFields().setUnderlyingAssetName(this.dTCC_UnderlyingAssetNameRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setUnderlyingAssetID(null);
            output.getOrCreateDtccAdditionalFields().setTradeParty1IDType(this.dTCC_TradeParty1IDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setAllocationType(this.dTCC_AllocationTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setUsiID(this.dTCC_USIIDRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setUsiIDPrefix(null);
            output.getOrCreateDtccAdditionalFields().setNewSDRIdentifier(this.dTCC_NewSDRIdentifierRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setMessageID(this.dTCC_MessageIDRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setLeg1CommodityUnderlyerID(null);
            output.getOrCreateDtccAdditionalFields().setLeg2CommodityUnderlyerID(null);
            output.getOrCreateDtccAdditionalFields().setMessageTypeTransaction(this.dTCC_MessageTypeTransactionRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setMessageTypePPD(null);
            output.getOrCreateDtccAdditionalFields().setUnderlyingAsset(this.dTCC_UnderlyingAssetReportRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setLeg1SettlementPeriod(null);
            output.getOrCreateDtccAdditionalFields().setLoadType(this.dTCC_LoadTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setTradeParty1BrokerIDType(this.dTCC_TradeParty1BrokerIDTypeRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setVersionTransaction(this.dTCC_VersionTransactionRule.evaluate(input));
            output.getOrCreateDtccAdditionalFields().setVersionPPD(null);
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

