/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsVarianceSwap;
import drr.base.qualification.product.functions.IsVolatilitySwap;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.ProductForEvent;
import drr.base.util.party.functions.CounterpartiesForEvent;
import drr.base.util.party.functions.PartyLeiAndPersonByRoles;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.regulation.csa.rewrite.trade.reports.SellerIdentifierRule;
import drr.standards.iosco.cde.version3.party.functions.ReceiverParty;
import javax.inject.Inject;

@ImplementedBy(value=ReceiverIdentifierLeg2RuleDefault.class)
public abstract class ReceiverIdentifierLeg2Rule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected CounterpartiesForEvent counterpartiesForEvent;
    @Inject
    protected IsVarianceSwap isVarianceSwap;
    @Inject
    protected IsVolatilitySwap isVolatilitySwap;
    @Inject
    protected PartyLeiAndPersonByRoles partyLeiAndPersonByRoles;
    @Inject
    protected PayoutLeg2Rule payoutLeg2Rule;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected ReceiverParty receiverParty;
    @Inject
    protected SellerIdentifierRule sellerIdentifierRule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class ReceiverIdentifierLeg2RuleDefault
    extends ReceiverIdentifierLeg2Rule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            output = ExpressionOperators.notExists((Mapper)MapperS.of((Object)this.sellerIdentifierRule.evaluate(input))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVarianceSwap.evaluate(this.productForEvent.evaluate(input))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVolatilitySwap.evaluate(this.productForEvent.evaluate(input))))).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)input).mapSingleToItem(item -> {
                ReferenceWithMetaParty referenceWithMetaParty = (ReferenceWithMetaParty)item.map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
                return MapperS.of((Object)this.partyLeiAndPersonByRoles.evaluate(this.receiverParty.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)item.get()), this.counterpartiesForEvent.evaluate((ReportableEventBase)item.get())), referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()));
            }).get() : null;
            return output;
        }
    }
}

