/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.price.PriceNotationEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.functions.DefaultPercentageToDecimal;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.regulation.csa.rewrite.trade.functions.IsCSALeg1Aligned;
import drr.standards.iosco.cde.version3.price.reports.SpreadNotationEnumRule;
import javax.inject.Inject;

@ImplementedBy(value=SpreadNotationLeg1RuleDefault.class)
public abstract class SpreadNotationLeg1Rule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected DefaultPercentageToDecimal defaultPercentageToDecimal;
    @Inject
    protected IsCSALeg1Aligned isCSALeg1Aligned;
    @Inject
    protected PayoutLeg1Rule payoutLeg1Rule;
    @Inject
    protected PayoutLeg2Rule payoutLeg2Rule;
    @Inject
    protected SpreadNotationEnumRule spreadNotationEnumRule;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class SpreadNotationLeg1RuleDefault
    extends SpreadNotationLeg1Rule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            output = (PriceNotationEnum)((Object)MapperS.of((Object)input).mapSingleToItem(item -> {
                Boolean _boolean = this.isCSALeg1Aligned.evaluate((ReportableEventBase)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)((Object)this.defaultPercentageToDecimal.evaluate(this.spreadNotationEnumRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())), false)));
                }
                return MapperS.of((Object)((Object)this.defaultPercentageToDecimal.evaluate(this.spreadNotationEnumRule.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)item.get())), false)));
            }).get());
            return output;
        }
    }
}

