/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReportTrade;
import drr.standards.iosco.upi.AnnaDsbReturnorPayoutTriggerEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportTradeCSA_VR_0133_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportTradeCSA_VR_0133_01
extends Validator<CSATransactionReportTrade> {
    public static final String NAME = "CSATransactionReportTradeCSA_VR_0133_01";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Derived -> ReturnorPayoutTrigger exists and nonReportable -> postUpiData -> Derived -> ReturnorPayoutTrigger <> Contract_for_Difference_CFD_) or nonReportable -> returnorPayoutTrigger <> \"Contract_for_Difference_CFD_\" then finalContractualSettlementDate exists and finalContractualSettlementDate >= expirationDate else finalContractualSettlementDate is absent";

    public static class NoOp
    implements CSATransactionReportTradeCSA_VR_0133_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportTradeCSA_VR_0133_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
            ComparisonResult result = this.executeDataRule(cSATransactionReportTrade);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportTradeCSA_VR_0133_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReportTrade", (RosettaPath)path, (String)CSATransactionReportTradeCSA_VR_0133_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportTradeCSA_VR_0133_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReportTrade", (RosettaPath)path, (String)CSATransactionReportTradeCSA_VR_0133_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReportTrade cSATransactionReportTrade) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getNonReportable", _cSATransactionReportTrade -> _cSATransactionReportTrade.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).map("getReturnorPayoutTrigger", annaDsbDerived -> annaDsbDerived.getReturnorPayoutTrigger())).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getNonReportable", _cSATransactionReportTrade -> _cSATransactionReportTrade.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getDerived", annaDsbUpiRecord -> annaDsbUpiRecord.getDerived()).map("getReturnorPayoutTrigger", annaDsbDerived -> annaDsbDerived.getReturnorPayoutTrigger()), (Mapper)MapperS.of((Object)((Object)AnnaDsbReturnorPayoutTriggerEnum.CONTRACT_FOR_DIFFERENCE_CFD)), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getNonReportable", _cSATransactionReportTrade -> _cSATransactionReportTrade.getNonReportable()).map("getReturnorPayoutTrigger", cSANonReportable -> cSANonReportable.getReturnorPayoutTrigger()), (Mapper)MapperS.of((Object)"Contract_for_Difference_CFD_"), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getFinalContractualSettlementDate", _cSATransactionReportTrade -> _cSATransactionReportTrade.getFinalContractualSettlementDate())).and(ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getFinalContractualSettlementDate", _cSATransactionReportTrade -> _cSATransactionReportTrade.getFinalContractualSettlementDate()), (Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getExpirationDate", _cSATransactionReportTrade -> _cSATransactionReportTrade.getExpirationDate()), (CardinalityOperator)CardinalityOperator.All));
                }
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getFinalContractualSettlementDate", _cSATransactionReportTrade -> _cSATransactionReportTrade.getFinalContractualSettlementDate()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

