/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.qualification.event.functions.IsVRAllowedForActionType;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_1012_01")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_1012_01
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_1012_01";
    public static final String DEFINITION = "if IsVRAllowedForActionType(actionType) then if natureOfCounterparty2 = F then corporateSectorOfTheCounterparty2 extract ([\"INVF\", \"CDTI\", \"INUN\", \"UCIT\", \"ORPI\", \"AIFD\", \"CSDS\"] any = item) then all = True";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_1012_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_1012_01 {
        @Inject
        protected IsVRAllowedForActionType isVRAllowedForActionType;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_1012_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_1012_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_1012_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_1012_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                Boolean _boolean = this.isVRAllowedForActionType.evaluate((ActionTypeEnum)((Object)MapperS.of((Object)eSMAEMIRTransactionReport).map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get()));
                MapperC thenArg = _boolean != null && _boolean.booleanValue() ? (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getNatureOfCounterparty2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getNatureOfCounterparty2()), (Mapper)MapperS.of((Object)((Object)NatureOfCounterpartyEnum.F)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? MapperS.of((Object)eSMAEMIRTransactionReport).mapC("getCorporateSectorOfTheCounterparty2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getCorporateSectorOfTheCounterparty2()).mapItem(item -> ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)"INVF"), MapperS.of((Object)"CDTI"), MapperS.of((Object)"INUN"), MapperS.of((Object)"UCIT"), MapperS.of((Object)"ORPI"), MapperS.of((Object)"AIFD"), MapperS.of((Object)"CSDS")}), (Mapper)item, (CardinalityOperator)CardinalityOperator.Any).asMapper()) : MapperC.ofNull()) : MapperC.ofNull();
                return ComparisonResult.of((Mapper)ExpressionOperators.areEqual((Mapper)thenArg, (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).asMapper());
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

