/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.valuation.CommonValuationReport;
import drr.regulation.fca.ukemir.refit.valuation.NonReportable;
import drr.regulation.fca.ukemir.refit.valuation.meta.FCAValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FCAValuationReport", builder=FCAValuationReportBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="FCAValuationReport", model="drr", builder=FCAValuationReportBuilderImpl.class, version="7.0.0-dev.52")
public interface FCAValuationReport
extends CommonValuationReport {
    public static final FCAValuationReportMeta metaData = new FCAValuationReportMeta();

    @Override
    public Date getEventDate();

    @Override
    public ReportLevelEnum getLevel();

    public NonReportable getNonReportable();

    @Override
    public FCAValuationReport build();

    @Override
    public FCAValuationReportBuilder toBuilder();

    public static FCAValuationReportBuilder builder() {
        return new FCAValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends FCAValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FCAValuationReport> getType() {
        return FCAValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
    }

    public static class FCAValuationReportBuilderImpl
    extends CommonValuationReport.CommonValuationReportBuilderImpl
    implements FCAValuationReportBuilder {
        protected Date eventDate;
        protected ReportLevelEnum level;
        protected NonReportable.NonReportableBuilder nonReportable;

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public NonReportable.NonReportableBuilder getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public NonReportable.NonReportableBuilder getOrCreateNonReportable() {
            NonReportable.NonReportableBuilder result = this.nonReportable != null ? this.nonReportable : (this.nonReportable = NonReportable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public FCAValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public FCAValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public FCAValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public FCAValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public FCAValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public FCAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public FCAValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public FCAValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public FCAValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public FCAValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public FCAValuationReportBuilder setLevelOverriddenAsReportLevelEnum(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaIgnore
        public FCAValuationReportBuilder setLevel(ReportLevelEnum _level) {
            return this.setLevelOverriddenAsReportLevelEnum(_level);
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public FCAValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public FCAValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public FCAValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public FCAValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public FCAValuationReportBuilder setEventDateOverriddenAsDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaIgnore
        public FCAValuationReportBuilder setEventDate(Date _eventDate) {
            return this.setEventDateOverriddenAsDate(_eventDate);
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public FCAValuationReportBuilder setNonReportable(NonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        public FCAValuationReport build() {
            return new FCAValuationReportImpl(this);
        }

        @Override
        public FCAValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public FCAValuationReportBuilder prune() {
            super.prune();
            if (this.nonReportable != null && !this.nonReportable.prune().hasData()) {
                this.nonReportable = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            if (this.getLevel() != null) {
                return true;
            }
            return this.getNonReportable() != null && this.getNonReportable().hasData();
        }

        @Override
        public FCAValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FCAValuationReportBuilder o = (FCAValuationReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonReportable(), (RosettaModelObjectBuilder)o.getNonReportable(), this::setNonReportable);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDateOverriddenAsDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLevel(), (Object)o.getLevel(), this::setLevelOverriddenAsReportLevelEnum, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FCAValuationReport _that = (FCAValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.level, (Object)_that.getLevel())) {
                return false;
            }
            return Objects.equals(this.nonReportable, _that.getNonReportable());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FCAValuationReportBuilder {eventDate=" + String.valueOf(this.eventDate) + ", level=" + String.valueOf((Object)this.level) + ", nonReportable=" + String.valueOf(this.nonReportable) + "} " + super.toString();
        }
    }

    public static interface FCAValuationReportBuilder
    extends FCAValuationReport,
    CommonValuationReport.CommonValuationReportBuilder {
        public NonReportable.NonReportableBuilder getOrCreateNonReportable();

        @Override
        public NonReportable.NonReportableBuilder getNonReportable();

        @Override
        public FCAValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public FCAValuationReportBuilder setCounterparty1(String var1);

        @Override
        public FCAValuationReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public FCAValuationReportBuilder setCounterparty2(String var1);

        @Override
        public FCAValuationReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public FCAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public FCAValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public FCAValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public FCAValuationReportBuilder setDelta(BigDecimal var1);

        @Override
        public FCAValuationReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public FCAValuationReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public FCAValuationReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public FCAValuationReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public FCAValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public FCAValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public FCAValuationReportBuilder setEventDate(Date var1);

        public FCAValuationReportBuilder setEventDateOverriddenAsDate(Date var1);

        public FCAValuationReportBuilder setLevelOverriddenAsReportLevelEnum(ReportLevelEnum var1);

        public FCAValuationReportBuilder setNonReportable(NonReportable var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.NonReportableBuilder.class, this.getNonReportable(), new AttributeMeta[0]);
        }

        @Override
        public FCAValuationReportBuilder prune();
    }

    public static class FCAValuationReportImpl
    extends CommonValuationReport.CommonValuationReportImpl
    implements FCAValuationReport {
        private final Date eventDate;
        private final ReportLevelEnum level;
        private final NonReportable nonReportable;

        protected FCAValuationReportImpl(FCAValuationReportBuilder builder) {
            super(builder);
            this.eventDate = builder.getEventDate();
            this.level = builder.getLevel();
            this.nonReportable = Optional.ofNullable(builder.getNonReportable()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="level", isRequired=true)
        @RuneAttribute(value="level", isRequired=true)
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public NonReportable getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public FCAValuationReport build() {
            return this;
        }

        @Override
        public FCAValuationReportBuilder toBuilder() {
            FCAValuationReportBuilder builder = FCAValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FCAValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDateOverriddenAsDate);
            Optional.ofNullable(this.getLevel()).ifPresent(builder::setLevelOverriddenAsReportLevelEnum);
            Optional.ofNullable(this.getNonReportable()).ifPresent(builder::setNonReportable);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FCAValuationReport _that = (FCAValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.level, (Object)_that.getLevel())) {
                return false;
            }
            return Objects.equals(this.nonReportable, _that.getNonReportable());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FCAValuationReport {eventDate=" + String.valueOf(this.eventDate) + ", level=" + String.valueOf((Object)this.level) + ", nonReportable=" + String.valueOf(this.nonReportable) + "} " + super.toString();
        }
    }
}

