/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.contract.reports.OptionTypeRule;
import drr.regulation.common.trade.party.reports.Counterparty2NameRule;
import drr.regulation.common.trade.party.reports.EntityResponsibleForReportingRule;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty1Rule;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty2Rule;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import drr.regulation.hkma.rewrite.trade.labels.HKMATradeLabelProvider;
import drr.regulation.hkma.rewrite.trade.reports.AssetClassRule;
import drr.regulation.hkma.rewrite.trade.reports.BaseProductRule;
import drr.regulation.hkma.rewrite.trade.reports.BasketConstituentsRule;
import drr.regulation.hkma.rewrite.trade.reports.BeneficiaryRule;
import drr.regulation.hkma.rewrite.trade.reports.BookingLocationRule;
import drr.regulation.hkma.rewrite.trade.reports.BrokerIdRule;
import drr.regulation.hkma.rewrite.trade.reports.BrokerIdentifierFormatRule;
import drr.regulation.hkma.rewrite.trade.reports.BrokerSchemeNameRule;
import drr.regulation.hkma.rewrite.trade.reports.BuyerIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.CallAmountRule;
import drr.regulation.hkma.rewrite.trade.reports.CallCurrencyRule;
import drr.regulation.hkma.rewrite.trade.reports.CdsIndexAttachmentPointRule;
import drr.regulation.hkma.rewrite.trade.reports.CdsIndexDetachmentPointRule;
import drr.regulation.hkma.rewrite.trade.reports.CentralCounterpartyIdentifierFormatRule;
import drr.regulation.hkma.rewrite.trade.reports.CentralCounterpartyRule;
import drr.regulation.hkma.rewrite.trade.reports.CentralCounterpartySchemeNameRule;
import drr.regulation.hkma.rewrite.trade.reports.ClearedRule;
import drr.regulation.hkma.rewrite.trade.reports.ClearingMemberIdentifierFormatRule;
import drr.regulation.hkma.rewrite.trade.reports.ClearingMemberRule;
import drr.regulation.hkma.rewrite.trade.reports.ClearingMemberSchemeNameRule;
import drr.regulation.hkma.rewrite.trade.reports.ClearingTimestampRule;
import drr.regulation.hkma.rewrite.trade.reports.ConfirmedRule;
import drr.regulation.hkma.rewrite.trade.reports.ContractPriceScheduleRule;
import drr.regulation.hkma.rewrite.trade.reports.ContractTypeRule;
import drr.regulation.hkma.rewrite.trade.reports.Counterparty2IdentifierFormatRule;
import drr.regulation.hkma.rewrite.trade.reports.Counterparty2Rule;
import drr.regulation.hkma.rewrite.trade.reports.Counterparty2SchemeNameRule;
import drr.regulation.hkma.rewrite.trade.reports.CountryOfTheCounterparty2Rule;
import drr.regulation.hkma.rewrite.trade.reports.CryptoAssetUnderlyingIndicatorRule;
import drr.regulation.hkma.rewrite.trade.reports.CustomBasketCodeRule;
import drr.regulation.hkma.rewrite.trade.reports.DeliveryTypeRule;
import drr.regulation.hkma.rewrite.trade.reports.Direction1Rule;
import drr.regulation.hkma.rewrite.trade.reports.EarlyTerminationDateRule;
import drr.regulation.hkma.rewrite.trade.reports.EffectiveDateRule;
import drr.regulation.hkma.rewrite.trade.reports.EmbeddedOptionTypeRule;
import drr.regulation.hkma.rewrite.trade.reports.EventIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.EventTimestampRule;
import drr.regulation.hkma.rewrite.trade.reports.EventTypeRule;
import drr.regulation.hkma.rewrite.trade.reports.ExchangeRateBasisRule;
import drr.regulation.hkma.rewrite.trade.reports.ExchangeRateRule;
import drr.regulation.hkma.rewrite.trade.reports.ExecutionTimestampRule;
import drr.regulation.hkma.rewrite.trade.reports.ExpirationDateRule;
import drr.regulation.hkma.rewrite.trade.reports.FinalContractualSettlementDateRule;
import drr.regulation.hkma.rewrite.trade.reports.FirstExerciseDateRule;
import drr.regulation.hkma.rewrite.trade.reports.FurtherSubProductRule;
import drr.regulation.hkma.rewrite.trade.reports.IndexFactorRule;
import drr.regulation.hkma.rewrite.trade.reports.InitialMarginCollateralPortfolioCodeRule;
import drr.regulation.hkma.rewrite.trade.reports.IntragroupRule;
import drr.regulation.hkma.rewrite.trade.reports.Leg1ReportRule;
import drr.regulation.hkma.rewrite.trade.reports.Leg2ReportRule;
import drr.regulation.hkma.rewrite.trade.reports.MaturityDateOfTheUnderlyingDerivativeRule;
import drr.regulation.hkma.rewrite.trade.reports.NameOfTheUnderlyingIndexRule;
import drr.regulation.hkma.rewrite.trade.reports.NatureOfTheCounterparty1Rule;
import drr.regulation.hkma.rewrite.trade.reports.NatureOfTheCounterparty2Rule;
import drr.regulation.hkma.rewrite.trade.reports.NonStandardizedTermIndicatorRule;
import drr.regulation.hkma.rewrite.trade.reports.OptionPremiumAmountRule;
import drr.regulation.hkma.rewrite.trade.reports.OptionPremiumCurrencyRule;
import drr.regulation.hkma.rewrite.trade.reports.OptionPremiumPaymentDateRule;
import drr.regulation.hkma.rewrite.trade.reports.OptionStyleRule;
import drr.regulation.hkma.rewrite.trade.reports.OtherPaymentRule;
import drr.regulation.hkma.rewrite.trade.reports.PackageIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.PackageTransactionPriceCurrencyRule;
import drr.regulation.hkma.rewrite.trade.reports.PackageTransactionPriceNotationRule;
import drr.regulation.hkma.rewrite.trade.reports.PackageTransactionPriceRule;
import drr.regulation.hkma.rewrite.trade.reports.PackageTransactionSpreadCurrencyRule;
import drr.regulation.hkma.rewrite.trade.reports.PackageTransactionSpreadNotationRule;
import drr.regulation.hkma.rewrite.trade.reports.PackageTransactionSpreadRule;
import drr.regulation.hkma.rewrite.trade.reports.PlatformIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.PriceCurrencyRule;
import drr.regulation.hkma.rewrite.trade.reports.PriceNotationRule;
import drr.regulation.hkma.rewrite.trade.reports.PriceRule;
import drr.regulation.hkma.rewrite.trade.reports.PriceUnitOfMeasureRule;
import drr.regulation.hkma.rewrite.trade.reports.PriorUTIProprietaryRule;
import drr.regulation.hkma.rewrite.trade.reports.PriorUTIProprietarySchemeNameRule;
import drr.regulation.hkma.rewrite.trade.reports.PriorUTIRule;
import drr.regulation.hkma.rewrite.trade.reports.ProductDescriptionRule;
import drr.regulation.hkma.rewrite.trade.reports.PutAmountRule;
import drr.regulation.hkma.rewrite.trade.reports.PutCurrencyRule;
import drr.regulation.hkma.rewrite.trade.reports.ReferenceEntityFormatRule;
import drr.regulation.hkma.rewrite.trade.reports.ReferenceEntityRule;
import drr.regulation.hkma.rewrite.trade.reports.SecondaryTransactionIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.SectorOfTheCounterparty1Rule;
import drr.regulation.hkma.rewrite.trade.reports.SectorOfTheCounterparty2Rule;
import drr.regulation.hkma.rewrite.trade.reports.SellerIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.SeniorityRule;
import drr.regulation.hkma.rewrite.trade.reports.SeriesRule;
import drr.regulation.hkma.rewrite.trade.reports.SeriesVersionRule;
import drr.regulation.hkma.rewrite.trade.reports.SettlementLocationRule;
import drr.regulation.hkma.rewrite.trade.reports.StrikePriceCurrencyCurrencyPairRule;
import drr.regulation.hkma.rewrite.trade.reports.StrikePriceNotationRule;
import drr.regulation.hkma.rewrite.trade.reports.StrikePriceRule;
import drr.regulation.hkma.rewrite.trade.reports.StrikePriceScheduleRule;
import drr.regulation.hkma.rewrite.trade.reports.SubProductRule;
import drr.regulation.hkma.rewrite.trade.reports.SubmitterIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.SwapLinkIDRule;
import drr.regulation.hkma.rewrite.trade.reports.TechnicalRecordIdentificationRule;
import drr.regulation.hkma.rewrite.trade.reports.TraderLocationRule;
import drr.regulation.hkma.rewrite.trade.reports.TradingCapacityRule;
import drr.regulation.hkma.rewrite.trade.reports.UnderlierIdOtherRule;
import drr.regulation.hkma.rewrite.trade.reports.UnderlierIdOtherSourceRule;
import drr.regulation.hkma.rewrite.trade.reports.UnderlyingAssetPriceSourceRule;
import drr.regulation.hkma.rewrite.trade.reports.UnderlyingAssetTradingPlatformIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.UnderlyingIdentificationRule;
import drr.regulation.hkma.rewrite.trade.reports.UnderlyingIdentificationTypeRule;
import drr.regulation.hkma.rewrite.trade.reports.UniqueProductIdentifierProprietaryRule;
import drr.regulation.hkma.rewrite.trade.reports.UniqueProductIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.hkma.rewrite.trade.reports.UniqueTransactionIdentifierProprietarySchemeNameRule;
import drr.regulation.hkma.rewrite.trade.reports.UniqueTransactionIdentifierRule;
import drr.regulation.hkma.rewrite.trade.reports.VariationMarginCollateralPortfolioCodeRule;
import drr.regulation.hkma.rewrite.trade.reports.barrierRule;
import drr.standards.iosco.cde.version3.collateral.reports.CollateralPortfolioIndicatorRule;
import drr.standards.iosco.cde.version3.datetime.reports.ReportingTimestampRule;
import drr.standards.iosco.cde.version3.event.reports.ActionTypeRule;
import drr.standards.iosco.cde.version3.party.reports.Beneficiary1IdentifierTypeIndicatorRule;
import drr.standards.iosco.cde.version3.party.reports.Beneficiary1Rule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty1Rule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty2IdentifierTypeIndicatorRule;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.hkma.rewrite.trade", body="HKMA", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=HKMATradeLabelProvider.class)
@ImplementedBy(value=HKMATradeReportFunctionDefault.class)
public abstract class HKMATradeReportFunction
implements ReportFunction<TransactionReportInstruction, HKMATransactionReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected AssetClassRule assetClassRule;
    @Inject
    protected BaseProductRule baseProductRule;
    @Inject
    protected BasketConstituentsRule basketConstituentsRule;
    @Inject
    protected Beneficiary1IdentifierTypeIndicatorRule beneficiary1IdentifierTypeIndicatorRule;
    @Inject
    protected Beneficiary1Rule beneficiary1Rule;
    @Inject
    protected BeneficiaryRule beneficiaryRule;
    @Inject
    protected BookingLocationRule bookingLocationRule;
    @Inject
    protected BrokerIdRule brokerIdRule;
    @Inject
    protected BrokerIdentifierFormatRule brokerIdentifierFormatRule;
    @Inject
    protected BrokerSchemeNameRule brokerSchemeNameRule;
    @Inject
    protected BuyerIdentifierRule buyerIdentifierRule;
    @Inject
    protected CallAmountRule callAmountRule;
    @Inject
    protected CallCurrencyRule callCurrencyRule;
    @Inject
    protected CdsIndexAttachmentPointRule cdsIndexAttachmentPointRule;
    @Inject
    protected CdsIndexDetachmentPointRule cdsIndexDetachmentPointRule;
    @Inject
    protected CentralCounterpartyIdentifierFormatRule centralCounterpartyIdentifierFormatRule;
    @Inject
    protected CentralCounterpartyRule centralCounterpartyRule;
    @Inject
    protected CentralCounterpartySchemeNameRule centralCounterpartySchemeNameRule;
    @Inject
    protected ClearedRule clearedRule;
    @Inject
    protected ClearingMemberIdentifierFormatRule clearingMemberIdentifierFormatRule;
    @Inject
    protected ClearingMemberRule clearingMemberRule;
    @Inject
    protected ClearingMemberSchemeNameRule clearingMemberSchemeNameRule;
    @Inject
    protected ClearingTimestampRule clearingTimestampRule;
    @Inject
    protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
    @Inject
    protected ConfirmedRule confirmedRule;
    @Inject
    protected ContractPriceScheduleRule contractPriceScheduleRule;
    @Inject
    protected ContractTypeRule contractTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierFormatRule counterparty2IdentifierFormatRule;
    @Inject
    protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
    @Inject
    protected Counterparty2NameRule counterparty2NameRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected Counterparty2SchemeNameRule counterparty2SchemeNameRule;
    @Inject
    protected CountryOfTheCounterparty2Rule countryOfTheCounterparty2Rule;
    @Inject
    protected CryptoAssetUnderlyingIndicatorRule cryptoAssetUnderlyingIndicatorRule;
    @Inject
    protected CustomBasketCodeRule customBasketCodeRule;
    @Inject
    protected DeliveryTypeRule deliveryTypeRule;
    @Inject
    protected Direction1Rule direction1Rule;
    @Inject
    protected EarlyTerminationDateRule earlyTerminationDateRule;
    @Inject
    protected EffectiveDateRule effectiveDateRule;
    @Inject
    protected EmbeddedOptionTypeRule embeddedOptionTypeRule;
    @Inject
    protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
    @Inject
    protected EventIdentifierRule eventIdentifierRule;
    @Inject
    protected EventTimestampRule eventTimestampRule;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected ExchangeRateBasisRule exchangeRateBasisRule;
    @Inject
    protected ExchangeRateRule exchangeRateRule;
    @Inject
    protected ExecutionAgentCounterparty1Rule executionAgentCounterparty1Rule;
    @Inject
    protected ExecutionAgentCounterparty2Rule executionAgentCounterparty2Rule;
    @Inject
    protected ExecutionTimestampRule executionTimestampRule;
    @Inject
    protected ExpirationDateRule expirationDateRule;
    @Inject
    protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
    @Inject
    protected FirstExerciseDateRule firstExerciseDateRule;
    @Inject
    protected FurtherSubProductRule furtherSubProductRule;
    @Inject
    protected IndexFactorRule indexFactorRule;
    @Inject
    protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
    @Inject
    protected IntragroupRule intragroupRule;
    @Inject
    protected Leg1ReportRule leg1ReportRule;
    @Inject
    protected Leg2ReportRule leg2ReportRule;
    @Inject
    protected MaturityDateOfTheUnderlyingDerivativeRule maturityDateOfTheUnderlyingDerivativeRule;
    @Inject
    protected NameOfTheUnderlyingIndexRule nameOfTheUnderlyingIndexRule;
    @Inject
    protected NatureOfTheCounterparty1Rule natureOfTheCounterparty1Rule;
    @Inject
    protected NatureOfTheCounterparty2Rule natureOfTheCounterparty2Rule;
    @Inject
    protected NonStandardizedTermIndicatorRule nonStandardizedTermIndicatorRule;
    @Inject
    protected OptionPremiumAmountRule optionPremiumAmountRule;
    @Inject
    protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
    @Inject
    protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
    @Inject
    protected OptionStyleRule optionStyleRule;
    @Inject
    protected OptionTypeRule optionTypeRule;
    @Inject
    protected OtherPaymentRule otherPaymentRule;
    @Inject
    protected PackageIdentifierRule packageIdentifierRule;
    @Inject
    protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
    @Inject
    protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
    @Inject
    protected PackageTransactionPriceRule packageTransactionPriceRule;
    @Inject
    protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
    @Inject
    protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
    @Inject
    protected PackageTransactionSpreadRule packageTransactionSpreadRule;
    @Inject
    protected PlatformIdentifierRule platformIdentifierRule;
    @Inject
    protected PriceCurrencyRule priceCurrencyRule;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected PriceRule priceRule;
    @Inject
    protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
    @Inject
    protected PriorUTIProprietaryRule priorUTIProprietaryRule;
    @Inject
    protected PriorUTIProprietarySchemeNameRule priorUTIProprietarySchemeNameRule;
    @Inject
    protected PriorUTIRule priorUTIRule;
    @Inject
    protected ProductDescriptionRule productDescriptionRule;
    @Inject
    protected PutAmountRule putAmountRule;
    @Inject
    protected PutCurrencyRule putCurrencyRule;
    @Inject
    protected ReferenceEntityFormatRule referenceEntityFormatRule;
    @Inject
    protected ReferenceEntityRule referenceEntityRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected SecondaryTransactionIdentifierRule secondaryTransactionIdentifierRule;
    @Inject
    protected SectorOfTheCounterparty1Rule sectorOfTheCounterparty1Rule;
    @Inject
    protected SectorOfTheCounterparty2Rule sectorOfTheCounterparty2Rule;
    @Inject
    protected SellerIdentifierRule sellerIdentifierRule;
    @Inject
    protected SeniorityRule seniorityRule;
    @Inject
    protected SeriesRule seriesRule;
    @Inject
    protected SeriesVersionRule seriesVersionRule;
    @Inject
    protected SettlementLocationRule settlementLocationRule;
    @Inject
    protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
    @Inject
    protected StrikePriceNotationRule strikePriceNotationRule;
    @Inject
    protected StrikePriceRule strikePriceRule;
    @Inject
    protected StrikePriceScheduleRule strikePriceScheduleRule;
    @Inject
    protected SubProductRule subProductRule;
    @Inject
    protected SubmitterIdentifierRule submitterIdentifierRule;
    @Inject
    protected SwapLinkIDRule swapLinkIDRule;
    @Inject
    protected TechnicalRecordIdentificationRule technicalRecordIdentificationRule;
    @Inject
    protected TraderLocationRule traderLocationRule;
    @Inject
    protected TradingCapacityRule tradingCapacityRule;
    @Inject
    protected UnderlierIdOtherRule underlierIdOtherRule;
    @Inject
    protected UnderlierIdOtherSourceRule underlierIdOtherSourceRule;
    @Inject
    protected UnderlyingAssetPriceSourceRule underlyingAssetPriceSourceRule;
    @Inject
    protected UnderlyingAssetTradingPlatformIdentifierRule underlyingAssetTradingPlatformIdentifierRule;
    @Inject
    protected UnderlyingIdentificationRule underlyingIdentificationRule;
    @Inject
    protected UnderlyingIdentificationTypeRule underlyingIdentificationTypeRule;
    @Inject
    protected UniqueProductIdentifierProprietaryRule uniqueProductIdentifierProprietaryRule;
    @Inject
    protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierProprietarySchemeNameRule uniqueTransactionIdentifierProprietarySchemeNameRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
    @Inject
    protected barrierRule _barrierRule;

    public HKMATransactionReport evaluate(TransactionReportInstruction input) {
        HKMATransactionReport output;
        HKMATransactionReport.HKMATransactionReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(HKMATransactionReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract HKMATransactionReport.HKMATransactionReportBuilder doEvaluate(TransactionReportInstruction var1);

    public static class HKMATradeReportFunctionDefault
    extends HKMATradeReportFunction {
        @Override
        protected HKMATransactionReport.HKMATransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
            HKMATransactionReport.HKMATransactionReportBuilder output = HKMATransactionReport.builder();
            return this.assignOutput(output, input);
        }

        protected HKMATransactionReport.HKMATransactionReportBuilder assignOutput(HKMATransactionReport.HKMATransactionReportBuilder output, TransactionReportInstruction input) {
            output.setEffectiveDate(this.effectiveDateRule.evaluate(input));
            output.setEarlyTerminationDate(this.earlyTerminationDateRule.evaluate(input));
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setExecutionTimestamp(this.executionTimestampRule.evaluate(input));
            output.setExpirationDate(this.expirationDateRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setCounterparty2IdentifierTypeOverriddenAsBoolean(this.counterparty2IdentifierTypeIndicatorRule.evaluate(input));
            output.setBeneficiary1(this.beneficiary1Rule.evaluate(input));
            output.setBeneficiary1IdentifierTypeIndicator(this.beneficiary1IdentifierTypeIndicatorRule.evaluate(input));
            output.setBuyerIdentifier(this.buyerIdentifierRule.evaluate(input));
            output.setSellerIdentifier(this.sellerIdentifierRule.evaluate(input));
            output.setClearedOverriddenAsClearedEnum(this.clearedRule.evaluate(input));
            output.setCentralCounterparty(this.centralCounterpartyRule.evaluate(input));
            output.setClearingMember(this.clearingMemberRule.evaluate(input));
            output.setConfirmed(this.confirmedRule.evaluate(input));
            output.setCallAmount(this.callAmountRule.evaluate(input));
            output.setPutAmount(this.putAmountRule.evaluate(input));
            output.setCallCurrency(this.callCurrencyRule.evaluate(input));
            output.setPutCurrency(this.putCurrencyRule.evaluate(input));
            output.setPriceSchedule((List)this.contractPriceScheduleRule.evaluate(input));
            output.setStrikePriceSchedule((List)this.strikePriceScheduleRule.evaluate(input));
            output.setPrice(this.priceRule.evaluate(input));
            output.setPriceNotation(this.priceNotationRule.evaluate(input));
            output.setPriceCurrency(this.priceCurrencyRule.evaluate(input));
            output.setPackageTransactionPrice(this.packageTransactionPriceRule.evaluate(input));
            output.setPackageTransactionPriceNotation(this.packageTransactionPriceNotationRule.evaluate(input));
            output.setPackageTransactionPriceCurrency(this.packageTransactionPriceCurrencyRule.evaluate(input));
            output.setPackageTransactionSpread(this.packageTransactionSpreadRule.evaluate(input));
            output.setPackageTransactionSpreadNotation(this.packageTransactionSpreadNotationRule.evaluate(input));
            output.setPackageTransactionSpreadCurrency(this.packageTransactionSpreadCurrencyRule.evaluate(input));
            output.setPackageIdentifier(this.packageIdentifierRule.evaluate(input));
            output.setStrikePrice(this.strikePriceRule.evaluate(input));
            output.setStrikePriceNotation(this.strikePriceNotationRule.evaluate(input));
            output.setStrikePriceCurrency(this.strikePriceCurrencyCurrencyPairRule.evaluate(input));
            output.setPriceUnitOfMeasure(this.priceUnitOfMeasureRule.evaluate(input));
            output.setOptionPremiumAmount(this.optionPremiumAmountRule.evaluate(input));
            output.setOptionPremiumCurrency(this.optionPremiumCurrencyRule.evaluate(input));
            output.setOptionPremiumPaymentDate(this.optionPremiumPaymentDateRule.evaluate(input));
            output.setExchangeRate(this.exchangeRateRule.evaluate(input));
            output.setExchangeRateBasis(this.exchangeRateBasisRule.evaluate(input));
            output.setCdSIndexAttachmentPoint(this.cdsIndexAttachmentPointRule.evaluate(input));
            output.setCdSIndexDetachmentPoint(this.cdsIndexDetachmentPointRule.evaluate(input));
            output.setCollateralPortfolioIndicator(this.collateralPortfolioIndicatorRule.evaluate(input));
            output.setFirstExerciseDate(this.firstExerciseDateRule.evaluate(input));
            output.setFinalContractualSettlementDate(this.finalContractualSettlementDateRule.evaluate(input));
            output.setSettlementLocation(this.settlementLocationRule.evaluate(input));
            output.setPriorUTI(this.priorUTIRule.evaluate(input));
            output.setDirection1(this.direction1Rule.evaluate(input));
            output.setCustomBasketCode(this.customBasketCodeRule.evaluate(input));
            output.setBasketConstituents((List)this.basketConstituentsRule.evaluate(input));
            output.setOtherPayment((List)this.otherPaymentRule.evaluate(input));
            output.setLeg1(this.leg1ReportRule.evaluate(input));
            output.setLeg2(this.leg2ReportRule.evaluate(input));
            output.setUnderlyingIdOther(this.underlierIdOtherRule.evaluate(input));
            output.setUnderlyingIdOtherSource(this.underlierIdOtherSourceRule.evaluate(input));
            output.setUnderlyingAssetTradingPlatformIdentifier(this.underlyingAssetTradingPlatformIdentifierRule.evaluate(input));
            output.setUnderlyingAssetPriceSource(this.underlyingAssetPriceSourceRule.evaluate(input));
            output.setCryptoAssetUnderlyingIndicator(this.cryptoAssetUnderlyingIndicatorRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setEventType(this.eventTypeRule.evaluate(input));
            output.setEventIdentifier(this.eventIdentifierRule.evaluate(input));
            output.setEventTimestampOverriddenAsZonedDateTime(this.eventTimestampRule.evaluate(input));
            output.setCounterparty2Name(this.counterparty2NameRule.evaluate(input));
            output.setExecutionAgentCounterparty1(this.executionAgentCounterparty1Rule.evaluate(input));
            output.setExecutionAgentCounterparty2(this.executionAgentCounterparty2Rule.evaluate(input));
            output.setReportSubmittingEntityID(this.submitterIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setPriorUTIProprietary(this.priorUTIProprietaryRule.evaluate(input));
            output.setUniqueProductIdentifier(this.uniqueProductIdentifierRule.evaluate(input));
            output.setContractType(this.contractTypeRule.evaluate(input));
            output.setAssetClassOverriddenAsCommonAssetClass(this.assetClassRule.evaluate(input));
            output.setClearingTimestamp(this.clearingTimestampRule.evaluate(input));
            output.setPlatformIdentifier(this.platformIdentifierRule.evaluate(input));
            output.setBarrier(this._barrierRule.evaluate(input));
            output.setNameOfTheUnderlyingIndex(this.nameOfTheUnderlyingIndexRule.evaluate(input));
            output.setMaturityDateOfTheUnderlying(this.maturityDateOfTheUnderlyingDerivativeRule.evaluate(input));
            output.setOptionType(this.optionTypeRule.evaluate(input));
            output.setOptionStyle(this.optionStyleRule.evaluate(input));
            output.setDeliveryType(this.deliveryTypeRule.evaluate(input));
            output.setCountryOfTheCounterparty2(this.countryOfTheCounterparty2Rule.evaluate(input));
            output.setBookingLocation(this.bookingLocationRule.evaluate(input));
            output.setTraderLocation(this.traderLocationRule.evaluate(input));
            output.setTradingCapacity(this.tradingCapacityRule.evaluate(input));
            output.setEmbeddedOptionType(this.embeddedOptionTypeRule.evaluate(input));
            output.setSeniority(this.seniorityRule.evaluate(input));
            BigDecimal bigDecimal0 = this.seriesRule.evaluate(input);
            output.setSeries(bigDecimal0 == null ? null : Integer.valueOf(bigDecimal0.intValueExact()));
            output.setIndexFactor(this.indexFactorRule.evaluate(input));
            output.setTechnicalRecordIdOverriddenAsString(this.technicalRecordIdentificationRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.initialMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCode(this.variationMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setNonStandardizedTermIndicator(this.nonStandardizedTermIndicatorRule.evaluate(input));
            output.setBrokerID(this.brokerIdRule.evaluate(input));
            BigDecimal bigDecimal1 = this.seriesVersionRule.evaluate(input);
            output.setSeriesVersion(bigDecimal1 == null ? null : Integer.valueOf(bigDecimal1.intValueExact()));
            output.setSecondaryTransactionIdentifier(this.secondaryTransactionIdentifierRule.evaluate(input));
            output.setNatureOfCounterparty1(this.natureOfTheCounterparty1Rule.evaluate(input));
            output.setNatureOfCounterparty2(this.natureOfTheCounterparty2Rule.evaluate(input));
            output.setSwapLinkID(this.swapLinkIDRule.evaluate(input));
            output.setBaseProduct(this.baseProductRule.evaluate(input));
            output.setSubProduct(this.subProductRule.evaluate(input));
            output.setFurtherSubProduct(this.furtherSubProductRule.evaluate(input));
            output.setIntragroup(this.intragroupRule.evaluate(input));
            output.setEntityResponsibleForReportingOverriddenAsString(this.entityResponsibleForReportingRule.evaluate(input));
            output.setReferenceEntity(this.referenceEntityRule.evaluate(input));
            output.setUnderlyingIdentification(this.underlyingIdentificationRule.evaluate(input));
            output.setUnderlyingIdentificationType(this.underlyingIdentificationTypeRule.evaluate(input));
            output.setCorporateSectorOfTheCounterparty1((List)this.sectorOfTheCounterparty1Rule.evaluate(input));
            output.setCorporateSectorOfTheCounterparty2((List)this.sectorOfTheCounterparty2Rule.evaluate(input));
            output.setProductDescription(this.productDescriptionRule.evaluate(input));
            output.setBeneficiary(this.beneficiaryRule.evaluate(input));
            output.setUniqueProductIdentifierProprietary(this.uniqueProductIdentifierProprietaryRule.evaluate(input));
            output.setCounterparty2IdentifierFormat(this.counterparty2IdentifierFormatRule.evaluate(input));
            output.setCounterparty2SchemeName(this.counterparty2SchemeNameRule.evaluate(input));
            output.setCentralCounterpartyIdentifierFormat(this.centralCounterpartyIdentifierFormatRule.evaluate(input));
            output.setCentralCounterpartySchemeName(this.centralCounterpartySchemeNameRule.evaluate(input));
            output.setBrokerIdentifierFormat(this.brokerIdentifierFormatRule.evaluate(input));
            output.setBrokerSchemeName(this.brokerSchemeNameRule.evaluate(input));
            output.setReferenceEntityFormat(this.referenceEntityFormatRule.evaluate(input));
            output.setClearingMemberIdentifierFormat(this.clearingMemberIdentifierFormatRule.evaluate(input));
            output.setClearingMemberSchemeName(this.clearingMemberSchemeNameRule.evaluate(input));
            output.setPriorUTIProprietarySchemeName(this.priorUTIProprietarySchemeNameRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietarySchemeName(this.uniqueTransactionIdentifierProprietarySchemeNameRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

