/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg1Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg1;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg1Rule;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.regulation.hkma.rewrite.trade.reports.FloatingRateIdentifierLeg1Rule;
import drr.regulation.hkma.rewrite.trade.reports.FloatingRateIndicatorLeg1Rule;
import drr.regulation.hkma.rewrite.trade.reports.FloatingRateReferencePeriodLeg1Rule;
import drr.regulation.hkma.rewrite.trade.reports.FloatingRateReferencePeriodMultiplierLeg1Rule;
import drr.regulation.hkma.rewrite.trade.reports.NameOfTheFloatingRateLeg1Rule;
import drr.regulation.hkma.rewrite.trade.reports.SpreadNotationLeg1Rule;
import drr.standards.iosco.cde.version3.functions.Leg1;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleRule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleRule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Leg1ReportRuleDefault.class)
public abstract class Leg1ReportRule
implements ReportFunction<TransactionReportInstruction, CommonLeg> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FixingDateLeg1Rule fixingDateLeg1Rule;
    @Inject
    protected FloatingRateIdentifierLeg1Rule floatingRateIdentifierLeg1Rule;
    @Inject
    protected FloatingRateIndicatorLeg1Rule floatingRateIndicatorLeg1Rule;
    @Inject
    protected FloatingRateReferencePeriodLeg1Rule floatingRateReferencePeriodLeg1Rule;
    @Inject
    protected FloatingRateReferencePeriodMultiplierLeg1Rule floatingRateReferencePeriodMultiplierLeg1Rule;
    @Inject
    protected IsAllowableActionForHKMA isAllowableActionForHKMA;
    @Inject
    protected Leg1 leg1;
    @Inject
    protected LegEnrichment legEnrichment;
    @Inject
    protected NameOfTheFloatingRateLeg1Rule nameOfTheFloatingRateLeg1Rule;
    @Inject
    protected NotionalAmountScheduleRule notionalAmountScheduleRule;
    @Inject
    protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
    @Inject
    protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
    @Inject
    protected PayoutLeg1Rule payoutLeg1Rule;
    @Inject
    protected QuantityFrequencyLeg1 quantityFrequencyLeg1;
    @Inject
    protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;

    public CommonLeg evaluate(TransactionReportInstruction input) {
        CommonLeg output;
        CommonLeg.CommonLegBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(CommonLeg.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction var1);

    public static class Leg1ReportRuleDefault
    extends Leg1ReportRule {
        @Override
        protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
            CommonLeg.CommonLegBuilder output = CommonLeg.builder();
            return this.assignOutput(output, input);
        }

        protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
            MapperS ifThenElseResult;
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForHKMA.evaluate((ReportableEventBase)item.get()));
            if (ExpressionOperators.exists((Mapper)thenArg).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                BigInteger bigInteger = new BigInteger("9999999999999999999999999");
                BigDecimal bigDecimal = this.floatingRateReferencePeriodMultiplierLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get());
                ifThenElseResult = MapperS.of((Object)this.legEnrichment.evaluate(this.leg1.evaluate((TransactionReportInstruction)thenArg.get(), this.spreadNotationLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), bigInteger == null ? null : new BigDecimal(bigInteger)), this.notionalAmountScheduleRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)thenArg.get())), this.notionalQuantityScheduleRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)thenArg.get())), this.notionalQuantityLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), null, null, this.fixingDateLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), (FrequencyPeriodEnum)((Object)MapperS.of((Object)this.quantityFrequencyLeg1.evaluate((ReportableEventBase)thenArg.get())).map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get()), (Integer)MapperS.of((Object)this.quantityFrequencyLeg1.evaluate((ReportableEventBase)thenArg.get())).map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), this.floatingRateIndicatorLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.floatingRateIdentifierLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.floatingRateReferencePeriodLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get()), bigDecimal == null ? null : Integer.valueOf(bigDecimal.intValueExact()), this.nameOfTheFloatingRateLeg1Rule.evaluate((TransactionReportInstruction)thenArg.get())));
            } else {
                ifThenElseResult = MapperS.ofNull();
            }
            output = (CommonLeg.CommonLegBuilder)this.toBuilder((RosettaModelObject)ifThenElseResult.get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

