/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import javax.inject.Inject;

@ImplementedBy(value=PriceCurrencyRuleDefault.class)
public abstract class PriceCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected IsAllowableActionForHKMA isAllowableActionForHKMA;
    @Inject
    protected drr.standards.iosco.cde.version3.price.reports.PriceCurrencyRule priceCurrencyRule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class PriceCurrencyRuleDefault
    extends PriceCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForHKMA.evaluate((ReportableEventBase)item.get()));
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.priceCurrencyRule.evaluate((TransactionReportInstructionBase)item.get()))).get();
            return output;
        }
    }
}

