/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="HKMATransactionReportDOC0002")
@ImplementedBy(value=Default.class)
public interface HKMATransactionReportDOC0002
extends Validator<HKMATransactionReport> {
    public static final String NAME = "HKMATransactionReportDOC0002";
    public static final String DEFINITION = "if [ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType then if earlyTerminationDate exists then (earlyTerminationDate >= executionTimestamp -> date and earlyTerminationDate < expirationDate)";

    public static class NoOp
    implements HKMATransactionReportDOC0002 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport hKMATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements HKMATransactionReportDOC0002 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport hKMATransactionReport) {
            ComparisonResult result = this.executeDataRule(hKMATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)HKMATransactionReportDOC0002.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMATransactionReport", (RosettaPath)path, (String)HKMATransactionReportDOC0002.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)HKMATransactionReportDOC0002.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMATransactionReport", (RosettaPath)path, (String)HKMATransactionReportDOC0002.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(HKMATransactionReport hKMATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)hKMATransactionReport).map("getActionType", _hKMATransactionReport -> _hKMATransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)hKMATransactionReport).map("getEarlyTerminationDate", _hKMATransactionReport -> _hKMATransactionReport.getEarlyTerminationDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)hKMATransactionReport).map("getEarlyTerminationDate", _hKMATransactionReport -> _hKMATransactionReport.getEarlyTerminationDate()), (Mapper)MapperS.of((Object)hKMATransactionReport).map("getExecutionTimestamp", _hKMATransactionReport -> _hKMATransactionReport.getExecutionTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.lessThan((Mapper)MapperS.of((Object)hKMATransactionReport).map("getEarlyTerminationDate", _hKMATransactionReport -> _hKMATransactionReport.getEarlyTerminationDate()), (Mapper)MapperS.of((Object)hKMATransactionReport).map("getExpirationDate", _hKMATransactionReport -> _hKMATransactionReport.getExpirationDate()), (CardinalityOperator)CardinalityOperator.All));
                    }
                    return ComparisonResult.successEmptyOperand((String)"");
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

