/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="HKMATransactionReportDOC0015")
@ImplementedBy(value=Default.class)
public interface HKMATransactionReportDOC0015
extends Validator<HKMATransactionReport> {
    public static final String NAME = "HKMATransactionReportDOC0015";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType then counterparty1 <> counterparty2";

    public static class NoOp
    implements HKMATransactionReportDOC0015 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport hKMATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements HKMATransactionReportDOC0015 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport hKMATransactionReport) {
            ComparisonResult result = this.executeDataRule(hKMATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)HKMATransactionReportDOC0015.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMATransactionReport", (RosettaPath)path, (String)HKMATransactionReportDOC0015.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)HKMATransactionReportDOC0015.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMATransactionReport", (RosettaPath)path, (String)HKMATransactionReportDOC0015.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(HKMATransactionReport hKMATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)hKMATransactionReport).map("getActionType", _hKMATransactionReport -> _hKMATransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notEqual((Mapper)MapperS.of((Object)hKMATransactionReport).map("getCounterparty1", _hKMATransactionReport -> _hKMATransactionReport.getCounterparty1()), (Mapper)MapperS.of((Object)hKMATransactionReport).map("getCounterparty2", _hKMATransactionReport -> _hKMATransactionReport.getCounterparty2()), (CardinalityOperator)CardinalityOperator.Any);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

