/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.datetime.reports.FixingDateLeg1Rule;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.functions.FloatingInterestRatePayoutFromPayout;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierRule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodRule;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.regulation.jfsa.rewrite.trade.reports.FloatingRateIndicatorLeg1Rule;
import drr.regulation.jfsa.rewrite.trade.reports.FloatingRateReferencePeriodLeg1Rule;
import drr.regulation.jfsa.rewrite.trade.reports.FloatingRateReferencePeriodMultiplierLeg1Rule;
import drr.regulation.jfsa.rewrite.trade.reports.NameOfTheFloatingRateLeg1Rule;
import drr.regulation.jfsa.rewrite.trade.reports.SpreadNotationOfLeg1Rule;
import drr.standards.iosco.cde.version3.functions.Leg1;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleRule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleRule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Leg1ReportRuleDefault.class)
public abstract class Leg1ReportRule
implements ReportFunction<TransactionReportInstruction, CommonLeg> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FixingDateLeg1Rule fixingDateLeg1Rule;
    @Inject
    protected FloatingInterestRatePayoutFromPayout floatingInterestRatePayoutFromPayout;
    @Inject
    protected FloatingRateIndicatorLeg1Rule floatingRateIndicatorLeg1Rule;
    @Inject
    protected FloatingRateReferencePeriodLeg1Rule floatingRateReferencePeriodLeg1Rule;
    @Inject
    protected FloatingRateReferencePeriodMultiplierLeg1Rule floatingRateReferencePeriodMultiplierLeg1Rule;
    @Inject
    protected FloatingRateResetFrequencyPeriodMultiplierRule floatingRateResetFrequencyPeriodMultiplierRule;
    @Inject
    protected FloatingRateResetFrequencyPeriodRule floatingRateResetFrequencyPeriodRule;
    @Inject
    protected IsAllowableActionForJFSA isAllowableActionForJFSA;
    @Inject
    protected Leg1 leg1;
    @Inject
    protected LegEnrichment legEnrichment;
    @Inject
    protected NameOfTheFloatingRateLeg1Rule nameOfTheFloatingRateLeg1Rule;
    @Inject
    protected NotionalAmountScheduleRule notionalAmountScheduleRule;
    @Inject
    protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
    @Inject
    protected PayoutLeg1Rule payoutLeg1Rule;
    @Inject
    protected SpreadNotationOfLeg1Rule spreadNotationOfLeg1Rule;

    public CommonLeg evaluate(TransactionReportInstruction input) {
        CommonLeg output;
        CommonLeg.CommonLegBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(CommonLeg.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction var1);

    public static class Leg1ReportRuleDefault
    extends Leg1ReportRule {
        @Override
        protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
            CommonLeg.CommonLegBuilder output = CommonLeg.builder();
            return this.assignOutput(output, input);
        }

        protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForJFSA.evaluate((ReportableEventBase)item.get()));
            BigInteger bigInteger = new BigInteger("9999999999999999999999999");
            MapperS thenArg1 = MapperS.of((Object)this.floatingInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)thenArg0.get())));
            MapperS thenArg2 = MapperS.of((Object)this.floatingInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)thenArg0.get())));
            BigDecimal bigDecimal0 = (BigDecimal)MapperS.of((Object)this.floatingRateResetFrequencyPeriodMultiplierRule.evaluate((InterestRatePayout)thenArg2.get())).get();
            BigDecimal bigDecimal1 = this.floatingRateReferencePeriodMultiplierLeg1Rule.evaluate((TransactionReportInstruction)thenArg0.get());
            output = (CommonLeg.CommonLegBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.legEnrichment.evaluate(this.leg1.evaluate((TransactionReportInstruction)thenArg0.get(), this.spreadNotationOfLeg1Rule.evaluate((TransactionReportInstruction)thenArg0.get()), bigInteger == null ? null : new BigDecimal(bigInteger)), this.notionalAmountScheduleRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)thenArg0.get())), this.notionalQuantityScheduleRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)thenArg0.get())), null, (FrequencyPeriodEnum)((Object)MapperS.of((Object)((Object)this.floatingRateResetFrequencyPeriodRule.evaluate((InterestRatePayout)thenArg1.get()))).get()), bigDecimal0 == null ? null : Integer.valueOf(bigDecimal0.intValueExact()), this.fixingDateLeg1Rule.evaluate((TransactionReportInstruction)thenArg0.get()), null, null, this.floatingRateIndicatorLeg1Rule.evaluate((TransactionReportInstruction)thenArg0.get()), null, this.floatingRateReferencePeriodLeg1Rule.evaluate((TransactionReportInstruction)thenArg0.get()), bigDecimal1 == null ? null : Integer.valueOf(bigDecimal1.intValueExact()), this.nameOfTheFloatingRateLeg1Rule.evaluate((TransactionReportInstruction)thenArg0.get()))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

