/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.payment.functions.FloatingInterestRatePayoutFromPayout;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodMultiplierRule;
import drr.regulation.common.trade.payment.reports.FloatingRateResetFrequencyPeriodRule;
import drr.regulation.common.trade.quantity.functions.QuantityFrequencyLeg2;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg2Rule;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateIdentifierLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.NameOfTheFloatingRateLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.SpreadNotationOfLeg2Rule;
import drr.standards.iosco.cde.version3.functions.Leg2;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleRule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleRule;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Leg2ReportRuleDefault.class)
public abstract class Leg2ReportRule
implements ReportFunction<TransactionReportInstruction, CommonLeg> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FloatingInterestRatePayoutFromPayout floatingInterestRatePayoutFromPayout;
    @Inject
    protected FloatingRateIdentifierLeg2Rule floatingRateIdentifierLeg2Rule;
    @Inject
    protected FloatingRateResetFrequencyPeriodMultiplierRule floatingRateResetFrequencyPeriodMultiplierRule;
    @Inject
    protected FloatingRateResetFrequencyPeriodRule floatingRateResetFrequencyPeriodRule;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;
    @Inject
    protected Leg2 leg2;
    @Inject
    protected LegEnrichment legEnrichment;
    @Inject
    protected NameOfTheFloatingRateLeg2Rule nameOfTheFloatingRateLeg2Rule;
    @Inject
    protected NotionalAmountScheduleRule notionalAmountScheduleRule;
    @Inject
    protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
    @Inject
    protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
    @Inject
    protected PayoutLeg2Rule payoutLeg2Rule;
    @Inject
    protected QuantityFrequencyLeg2 quantityFrequencyLeg2;
    @Inject
    protected SpreadNotationOfLeg2Rule spreadNotationOfLeg2Rule;

    public CommonLeg evaluate(TransactionReportInstruction input) {
        CommonLeg output;
        CommonLeg.CommonLegBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(CommonLeg.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction var1);

    public static class Leg2ReportRuleDefault
    extends Leg2ReportRule {
        @Override
        protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
            CommonLeg.CommonLegBuilder output = CommonLeg.builder();
            return this.assignOutput(output, input);
        }

        protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
            MapperS ifThenElseResult;
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEventBase)item.get()));
            if (ExpressionOperators.exists((Mapper)thenArg).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                BigInteger bigInteger = new BigInteger("9999999999999999999999999");
                BigDecimal bigDecimal = this.floatingRateResetFrequencyPeriodMultiplierRule.evaluate(this.floatingInterestRatePayoutFromPayout.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)thenArg.get())));
                ifThenElseResult = MapperS.of((Object)this.legEnrichment.evaluate(this.leg2.evaluate((TransactionReportInstruction)thenArg.get(), this.spreadNotationOfLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), bigInteger == null ? null : new BigDecimal(bigInteger)), this.notionalAmountScheduleRule.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)thenArg.get())), this.notionalQuantityScheduleRule.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)thenArg.get())), this.notionalQuantityLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), this.floatingRateResetFrequencyPeriodRule.evaluate(this.floatingInterestRatePayoutFromPayout.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)thenArg.get()))), bigDecimal == null ? null : Integer.valueOf(bigDecimal.intValueExact()), null, (FrequencyPeriodEnum)((Object)MapperS.of((Object)this.quantityFrequencyLeg2.evaluate((ReportableEventBase)thenArg.get())).map("getPeriod", quantityFrequency -> quantityFrequency.getPeriod()).get()), (Integer)MapperS.of((Object)this.quantityFrequencyLeg2.evaluate((ReportableEventBase)thenArg.get())).map("getPeriodMultiplier", quantityFrequency -> quantityFrequency.getPeriodMultiplier()).get(), null, this.floatingRateIdentifierLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()), null, null, this.nameOfTheFloatingRateLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get())));
            } else {
                ifThenElseResult = MapperS.ofNull();
            }
            output = (CommonLeg.CommonLegBuilder)this.toBuilder((RosettaModelObject)ifThenElseResult.get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

