/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceNotationRule;
import drr.standards.iosco.cde.version3.price.reports.StrikePriceValueRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceRuleDefault.class)
public abstract class StrikePriceRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected StrikePriceNotationRule strikePriceNotationRule;
    @Inject
    protected StrikePriceValueRule strikePriceValueRule;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceRuleDefault
    extends StrikePriceRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEventBase)item.get()));
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.strikePriceValueRule.evaluate((TransactionReportInstructionBase)thenArg.get()), this.strikePriceNotationRule.evaluate((TransactionReportInstruction)thenArg.get()))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

