/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.payment.OtherPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import drr.regulation.common.AllocationIndicatorEnum;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.JurisdictionEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.NonReportable;
import drr.regulation.common.trade.contract.MasterAgreementEnum;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.sec.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.sec.rewrite.trade.meta.SECTransactionReportMeta;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SECTransactionReport", builder=SECTransactionReportBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="SECTransactionReport", model="drr", builder=SECTransactionReportBuilderImpl.class, version="7.0.0-dev.52")
public interface SECTransactionReport
extends CommonTransactionReport {
    public static final SECTransactionReportMeta metaData = new SECTransactionReportMeta();

    @Override
    public ClearedEnum getCleared();

    @Override
    public String getCounterparty2();

    @Override
    public Counterparty2IdentifierEnum getCounterparty2IdentifierSource();

    @Override
    public Boolean getCustomBasketIndicator();

    @Override
    public ZonedDateTime getEventTimestamp();

    @Override
    public Boolean getPackageIndicator();

    @Override
    public Date getEffectiveDate();

    @Override
    public ZonedDateTime getExecutionTimestamp();

    public List<String> getClearingSwapUSIs();

    public List<String> getClearingSwapUTIs();

    public String getOriginalSwapUSI();

    public Boolean getPostPricedSwapIndicator();

    public AllocationIndicatorEnum getAllocationIndicator();

    public String getUniqueSwapIdentifier();

    public Boolean getCounterparty1FinancialEntityIndicator();

    public Boolean getCounterparty2FinancialEntityIndicator();

    public JurisdictionEnum getJurisdiction();

    public DTCCAdditionalFields getDtccAdditionalFields();

    @Override
    public SECTransactionReport build();

    @Override
    public SECTransactionReportBuilder toBuilder();

    public static SECTransactionReportBuilder builder() {
        return new SECTransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends SECTransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SECTransactionReport> getType() {
        return SECTransactionReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, this.getLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, this.getLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingSwapUSIs"), String.class, this.getClearingSwapUSIs(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingSwapUTIs"), String.class, this.getClearingSwapUTIs(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUSI"), String.class, (Object)this.getOriginalSwapUSI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, (Object)this.getPostPricedSwapIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("allocationIndicator"), AllocationIndicatorEnum.class, (Object)this.getAllocationIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1FinancialEntityIndicator"), Boolean.class, (Object)this.getCounterparty1FinancialEntityIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2FinancialEntityIndicator"), Boolean.class, (Object)this.getCounterparty2FinancialEntityIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("jurisdiction"), JurisdictionEnum.class, (Object)this.getJurisdiction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dtccAdditionalFields"), processor, DTCCAdditionalFields.class, this.getDtccAdditionalFields(), new AttributeMeta[0]);
    }

    public static class SECTransactionReportBuilderImpl
    extends CommonTransactionReport.CommonTransactionReportBuilderImpl
    implements SECTransactionReportBuilder {
        protected ClearedEnum cleared;
        protected String counterparty2;
        protected Counterparty2IdentifierEnum counterparty2IdentifierSource;
        protected Boolean customBasketIndicator;
        protected ZonedDateTime eventTimestamp;
        protected Boolean packageIndicator;
        protected Date effectiveDate;
        protected ZonedDateTime executionTimestamp;
        protected List<String> clearingSwapUSIs = new ArrayList<String>();
        protected List<String> clearingSwapUTIs = new ArrayList<String>();
        protected String originalSwapUSI;
        protected Boolean postPricedSwapIndicator;
        protected AllocationIndicatorEnum allocationIndicator;
        protected String uniqueSwapIdentifier;
        protected Boolean counterparty1FinancialEntityIndicator;
        protected Boolean counterparty2FinancialEntityIndicator;
        protected JurisdictionEnum jurisdiction;
        protected DTCCAdditionalFields.DTCCAdditionalFieldsBuilder dtccAdditionalFields;

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public Counterparty2IdentifierEnum getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator", isRequired=true)
        @RuneAttribute(value="customBasketIndicator", isRequired=true)
        public Boolean getCustomBasketIndicator() {
            return this.customBasketIndicator;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="packageIndicator", isRequired=true)
        @RuneAttribute(value="packageIndicator", isRequired=true)
        public Boolean getPackageIndicator() {
            return this.packageIndicator;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="clearingSwapUSIs")
        @RuneAttribute(value="clearingSwapUSIs")
        public List<String> getClearingSwapUSIs() {
            return this.clearingSwapUSIs;
        }

        @Override
        @RosettaAttribute(value="clearingSwapUTIs")
        @RuneAttribute(value="clearingSwapUTIs")
        public List<String> getClearingSwapUTIs() {
            return this.clearingSwapUTIs;
        }

        @Override
        @RosettaAttribute(value="originalSwapUSI")
        @RuneAttribute(value="originalSwapUSI")
        public String getOriginalSwapUSI() {
            return this.originalSwapUSI;
        }

        @Override
        @RosettaAttribute(value="postPricedSwapIndicator", isRequired=true)
        @RuneAttribute(value="postPricedSwapIndicator", isRequired=true)
        public Boolean getPostPricedSwapIndicator() {
            return this.postPricedSwapIndicator;
        }

        @Override
        @RosettaAttribute(value="allocationIndicator", isRequired=true)
        @RuneAttribute(value="allocationIndicator", isRequired=true)
        public AllocationIndicatorEnum getAllocationIndicator() {
            return this.allocationIndicator;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="counterparty1FinancialEntityIndicator")
        @RuneAttribute(value="counterparty1FinancialEntityIndicator")
        public Boolean getCounterparty1FinancialEntityIndicator() {
            return this.counterparty1FinancialEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
        public Boolean getCounterparty2FinancialEntityIndicator() {
            return this.counterparty2FinancialEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="jurisdiction", isRequired=true)
        @RuneAttribute(value="jurisdiction", isRequired=true)
        public JurisdictionEnum getJurisdiction() {
            return this.jurisdiction;
        }

        @Override
        @RosettaAttribute(value="dtccAdditionalFields")
        @RuneAttribute(value="dtccAdditionalFields")
        public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getDtccAdditionalFields() {
            return this.dtccAdditionalFields;
        }

        @Override
        public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getOrCreateDtccAdditionalFields() {
            DTCCAdditionalFields.DTCCAdditionalFieldsBuilder result = this.dtccAdditionalFields != null ? this.dtccAdditionalFields : (this.dtccAdditionalFields = DTCCAdditionalFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public SECTransactionReportBuilder setEffectiveDateOverriddenAsDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            return this.setEffectiveDateOverriddenAsDate(_effectiveDate);
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public SECTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public SECTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public SECTransactionReportBuilder setExecutionTimestampOverriddenAsZonedDateTime(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            return this.setExecutionTimestampOverriddenAsZonedDateTime(_executionTimestamp);
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public SECTransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public SECTransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public SECTransactionReportBuilder setCounterparty2OverriddenAsString(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setCounterparty2(String _counterparty2) {
            return this.setCounterparty2OverriddenAsString(_counterparty2);
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public SECTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public SECTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public SECTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public SECTransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
            this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public SECTransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
            this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public SECTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setCleared(ClearedEnum _cleared) {
            return this.setClearedOverriddenAsClearedEnum(_cleared);
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public SECTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public SECTransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public SECTransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public SECTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public SECTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public SECTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public SECTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public SECTransactionReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public SECTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public SECTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            if (priceSchedules != null) {
                for (PricePeriod pricePeriod : priceSchedules) {
                    this.priceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public SECTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public SECTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public SECTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (PricePeriod pricePeriod : strikePriceSchedules) {
                    this.strikePriceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public SECTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public SECTransactionReportBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public SECTransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public SECTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
            this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public SECTransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public SECTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public SECTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public SECTransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public SECTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public SECTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public SECTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public SECTransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public SECTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public SECTransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
            this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public SECTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public SECTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public SECTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public SECTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public SECTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public SECTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public SECTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public SECTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public SECTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public SECTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public SECTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public SECTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public SECTransactionReportBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public SECTransactionReportBuilder setDirection1(Direction1Enum _direction1) {
            this.direction1 = _direction1 == null ? null : _direction1;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public SECTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public SECTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public SECTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public SECTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public SECTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public SECTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public SECTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public SECTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public SECTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public SECTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
            if (otherPayments != null) {
                for (OtherPayment otherPayment : otherPayments) {
                    this.otherPayment.add(otherPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public SECTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public SECTransactionReportBuilder setLeg1(CommonLeg _leg1) {
            this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setLeg1(Leg _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setLeg1(LegV2 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setLeg1(LegV1 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public SECTransactionReportBuilder setLeg2(CommonLeg _leg2) {
            this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setLeg2(Leg _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setLeg2(LegV2 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setLeg2(LegV1 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public SECTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public SECTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public SECTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
            this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public SECTransactionReportBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
            this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public SECTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
            this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public SECTransactionReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public SECTransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public SECTransactionReportBuilder setEventType(EventTypeEnum _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public SECTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public SECTransactionReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            return this.setEventTimestampOverriddenAsZonedDateTime(_eventTimestamp);
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public SECTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty1")
        @RuneAttribute(value="executionAgentCounterparty1")
        public SECTransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
            this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty2")
        @RuneAttribute(value="executionAgentCounterparty2")
        public SECTransactionReportBuilder setExecutionAgentCounterparty2(String _executionAgentCounterparty2) {
            this.executionAgentCounterparty2 = _executionAgentCounterparty2 == null ? null : _executionAgentCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public SECTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public SECTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public SECTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public SECTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
            this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public SECTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType")
        @RuneAttribute(value="contractType")
        public SECTransactionReportBuilder setContractType(CommonContractType _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public SECTransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public SECTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
            this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public SECTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public SECTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public SECTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
            this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public SECTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public SECTransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public SECTransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public SECTransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterparty2")
        @RuneAttribute(value="countryOfTheCounterparty2")
        public SECTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
            this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public SECTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
            this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public SECTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
            this.traderLocation = _traderLocation == null ? null : _traderLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public SECTransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
            this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
            return this;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public SECTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
            this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public SECTransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
            this.seniority = _seniority == null ? null : _seniority;
            return this;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public SECTransactionReportBuilder setSeries(Integer _series) {
            this.series = _series == null ? null : _series;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public SECTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public SECTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public SECTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
            this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public SECTransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
            this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public SECTransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
            this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public SECTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
            this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUSI")
        @RuneAttribute(value="priorUSI")
        public SECTransactionReportBuilder setPriorUSI(String _priorUSI) {
            this.priorUSI = _priorUSI == null ? null : _priorUSI;
            return this;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public SECTransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
            this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public SECTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public SECTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public SECTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
            this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType")
        @RuneAttribute(value="masterAgreementType")
        public SECTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum _masterAgreementType) {
            this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public SECTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
            this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonStandardizedTermIndicator")
        @RuneAttribute(value="nonStandardizedTermIndicator")
        public SECTransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
            this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="amendmentIndicator")
        @RuneAttribute(value="amendmentIndicator")
        public SECTransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
            this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIndicator", isRequired=true)
        @RuneAttribute(value="packageIndicator", isRequired=true)
        public SECTransactionReportBuilder setPackageIndicatorOverriddenAsBoolean(Boolean _packageIndicator) {
            this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
            return this.setPackageIndicatorOverriddenAsBoolean(_packageIndicator);
        }

        @Override
        @RosettaAttribute(value="brokerID")
        @RuneAttribute(value="brokerID")
        public SECTransactionReportBuilder setBrokerID(String _brokerID) {
            this.brokerID = _brokerID == null ? null : _brokerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public SECTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
            this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="seriesVersion")
        @RuneAttribute(value="seriesVersion")
        public SECTransactionReportBuilder setSeriesVersion(Integer _seriesVersion) {
            this.seriesVersion = _seriesVersion == null ? null : _seriesVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public SECTransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
            this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1")
        @RuneAttribute(value="natureOfCounterparty1")
        public SECTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum _natureOfCounterparty1) {
            this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty2")
        @RuneAttribute(value="natureOfCounterparty2")
        public SECTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum _natureOfCounterparty2) {
            this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public SECTransactionReportBuilder setSwapLinkID(String _swapLinkID) {
            this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
            if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
                this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty1, idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
            return this;
        }

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            if (clearingExceptionsAndExemptionsCounterparty1s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
                    this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public SECTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
            if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
                this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty2, idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
            return this;
        }

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            if (clearingExceptionsAndExemptionsCounterparty2s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
                    this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public SECTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="baseProduct")
        @RuneAttribute(value="baseProduct")
        public SECTransactionReportBuilder setBaseProduct(String _baseProduct) {
            this.baseProduct = _baseProduct == null ? null : _baseProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="subProduct")
        @RuneAttribute(value="subProduct")
        public SECTransactionReportBuilder setSubProduct(String _subProduct) {
            this.subProduct = _subProduct == null ? null : _subProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="furtherSubProduct")
        @RuneAttribute(value="furtherSubProduct")
        public SECTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
            this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public SECTransactionReportBuilder setIntragroup(Boolean _intragroup) {
            this.intragroup = _intragroup == null ? null : _intragroup;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public SECTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public SECTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public SECTransactionReportBuilder setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
            return this.setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(_counterparty2IdentifierSource);
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator", isRequired=true)
        @RuneAttribute(value="customBasketIndicator", isRequired=true)
        public SECTransactionReportBuilder setCustomBasketIndicatorOverriddenAsBoolean(Boolean _customBasketIndicator) {
            this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
            return this;
        }

        @Override
        @RosettaIgnore
        public SECTransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
            return this.setCustomBasketIndicatorOverriddenAsBoolean(_customBasketIndicator);
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public SECTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
            this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public SECTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty1")
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
            if (_corporateSectorOfTheCounterparty1 != null) {
                this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty1, idx, () -> _corporateSectorOfTheCounterparty1);
            return this;
        }

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            if (corporateSectorOfTheCounterparty1s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty1s) {
                    this.corporateSectorOfTheCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public SECTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty2")
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
            if (_corporateSectorOfTheCounterparty2 != null) {
                this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty2, idx, () -> _corporateSectorOfTheCounterparty2);
            return this;
        }

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            if (corporateSectorOfTheCounterparty2s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty2s) {
                    this.corporateSectorOfTheCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public SECTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public SECTransactionReportBuilder setNonReportable(NonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingSwapUSIs")
        @RuneAttribute(value="clearingSwapUSIs")
        public SECTransactionReportBuilder addClearingSwapUSIs(String _clearingSwapUSIs) {
            if (_clearingSwapUSIs != null) {
                this.clearingSwapUSIs.add(_clearingSwapUSIs);
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addClearingSwapUSIs(String _clearingSwapUSIs, int idx) {
            this.getIndex(this.clearingSwapUSIs, idx, () -> _clearingSwapUSIs);
            return this;
        }

        @Override
        public SECTransactionReportBuilder addClearingSwapUSIs(List<String> clearingSwapUSIss) {
            if (clearingSwapUSIss != null) {
                for (String toAdd : clearingSwapUSIss) {
                    this.clearingSwapUSIs.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingSwapUSIs")
        public SECTransactionReportBuilder setClearingSwapUSIs(List<String> clearingSwapUSIss) {
            this.clearingSwapUSIs = clearingSwapUSIss == null ? new ArrayList<String>() : (List)clearingSwapUSIss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingSwapUTIs")
        @RuneAttribute(value="clearingSwapUTIs")
        public SECTransactionReportBuilder addClearingSwapUTIs(String _clearingSwapUTIs) {
            if (_clearingSwapUTIs != null) {
                this.clearingSwapUTIs.add(_clearingSwapUTIs);
            }
            return this;
        }

        @Override
        public SECTransactionReportBuilder addClearingSwapUTIs(String _clearingSwapUTIs, int idx) {
            this.getIndex(this.clearingSwapUTIs, idx, () -> _clearingSwapUTIs);
            return this;
        }

        @Override
        public SECTransactionReportBuilder addClearingSwapUTIs(List<String> clearingSwapUTIss) {
            if (clearingSwapUTIss != null) {
                for (String toAdd : clearingSwapUTIss) {
                    this.clearingSwapUTIs.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingSwapUTIs")
        public SECTransactionReportBuilder setClearingSwapUTIs(List<String> clearingSwapUTIss) {
            this.clearingSwapUTIs = clearingSwapUTIss == null ? new ArrayList<String>() : (List)clearingSwapUTIss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUSI")
        @RuneAttribute(value="originalSwapUSI")
        public SECTransactionReportBuilder setOriginalSwapUSI(String _originalSwapUSI) {
            this.originalSwapUSI = _originalSwapUSI == null ? null : _originalSwapUSI;
            return this;
        }

        @Override
        @RosettaAttribute(value="postPricedSwapIndicator", isRequired=true)
        @RuneAttribute(value="postPricedSwapIndicator", isRequired=true)
        public SECTransactionReportBuilder setPostPricedSwapIndicator(Boolean _postPricedSwapIndicator) {
            this.postPricedSwapIndicator = _postPricedSwapIndicator == null ? null : _postPricedSwapIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationIndicator", isRequired=true)
        @RuneAttribute(value="allocationIndicator", isRequired=true)
        public SECTransactionReportBuilder setAllocationIndicator(AllocationIndicatorEnum _allocationIndicator) {
            this.allocationIndicator = _allocationIndicator == null ? null : _allocationIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public SECTransactionReportBuilder setUniqueSwapIdentifier(String _uniqueSwapIdentifier) {
            this.uniqueSwapIdentifier = _uniqueSwapIdentifier == null ? null : _uniqueSwapIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1FinancialEntityIndicator")
        @RuneAttribute(value="counterparty1FinancialEntityIndicator")
        public SECTransactionReportBuilder setCounterparty1FinancialEntityIndicator(Boolean _counterparty1FinancialEntityIndicator) {
            this.counterparty1FinancialEntityIndicator = _counterparty1FinancialEntityIndicator == null ? null : _counterparty1FinancialEntityIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
        public SECTransactionReportBuilder setCounterparty2FinancialEntityIndicator(Boolean _counterparty2FinancialEntityIndicator) {
            this.counterparty2FinancialEntityIndicator = _counterparty2FinancialEntityIndicator == null ? null : _counterparty2FinancialEntityIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="jurisdiction", isRequired=true)
        @RuneAttribute(value="jurisdiction", isRequired=true)
        public SECTransactionReportBuilder setJurisdiction(JurisdictionEnum _jurisdiction) {
            this.jurisdiction = _jurisdiction == null ? null : _jurisdiction;
            return this;
        }

        @Override
        @RosettaAttribute(value="dtccAdditionalFields")
        @RuneAttribute(value="dtccAdditionalFields")
        public SECTransactionReportBuilder setDtccAdditionalFields(DTCCAdditionalFields _dtccAdditionalFields) {
            this.dtccAdditionalFields = _dtccAdditionalFields == null ? null : _dtccAdditionalFields.toBuilder();
            return this;
        }

        @Override
        public SECTransactionReport build() {
            return new SECTransactionReportImpl(this);
        }

        @Override
        public SECTransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public SECTransactionReportBuilder prune() {
            super.prune();
            if (this.dtccAdditionalFields != null && !this.dtccAdditionalFields.prune().hasData()) {
                this.dtccAdditionalFields = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierSource() != null) {
                return true;
            }
            if (this.getCustomBasketIndicator() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getPackageIndicator() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getClearingSwapUSIs() != null && !this.getClearingSwapUSIs().isEmpty()) {
                return true;
            }
            if (this.getClearingSwapUTIs() != null && !this.getClearingSwapUTIs().isEmpty()) {
                return true;
            }
            if (this.getOriginalSwapUSI() != null) {
                return true;
            }
            if (this.getPostPricedSwapIndicator() != null) {
                return true;
            }
            if (this.getAllocationIndicator() != null) {
                return true;
            }
            if (this.getUniqueSwapIdentifier() != null) {
                return true;
            }
            if (this.getCounterparty1FinancialEntityIndicator() != null) {
                return true;
            }
            if (this.getCounterparty2FinancialEntityIndicator() != null) {
                return true;
            }
            if (this.getJurisdiction() != null) {
                return true;
            }
            return this.getDtccAdditionalFields() != null && this.getDtccAdditionalFields().hasData();
        }

        @Override
        public SECTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SECTransactionReportBuilder o = (SECTransactionReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDtccAdditionalFields(), (RosettaModelObjectBuilder)o.getDtccAdditionalFields(), this::setDtccAdditionalFields);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setClearedOverriddenAsClearedEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2OverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierSource(), (Object)o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustomBasketIndicator(), (Object)o.getCustomBasketIndicator(), this::setCustomBasketIndicatorOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageIndicator(), (Object)o.getPackageIndicator(), this::setPackageIndicatorOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDateOverriddenAsDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic(this.getClearingSwapUSIs(), o.getClearingSwapUSIs(), this::addClearingSwapUSIs);
            merger.mergeBasic(this.getClearingSwapUTIs(), o.getClearingSwapUTIs(), this::addClearingSwapUTIs);
            merger.mergeBasic((Object)this.getOriginalSwapUSI(), (Object)o.getOriginalSwapUSI(), this::setOriginalSwapUSI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPostPricedSwapIndicator(), (Object)o.getPostPricedSwapIndicator(), this::setPostPricedSwapIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAllocationIndicator(), (Object)o.getAllocationIndicator(), this::setAllocationIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueSwapIdentifier(), (Object)o.getUniqueSwapIdentifier(), this::setUniqueSwapIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1FinancialEntityIndicator(), (Object)o.getCounterparty1FinancialEntityIndicator(), this::setCounterparty1FinancialEntityIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2FinancialEntityIndicator(), (Object)o.getCounterparty2FinancialEntityIndicator(), this::setCounterparty2FinancialEntityIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getJurisdiction(), (Object)o.getJurisdiction(), this::setJurisdiction, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SECTransactionReport _that = (SECTransactionReport)this.getType().cast(o);
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierSource, (Object)_that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.customBasketIndicator, _that.getCustomBasketIndicator())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.packageIndicator, _that.getPackageIndicator())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!ListEquals.listEquals(this.clearingSwapUSIs, _that.getClearingSwapUSIs())) {
                return false;
            }
            if (!ListEquals.listEquals(this.clearingSwapUTIs, _that.getClearingSwapUTIs())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapUSI, _that.getOriginalSwapUSI())) {
                return false;
            }
            if (!Objects.equals(this.postPricedSwapIndicator, _that.getPostPricedSwapIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.allocationIndicator, (Object)_that.getAllocationIndicator())) {
                return false;
            }
            if (!Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1FinancialEntityIndicator, _that.getCounterparty1FinancialEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2FinancialEntityIndicator, _that.getCounterparty2FinancialEntityIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.jurisdiction, (Object)_that.getJurisdiction())) {
                return false;
            }
            return Objects.equals(this.dtccAdditionalFields, _that.getDtccAdditionalFields());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? ((Object)((Object)this.counterparty2IdentifierSource)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.customBasketIndicator != null ? this.customBasketIndicator.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.packageIndicator != null ? this.packageIndicator.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.clearingSwapUSIs != null ? this.clearingSwapUSIs.hashCode() : 0);
            _result = 31 * _result + (this.clearingSwapUTIs != null ? this.clearingSwapUTIs.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapUSI != null ? this.originalSwapUSI.hashCode() : 0);
            _result = 31 * _result + (this.postPricedSwapIndicator != null ? this.postPricedSwapIndicator.hashCode() : 0);
            _result = 31 * _result + (this.allocationIndicator != null ? ((Object)((Object)this.allocationIndicator)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1FinancialEntityIndicator != null ? this.counterparty1FinancialEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2FinancialEntityIndicator != null ? this.counterparty2FinancialEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.jurisdiction != null ? ((Object)((Object)this.jurisdiction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dtccAdditionalFields != null ? this.dtccAdditionalFields.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SECTransactionReportBuilder {cleared=" + String.valueOf((Object)this.cleared) + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierSource=" + String.valueOf((Object)this.counterparty2IdentifierSource) + ", customBasketIndicator=" + this.customBasketIndicator + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", packageIndicator=" + this.packageIndicator + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", clearingSwapUSIs=" + String.valueOf(this.clearingSwapUSIs) + ", clearingSwapUTIs=" + String.valueOf(this.clearingSwapUTIs) + ", originalSwapUSI=" + this.originalSwapUSI + ", postPricedSwapIndicator=" + this.postPricedSwapIndicator + ", allocationIndicator=" + String.valueOf((Object)this.allocationIndicator) + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", counterparty1FinancialEntityIndicator=" + this.counterparty1FinancialEntityIndicator + ", counterparty2FinancialEntityIndicator=" + this.counterparty2FinancialEntityIndicator + ", jurisdiction=" + String.valueOf((Object)this.jurisdiction) + ", dtccAdditionalFields=" + String.valueOf(this.dtccAdditionalFields) + "} " + super.toString();
        }
    }

    public static interface SECTransactionReportBuilder
    extends SECTransactionReport,
    CommonTransactionReport.CommonTransactionReportBuilder {
        public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getOrCreateDtccAdditionalFields();

        @Override
        public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getDtccAdditionalFields();

        @Override
        public SECTransactionReportBuilder setEffectiveDate(Date var1);

        @Override
        public SECTransactionReportBuilder setEarlyTerminationDate(Date var1);

        @Override
        public SECTransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public SECTransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        @Override
        public SECTransactionReportBuilder setExpirationDate(Date var1);

        @Override
        public SECTransactionReportBuilder setCounterparty1(String var1);

        @Override
        public SECTransactionReportBuilder setCounterparty2(String var1);

        @Override
        public SECTransactionReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public SECTransactionReportBuilder setBeneficiary1(String var1);

        @Override
        public SECTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        @Override
        public SECTransactionReportBuilder setBuyerIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setSellerIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setCleared(ClearedEnum var1);

        @Override
        public SECTransactionReportBuilder setCentralCounterparty(String var1);

        @Override
        public SECTransactionReportBuilder setClearingMember(String var1);

        @Override
        public SECTransactionReportBuilder setConfirmed(ConfirmationEnum var1);

        @Override
        public SECTransactionReportBuilder setCallAmount(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder setPutAmount(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setDelta(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder addPriceSchedule(PricePeriod var1);

        @Override
        public SECTransactionReportBuilder addPriceSchedule(PricePeriod var1, int var2);

        @Override
        public SECTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public SECTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public SECTransactionReportBuilder addStrikePriceSchedule(PricePeriod var1);

        @Override
        public SECTransactionReportBuilder addStrikePriceSchedule(PricePeriod var1, int var2);

        @Override
        public SECTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public SECTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public SECTransactionReportBuilder setPrice(PriceFormat var1);

        @Override
        public SECTransactionReportBuilder setPriceNotation(PriceNotationEnum var1);

        @Override
        public SECTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setPackageTransactionPrice(PriceFormat var1);

        @Override
        public SECTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum var1);

        @Override
        public SECTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setPackageTransactionSpread(PriceFormat var1);

        @Override
        public SECTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum var1);

        @Override
        public SECTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setPackageIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setStrikePrice(PriceFormat var1);

        @Override
        public SECTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum var1);

        @Override
        public SECTransactionReportBuilder setStrikePriceCurrency(String var1);

        @Override
        public SECTransactionReportBuilder setPriceUnitOfMeasure(String var1);

        @Override
        public SECTransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setOptionPremiumPaymentDate(Date var1);

        @Override
        public SECTransactionReportBuilder setExchangeRate(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder setExchangeRateBasis(String var1);

        @Override
        public SECTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public SECTransactionReportBuilder setFirstExerciseDate(Date var1);

        @Override
        public SECTransactionReportBuilder setFinalContractualSettlementDate(Date var1);

        @Override
        public SECTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setPriorUTI(String var1);

        @Override
        public SECTransactionReportBuilder setDirection1(Direction1Enum var1);

        @Override
        public SECTransactionReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public SECTransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public SECTransactionReportBuilder setCustomBasketCode(String var1);

        @Override
        public SECTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1);

        @Override
        public SECTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        @Override
        public SECTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public SECTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public SECTransactionReportBuilder addOtherPayment(OtherPayment var1);

        @Override
        public SECTransactionReportBuilder addOtherPayment(OtherPayment var1, int var2);

        @Override
        public SECTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public SECTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public SECTransactionReportBuilder setLeg1(LegV1 var1);

        @Override
        public SECTransactionReportBuilder setLeg2(LegV1 var1);

        @Override
        public SECTransactionReportBuilder setLeg1(LegV2 var1);

        @Override
        public SECTransactionReportBuilder setLeg2(LegV2 var1);

        @Override
        public SECTransactionReportBuilder setLeg1(Leg var1);

        @Override
        public SECTransactionReportBuilder setLeg2(Leg var1);

        @Override
        public SECTransactionReportBuilder setUnderlyingIdOther(String var1);

        @Override
        public SECTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum var1);

        @Override
        public SECTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setUnderlyingAssetPriceSource(String var1);

        @Override
        public SECTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean var1);

        @Override
        public SECTransactionReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public SECTransactionReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public SECTransactionReportBuilder setEventType(EventTypeEnum var1);

        @Override
        public SECTransactionReportBuilder setEventIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setEventTimestamp(ZonedDateTime var1);

        @Override
        public SECTransactionReportBuilder setLeg1(CommonLeg var1);

        @Override
        public SECTransactionReportBuilder setLeg2(CommonLeg var1);

        @Override
        public SECTransactionReportBuilder setCounterparty2Name(String var1);

        @Override
        public SECTransactionReportBuilder setExecutionAgentCounterparty1(String var1);

        @Override
        public SECTransactionReportBuilder setExecutionAgentCounterparty2(String var1);

        @Override
        public SECTransactionReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public SECTransactionReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public SECTransactionReportBuilder setPriorUTIProprietary(String var1);

        @Override
        public SECTransactionReportBuilder setUniqueProductIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setContractType(CommonContractType var1);

        @Override
        public SECTransactionReportBuilder setAssetClass(CommonAssetClass var1);

        @Override
        public SECTransactionReportBuilder setClearingTimestamp(ZonedDateTime var1);

        @Override
        public SECTransactionReportBuilder setPlatformIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier var1);

        @Override
        public SECTransactionReportBuilder setNameOfTheUnderlyingIndex(String var1);

        @Override
        public SECTransactionReportBuilder setMaturityDateOfTheUnderlying(Date var1);

        @Override
        public SECTransactionReportBuilder setOptionType(OptionTypeCode var1);

        @Override
        public SECTransactionReportBuilder setOptionStyle(OptionStyleEnum var1);

        @Override
        public SECTransactionReportBuilder setDeliveryType(DeliveryTypeEnum var1);

        @Override
        public SECTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum var1);

        @Override
        public SECTransactionReportBuilder setTradingCapacity(TradingCapacity7Code var1);

        @Override
        public SECTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum var1);

        @Override
        public SECTransactionReportBuilder setSeniority(SeniorityEnum var1);

        @Override
        public SECTransactionReportBuilder setSeries(Integer var1);

        @Override
        public SECTransactionReportBuilder setIndexFactor(BigDecimal var1);

        @Override
        public SECTransactionReportBuilder setTechnicalRecordId(String var1);

        @Override
        public SECTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum var1);

        @Override
        public SECTransactionReportBuilder setOriginalSwapUTI(String var1);

        @Override
        public SECTransactionReportBuilder setOriginalSwapSDRIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime var1);

        @Override
        public SECTransactionReportBuilder setPriorUSI(String var1);

        @Override
        public SECTransactionReportBuilder setNewSDRIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public SECTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public SECTransactionReportBuilder setSubsequentPositionUTI(String var1);

        @Override
        public SECTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum var1);

        @Override
        public SECTransactionReportBuilder setMasterAgreementVersion(Integer var1);

        @Override
        public SECTransactionReportBuilder setNonStandardizedTermIndicator(Boolean var1);

        @Override
        public SECTransactionReportBuilder setAmendmentIndicator(Boolean var1);

        @Override
        public SECTransactionReportBuilder setPackageIndicator(Boolean var1);

        @Override
        public SECTransactionReportBuilder setBrokerID(String var1);

        @Override
        public SECTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime var1);

        @Override
        public SECTransactionReportBuilder setSeriesVersion(Integer var1);

        @Override
        public SECTransactionReportBuilder setSecondaryTransactionIdentifier(String var1);

        @Override
        public SECTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum var1);

        @Override
        public SECTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum var1);

        @Override
        public SECTransactionReportBuilder setSwapLinkID(String var1);

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public SECTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public SECTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public SECTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public SECTransactionReportBuilder setBaseProduct(String var1);

        @Override
        public SECTransactionReportBuilder setSubProduct(String var1);

        @Override
        public SECTransactionReportBuilder setFurtherSubProduct(String var1);

        @Override
        public SECTransactionReportBuilder setIntragroup(Boolean var1);

        @Override
        public SECTransactionReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public SECTransactionReportBuilder setReferenceEntity(String var1);

        @Override
        public SECTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum var1);

        @Override
        public SECTransactionReportBuilder setCustomBasketIndicator(Boolean var1);

        @Override
        public SECTransactionReportBuilder setUnderlyingIdentification(String var1);

        @Override
        public SECTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum var1);

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1);

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1, int var2);

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public SECTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1);

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1, int var2);

        @Override
        public SECTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public SECTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public SECTransactionReportBuilder setNonReportable(NonReportable var1);

        public SECTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum var1);

        public SECTransactionReportBuilder setCounterparty2OverriddenAsString(String var1);

        public SECTransactionReportBuilder setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(Counterparty2IdentifierEnum var1);

        public SECTransactionReportBuilder setCustomBasketIndicatorOverriddenAsBoolean(Boolean var1);

        public SECTransactionReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public SECTransactionReportBuilder setPackageIndicatorOverriddenAsBoolean(Boolean var1);

        public SECTransactionReportBuilder setEffectiveDateOverriddenAsDate(Date var1);

        public SECTransactionReportBuilder setExecutionTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public SECTransactionReportBuilder addClearingSwapUSIs(String var1);

        public SECTransactionReportBuilder addClearingSwapUSIs(String var1, int var2);

        public SECTransactionReportBuilder addClearingSwapUSIs(List<String> var1);

        public SECTransactionReportBuilder setClearingSwapUSIs(List<String> var1);

        public SECTransactionReportBuilder addClearingSwapUTIs(String var1);

        public SECTransactionReportBuilder addClearingSwapUTIs(String var1, int var2);

        public SECTransactionReportBuilder addClearingSwapUTIs(List<String> var1);

        public SECTransactionReportBuilder setClearingSwapUTIs(List<String> var1);

        public SECTransactionReportBuilder setOriginalSwapUSI(String var1);

        public SECTransactionReportBuilder setPostPricedSwapIndicator(Boolean var1);

        public SECTransactionReportBuilder setAllocationIndicator(AllocationIndicatorEnum var1);

        public SECTransactionReportBuilder setUniqueSwapIdentifier(String var1);

        public SECTransactionReportBuilder setCounterparty1FinancialEntityIndicator(Boolean var1);

        public SECTransactionReportBuilder setCounterparty2FinancialEntityIndicator(Boolean var1);

        public SECTransactionReportBuilder setJurisdiction(JurisdictionEnum var1);

        public SECTransactionReportBuilder setDtccAdditionalFields(DTCCAdditionalFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, (RosettaModelObjectBuilder)this.getBarrier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.NonReportableBuilder.class, (RosettaModelObjectBuilder)this.getNonReportable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingSwapUSIs"), String.class, this.getClearingSwapUSIs(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingSwapUTIs"), String.class, this.getClearingSwapUTIs(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUSI"), String.class, (Object)this.getOriginalSwapUSI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, (Object)this.getPostPricedSwapIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("allocationIndicator"), AllocationIndicatorEnum.class, (Object)this.getAllocationIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1FinancialEntityIndicator"), Boolean.class, (Object)this.getCounterparty1FinancialEntityIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2FinancialEntityIndicator"), Boolean.class, (Object)this.getCounterparty2FinancialEntityIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("jurisdiction"), JurisdictionEnum.class, (Object)this.getJurisdiction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dtccAdditionalFields"), processor, DTCCAdditionalFields.DTCCAdditionalFieldsBuilder.class, this.getDtccAdditionalFields(), new AttributeMeta[0]);
        }

        @Override
        public SECTransactionReportBuilder prune();
    }

    public static class SECTransactionReportImpl
    extends CommonTransactionReport.CommonTransactionReportImpl
    implements SECTransactionReport {
        private final ClearedEnum cleared;
        private final String counterparty2;
        private final Counterparty2IdentifierEnum counterparty2IdentifierSource;
        private final Boolean customBasketIndicator;
        private final ZonedDateTime eventTimestamp;
        private final Boolean packageIndicator;
        private final Date effectiveDate;
        private final ZonedDateTime executionTimestamp;
        private final List<String> clearingSwapUSIs;
        private final List<String> clearingSwapUTIs;
        private final String originalSwapUSI;
        private final Boolean postPricedSwapIndicator;
        private final AllocationIndicatorEnum allocationIndicator;
        private final String uniqueSwapIdentifier;
        private final Boolean counterparty1FinancialEntityIndicator;
        private final Boolean counterparty2FinancialEntityIndicator;
        private final JurisdictionEnum jurisdiction;
        private final DTCCAdditionalFields dtccAdditionalFields;

        protected SECTransactionReportImpl(SECTransactionReportBuilder builder) {
            super(builder);
            this.cleared = builder.getCleared();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
            this.customBasketIndicator = builder.getCustomBasketIndicator();
            this.eventTimestamp = builder.getEventTimestamp();
            this.packageIndicator = builder.getPackageIndicator();
            this.effectiveDate = builder.getEffectiveDate();
            this.executionTimestamp = builder.getExecutionTimestamp();
            this.clearingSwapUSIs = Optional.ofNullable(builder.getClearingSwapUSIs()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.clearingSwapUTIs = Optional.ofNullable(builder.getClearingSwapUTIs()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.originalSwapUSI = builder.getOriginalSwapUSI();
            this.postPricedSwapIndicator = builder.getPostPricedSwapIndicator();
            this.allocationIndicator = builder.getAllocationIndicator();
            this.uniqueSwapIdentifier = builder.getUniqueSwapIdentifier();
            this.counterparty1FinancialEntityIndicator = builder.getCounterparty1FinancialEntityIndicator();
            this.counterparty2FinancialEntityIndicator = builder.getCounterparty2FinancialEntityIndicator();
            this.jurisdiction = builder.getJurisdiction();
            this.dtccAdditionalFields = Optional.ofNullable(builder.getDtccAdditionalFields()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public Counterparty2IdentifierEnum getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator", isRequired=true)
        @RuneAttribute(value="customBasketIndicator", isRequired=true)
        public Boolean getCustomBasketIndicator() {
            return this.customBasketIndicator;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="packageIndicator", isRequired=true)
        @RuneAttribute(value="packageIndicator", isRequired=true)
        public Boolean getPackageIndicator() {
            return this.packageIndicator;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="clearingSwapUSIs")
        @RuneAttribute(value="clearingSwapUSIs")
        public List<String> getClearingSwapUSIs() {
            return this.clearingSwapUSIs;
        }

        @Override
        @RosettaAttribute(value="clearingSwapUTIs")
        @RuneAttribute(value="clearingSwapUTIs")
        public List<String> getClearingSwapUTIs() {
            return this.clearingSwapUTIs;
        }

        @Override
        @RosettaAttribute(value="originalSwapUSI")
        @RuneAttribute(value="originalSwapUSI")
        public String getOriginalSwapUSI() {
            return this.originalSwapUSI;
        }

        @Override
        @RosettaAttribute(value="postPricedSwapIndicator", isRequired=true)
        @RuneAttribute(value="postPricedSwapIndicator", isRequired=true)
        public Boolean getPostPricedSwapIndicator() {
            return this.postPricedSwapIndicator;
        }

        @Override
        @RosettaAttribute(value="allocationIndicator", isRequired=true)
        @RuneAttribute(value="allocationIndicator", isRequired=true)
        public AllocationIndicatorEnum getAllocationIndicator() {
            return this.allocationIndicator;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="counterparty1FinancialEntityIndicator")
        @RuneAttribute(value="counterparty1FinancialEntityIndicator")
        public Boolean getCounterparty1FinancialEntityIndicator() {
            return this.counterparty1FinancialEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
        public Boolean getCounterparty2FinancialEntityIndicator() {
            return this.counterparty2FinancialEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="jurisdiction", isRequired=true)
        @RuneAttribute(value="jurisdiction", isRequired=true)
        public JurisdictionEnum getJurisdiction() {
            return this.jurisdiction;
        }

        @Override
        @RosettaAttribute(value="dtccAdditionalFields")
        @RuneAttribute(value="dtccAdditionalFields")
        public DTCCAdditionalFields getDtccAdditionalFields() {
            return this.dtccAdditionalFields;
        }

        @Override
        public SECTransactionReport build() {
            return this;
        }

        @Override
        public SECTransactionReportBuilder toBuilder() {
            SECTransactionReportBuilder builder = SECTransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SECTransactionReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setClearedOverriddenAsClearedEnum);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2OverriddenAsString);
            Optional.ofNullable(this.getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum);
            Optional.ofNullable(this.getCustomBasketIndicator()).ifPresent(builder::setCustomBasketIndicatorOverriddenAsBoolean);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getPackageIndicator()).ifPresent(builder::setPackageIndicatorOverriddenAsBoolean);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDateOverriddenAsDate);
            Optional.ofNullable(this.getExecutionTimestamp()).ifPresent(builder::setExecutionTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getClearingSwapUSIs()).ifPresent(builder::setClearingSwapUSIs);
            Optional.ofNullable(this.getClearingSwapUTIs()).ifPresent(builder::setClearingSwapUTIs);
            Optional.ofNullable(this.getOriginalSwapUSI()).ifPresent(builder::setOriginalSwapUSI);
            Optional.ofNullable(this.getPostPricedSwapIndicator()).ifPresent(builder::setPostPricedSwapIndicator);
            Optional.ofNullable(this.getAllocationIndicator()).ifPresent(builder::setAllocationIndicator);
            Optional.ofNullable(this.getUniqueSwapIdentifier()).ifPresent(builder::setUniqueSwapIdentifier);
            Optional.ofNullable(this.getCounterparty1FinancialEntityIndicator()).ifPresent(builder::setCounterparty1FinancialEntityIndicator);
            Optional.ofNullable(this.getCounterparty2FinancialEntityIndicator()).ifPresent(builder::setCounterparty2FinancialEntityIndicator);
            Optional.ofNullable(this.getJurisdiction()).ifPresent(builder::setJurisdiction);
            Optional.ofNullable(this.getDtccAdditionalFields()).ifPresent(builder::setDtccAdditionalFields);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SECTransactionReport _that = (SECTransactionReport)this.getType().cast(o);
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierSource, (Object)_that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.customBasketIndicator, _that.getCustomBasketIndicator())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.packageIndicator, _that.getPackageIndicator())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!ListEquals.listEquals(this.clearingSwapUSIs, _that.getClearingSwapUSIs())) {
                return false;
            }
            if (!ListEquals.listEquals(this.clearingSwapUTIs, _that.getClearingSwapUTIs())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapUSI, _that.getOriginalSwapUSI())) {
                return false;
            }
            if (!Objects.equals(this.postPricedSwapIndicator, _that.getPostPricedSwapIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.allocationIndicator, (Object)_that.getAllocationIndicator())) {
                return false;
            }
            if (!Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1FinancialEntityIndicator, _that.getCounterparty1FinancialEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2FinancialEntityIndicator, _that.getCounterparty2FinancialEntityIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.jurisdiction, (Object)_that.getJurisdiction())) {
                return false;
            }
            return Objects.equals(this.dtccAdditionalFields, _that.getDtccAdditionalFields());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? ((Object)((Object)this.counterparty2IdentifierSource)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.customBasketIndicator != null ? this.customBasketIndicator.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.packageIndicator != null ? this.packageIndicator.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.clearingSwapUSIs != null ? this.clearingSwapUSIs.hashCode() : 0);
            _result = 31 * _result + (this.clearingSwapUTIs != null ? this.clearingSwapUTIs.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapUSI != null ? this.originalSwapUSI.hashCode() : 0);
            _result = 31 * _result + (this.postPricedSwapIndicator != null ? this.postPricedSwapIndicator.hashCode() : 0);
            _result = 31 * _result + (this.allocationIndicator != null ? ((Object)((Object)this.allocationIndicator)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1FinancialEntityIndicator != null ? this.counterparty1FinancialEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2FinancialEntityIndicator != null ? this.counterparty2FinancialEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.jurisdiction != null ? ((Object)((Object)this.jurisdiction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dtccAdditionalFields != null ? this.dtccAdditionalFields.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SECTransactionReport {cleared=" + String.valueOf((Object)this.cleared) + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierSource=" + String.valueOf((Object)this.counterparty2IdentifierSource) + ", customBasketIndicator=" + this.customBasketIndicator + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", packageIndicator=" + this.packageIndicator + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", clearingSwapUSIs=" + String.valueOf(this.clearingSwapUSIs) + ", clearingSwapUTIs=" + String.valueOf(this.clearingSwapUTIs) + ", originalSwapUSI=" + this.originalSwapUSI + ", postPricedSwapIndicator=" + this.postPricedSwapIndicator + ", allocationIndicator=" + String.valueOf((Object)this.allocationIndicator) + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", counterparty1FinancialEntityIndicator=" + this.counterparty1FinancialEntityIndicator + ", counterparty2FinancialEntityIndicator=" + this.counterparty2FinancialEntityIndicator + ", jurisdiction=" + String.valueOf((Object)this.jurisdiction) + ", dtccAdditionalFields=" + String.valueOf(this.dtccAdditionalFields) + "} " + super.toString();
        }
    }
}

