/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.execution.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.template.CalculationSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.standards.iosco.cde.version1.execution.functions.SettlementDateFromCalculationPeriodDates;
import drr.standards.iosco.cde.version1.execution.functions.SettlementDateFromSchedule;
import drr.standards.iosco.cde.version1.execution.functions.SettlemetDateFromPaymentDate;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=CommoditySettlementDateDefault.class)
public abstract class CommoditySettlementDate
implements RosettaFunction {
    @Inject
    protected SettlementDateFromCalculationPeriodDates settlementDateFromCalculationPeriodDates;
    @Inject
    protected SettlementDateFromSchedule settlementDateFromSchedule;
    @Inject
    protected SettlemetDateFromPaymentDate settlemetDateFromPaymentDate;

    public List<Date> evaluate(CommodityPayout commodityPayout) {
        List<Date> commodityDate = this.doEvaluate(commodityPayout);
        return commodityDate;
    }

    protected abstract List<Date> doEvaluate(CommodityPayout var1);

    public static class CommoditySettlementDateDefault
    extends CommoditySettlementDate {
        @Override
        protected List<Date> doEvaluate(CommodityPayout commodityPayout) {
            ArrayList<Date> commodityDate = new ArrayList<Date>();
            return this.assignOutput(commodityDate, commodityPayout);
        }

        protected List<Date> assignOutput(List<Date> commodityDate, CommodityPayout commodityPayout) {
            commodityDate.addAll(this.settlemetDateFromPaymentDate.evaluate((PaymentDates)MapperS.of((Object)commodityPayout).map("getPaymentDates", _commodityPayout -> _commodityPayout.getPaymentDates()).get()));
            commodityDate.addAll(this.settlementDateFromCalculationPeriodDates.evaluate((CalculationPeriodDates)MapperS.of((Object)commodityPayout).map("getCalculationPeriodDates", _commodityPayout -> _commodityPayout.getCalculationPeriodDates()).get()));
            commodityDate.addAll(this.settlementDateFromSchedule.evaluate((CalculationSchedule)MapperS.of((Object)commodityPayout).map("getSchedule", _commodityPayout -> _commodityPayout.getSchedule()).get()));
            return commodityDate;
        }
    }
}

