/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.execution.functions;

import cdm.product.common.schedule.ObservationTerms;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.standards.iosco.cde.version1.execution.functions.SettlementDateFromObservationTerms;
import drr.standards.iosco.cde.version1.execution.functions.SettlemetDateFromPaymentDate;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=PerformanceSettlementDateDefault.class)
public abstract class PerformanceSettlementDate
implements RosettaFunction {
    @Inject
    protected SettlementDateFromObservationTerms settlementDateFromObservationTerms;
    @Inject
    protected SettlemetDateFromPaymentDate settlemetDateFromPaymentDate;

    public List<Date> evaluate(PerformancePayout performancePayout) {
        List<Date> performanceDate = this.doEvaluate(performancePayout);
        return performanceDate;
    }

    protected abstract List<Date> doEvaluate(PerformancePayout var1);

    public static class PerformanceSettlementDateDefault
    extends PerformanceSettlementDate {
        @Override
        protected List<Date> doEvaluate(PerformancePayout performancePayout) {
            ArrayList<Date> performanceDate = new ArrayList<Date>();
            return this.assignOutput(performanceDate, performancePayout);
        }

        protected List<Date> assignOutput(List<Date> performanceDate, PerformancePayout performancePayout) {
            performanceDate.addAll(this.settlemetDateFromPaymentDate.evaluate((PaymentDates)MapperS.of((Object)performancePayout).map("getPaymentDates", _performancePayout -> _performancePayout.getPaymentDates()).get()));
            performanceDate.addAll(this.settlementDateFromObservationTerms.evaluate((ObservationTerms)MapperS.of((Object)performancePayout).map("getObservationTerms", _performancePayout -> _performancePayout.getObservationTerms()).get()));
            return performanceDate;
        }
    }
}

