/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.execution.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableDates;
import cdm.product.template.OptionExercise;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.util.datetime.functions.AdjustableDateResolution;
import drr.base.util.datetime.functions.AdjustableDatesResolution;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=SettlementDateFromExerciseTermsDefault.class)
public abstract class SettlementDateFromExerciseTerms
implements RosettaFunction {
    @Inject
    protected AdjustableDateResolution adjustableDateResolution;
    @Inject
    protected AdjustableDatesResolution adjustableDatesResolution;

    public List<Date> evaluate(OptionExercise exerciseTerms) {
        List<Date> date = this.doEvaluate(exerciseTerms);
        return date;
    }

    protected abstract List<Date> doEvaluate(OptionExercise var1);

    public static class SettlementDateFromExerciseTermsDefault
    extends SettlementDateFromExerciseTerms {
        @Override
        protected List<Date> doEvaluate(OptionExercise exerciseTerms) {
            ArrayList<Date> date = new ArrayList<Date>();
            return this.assignOutput(date, exerciseTerms);
        }

        protected List<Date> assignOutput(List<Date> date, OptionExercise exerciseTerms) {
            date.addAll(MapperS.of((Object)exerciseTerms).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get()))).getMulti());
            date.addAll(MapperS.of((Object)exerciseTerms).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).map("getExpirationDate", americanExercise -> americanExercise.getExpirationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapSingleToItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get()))).getMulti());
            date.addAll(MapperS.of((Object)exerciseTerms).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates()).mapSingleToList(item -> MapperC.of(this.adjustableDatesResolution.evaluate((AdjustableDates)item.get()))).getMulti());
            return date;
        }
    }
}

