/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.execution.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.common.settlement.SettlementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.standards.iosco.cde.version1.execution.reports.SettlementTermsRule;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=SettlementCurrencyRuleDefault.class)
public abstract class SettlementCurrencyRule
implements ReportFunction<PayoutLegWithAuxiliary, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected SettlementTermsRule settlementTermsRule;

    public ISOCurrencyCodeEnum evaluate(PayoutLegWithAuxiliary input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(PayoutLegWithAuxiliary var1);

    public static class SettlementCurrencyRuleDefault
    extends SettlementCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(PayoutLegWithAuxiliary input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, PayoutLegWithAuxiliary input) {
            MapperS thenArg0 = MapperS.of((Object)this.settlementTermsRule.evaluate(input));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)item.map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.exists((Mapper)item.mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSettlementCurrency", settlementTerms -> settlementTerms.getSettlementCurrency());
                }
                return MapperS.ofNull();
            });
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

