/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.party.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCapFloor;
import drr.base.qualification.product.functions.IsCommodityForward;
import drr.base.qualification.product.functions.IsCreditDefaultSwap;
import drr.base.qualification.product.functions.IsEquityForward;
import drr.base.qualification.product.functions.IsProductETD;
import drr.base.qualification.product.functions.IsSingleCommodityPayoutProduct;
import drr.base.qualification.product.functions.IsTotalReturnSwapDebtUnderlier;
import drr.base.qualification.product.functions.IsVarianceSwap;
import drr.base.qualification.product.functions.IsVolatilitySwap;
import drr.base.trade.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Direction1SellerPartyDefault.class)
public abstract class Direction1SellerParty
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected IsCapFloor isCapFloor;
    @Inject
    protected IsCommodityForward isCommodityForward;
    @Inject
    protected IsCreditDefaultSwap isCreditDefaultSwap;
    @Inject
    protected IsEquityForward isEquityForward;
    @Inject
    protected IsProductETD isProductETD;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;
    @Inject
    protected IsVarianceSwap isVarianceSwap;
    @Inject
    protected IsVolatilitySwap isVolatilitySwap;
    @Inject
    protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;

    public Party evaluate(Trade trade) {
        Party party;
        Party.PartyBuilder partyBuilder = this.doEvaluate(trade);
        if (partyBuilder == null) {
            party = null;
        } else {
            party = partyBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)party);
        }
        return party;
    }

    protected abstract Party.PartyBuilder doEvaluate(Trade var1);

    protected abstract MapperS<? extends Payout> productPayout(Trade var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Trade var1);

    protected abstract MapperS<? extends Counterparty> counterparty(Trade var1);

    public static class Direction1SellerPartyDefault
    extends Direction1SellerParty {
        @Override
        protected Party.PartyBuilder doEvaluate(Trade trade) {
            Party.PartyBuilder party = Party.builder();
            return this.assignOutput(party, trade);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, Trade trade) {
            ReferenceWithMetaParty referenceWithMetaParty = (ReferenceWithMetaParty)this.counterparty(trade).map("getPartyReference", _counterparty -> _counterparty.getPartyReference()).get();
            party = referenceWithMetaParty == null ? null : (Party.PartyBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaParty.getValue());
            return Optional.ofNullable(party).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Payout> productPayout(Trade trade) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())).map("getPayout", _economicTerms -> _economicTerms.getPayout());
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Trade trade) {
            return MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
        }

        @Override
        protected MapperS<? extends Counterparty> counterparty(Trade trade) {
            if (ExpressionOperators.exists((Mapper)this.productPayout(trade).mapC("getOptionPayout", payout -> payout.getOptionPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((OptionPayout)this.productPayout(trade).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getBuyerSeller", optionPayout -> optionPayout.getBuyerSeller()).map("getSeller", buyerSeller -> buyerSeller.getSeller()).get()));
            }
            Boolean boolean0 = this.isCreditDefaultSwap.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)this.productPayout(trade).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getPayerReceiver", creditDefaultPayout -> creditDefaultPayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
            }
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isVarianceSwap.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isVolatilitySwap.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isTotalReturnSwapDebtUnderlier.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((PerformancePayout)this.productPayout(trade).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
            }
            Boolean boolean1 = this.isCapFloor.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((InterestRatePayout)this.productPayout(trade).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get())).map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
            }
            Boolean boolean2 = this.isSingleCommodityPayoutProduct.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            if (boolean2 != null && boolean2.booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((CommodityPayout)this.productPayout(trade).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getPayerReceiver", commodityPayout -> commodityPayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
            }
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isProductETD.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).and(ExpressionOperators.exists((Mapper)this.productPayout(trade).mapC("getForwardPayout", payout -> payout.getForwardPayout()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquityForward.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get())))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_InterestRate_Forward_Debt.evaluate((EconomicTerms)this.economicTerms(trade).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((ForwardPayout)this.economicTerms(trade).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()));
            }
            Boolean boolean3 = this.isCommodityForward.evaluate((Product)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            if (boolean3 != null && boolean3.booleanValue()) {
                return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)MapperS.of((Object)((ForwardPayout)this.economicTerms(trade).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getPayerReceiver", forwardPayout -> forwardPayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()));
            }
            return MapperS.ofNull();
        }
    }
}

