/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.party.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.standards.iosco.cde.version1.party.functions.PayerReceiverFromPayout;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PayerPartyDefault.class)
public abstract class PayerParty
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected PayerReceiverFromPayout payerReceiverFromPayout;

    public Party evaluate(PayoutLegWithAuxiliary payout, List<? extends Counterparty> counterparties) {
        Party party;
        Party.PartyBuilder partyBuilder = this.doEvaluate(payout, counterparties);
        if (partyBuilder == null) {
            party = null;
        } else {
            party = partyBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)party);
        }
        return party;
    }

    protected abstract Party.PartyBuilder doEvaluate(PayoutLegWithAuxiliary var1, List<? extends Counterparty> var2);

    public static class PayerPartyDefault
    extends PayerParty {
        @Override
        protected Party.PartyBuilder doEvaluate(PayoutLegWithAuxiliary payout, List<? extends Counterparty> counterparties) {
            if (counterparties == null) {
                counterparties = Collections.emptyList();
            }
            Party.PartyBuilder party = Party.builder();
            return this.assignOutput(party, payout, counterparties);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, PayoutLegWithAuxiliary payout, List<? extends Counterparty> counterparties) {
            ReferenceWithMetaParty referenceWithMetaParty = (ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(counterparties, (CounterpartyRoleEnum)MapperS.of((Object)this.payerReceiverFromPayout.evaluate(payout)).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get())).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get();
            party = referenceWithMetaParty == null ? null : (Party.PartyBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaParty.getValue());
            return Optional.ofNullable(party).map(o -> o.prune()).orElse(null);
        }
    }
}

