/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.payment.functions;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.event.common.Transfer;
import cdm.observable.asset.FeeTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.ReportableEventBase;
import drr.base.util.datetime.functions.AdjustableOrAdjustedOrRelativeDateResolution;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=OptionPremiumOnEventDateDefault.class)
public abstract class OptionPremiumOnEventDate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AdjustableOrAdjustedOrRelativeDateResolution adjustableOrAdjustedOrRelativeDateResolution;

    public Transfer evaluate(ReportableEventBase reportableEvent) {
        Transfer optionPremium;
        Transfer.TransferBuilder optionPremiumBuilder = this.doEvaluate(reportableEvent);
        if (optionPremiumBuilder == null) {
            optionPremium = null;
        } else {
            optionPremium = optionPremiumBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)optionPremium);
        }
        return optionPremium;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(ReportableEventBase var1);

    protected abstract MapperS<Date> eventDate(ReportableEventBase var1);

    protected abstract MapperC<? extends Transfer> premiums(ReportableEventBase var1);

    public static class OptionPremiumOnEventDateDefault
    extends OptionPremiumOnEventDate {
        @Override
        protected Transfer.TransferBuilder doEvaluate(ReportableEventBase reportableEvent) {
            Transfer.TransferBuilder optionPremium = Transfer.builder();
            return this.assignOutput(optionPremium, reportableEvent);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder optionPremium, ReportableEventBase reportableEvent) {
            optionPremium = ExpressionOperators.areEqual((Mapper)MapperS.of((Object)this.premiums(reportableEvent).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (Transfer.TransferBuilder)this.toBuilder((RosettaModelObject)this.premiums(reportableEvent).get()) : (ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.premiums(reportableEvent).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (Transfer.TransferBuilder)this.toBuilder((RosettaModelObject)this.premiums(reportableEvent).max(item -> MapperS.of((Object)this.adjustableOrAdjustedOrRelativeDateResolution.evaluate((AdjustableOrAdjustedOrRelativeDate)item.map("getSettlementDate", transfer -> transfer.getSettlementDate()).get()))).get()) : null);
            return Optional.ofNullable(optionPremium).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<Date> eventDate(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)reportableEvent).map("getOriginatingWorkflowStep", reportableEventBase -> reportableEventBase.getOriginatingWorkflowStep()).map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).map("getEventDate", businessEvent -> businessEvent.getEventDate());
        }

        @Override
        protected MapperC<? extends Transfer> premiums(ReportableEventBase reportableEvent) {
            MapperC thenArg = MapperS.of((Object)reportableEvent).map("getOriginatingWorkflowStep", reportableEventBase -> reportableEventBase.getOriginatingWorkflowStep()).map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).mapC("getAfter", businessEvent -> businessEvent.getAfter()).mapC("getTransferHistory", tradeState -> tradeState.getTransferHistory()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getTransfer", transferState -> transferState.getTransfer()).map("getTransferExpression", transfer -> transfer.getTransferExpression()).map("getPriceTransfer", transferExpression -> transferExpression.getPriceTransfer()), (Mapper)MapperS.of((Object)FeeTypeEnum.PREMIUM), (CardinalityOperator)CardinalityOperator.All).get());
            return thenArg.map("getTransfer", transferState -> transferState.getTransfer());
        }
    }
}

