/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.standards.iosco.cde.version1.payment.functions.OptionPremiumOnEventDate;
import drr.standards.iso.functions.FormatToShortFraction5DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=OptionPremiumAmountRuleDefault.class)
public abstract class OptionPremiumAmountRule
implements ReportFunction<TransactionReportInstructionBase, BigDecimal> {
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
    @Inject
    protected OptionPremiumOnEventDate optionPremiumOnEventDate;

    public BigDecimal evaluate(TransactionReportInstructionBase input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstructionBase var1);

    public static class OptionPremiumAmountRuleDefault
    extends OptionPremiumAmountRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstructionBase input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstructionBase input) {
            MapperS thenArg = MapperS.of((Object)this.optionPremiumOnEventDate.evaluate(input)).map("getQuantity", transfer -> transfer.getQuantity()).map("getValue", nonNegativeQuantity -> nonNegativeQuantity.getValue());
            output = (BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg.get())).get();
            return output;
        }
    }
}

