/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.WeatherUnitEnum;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.standards.iosco.cde.version1.price.functions.Price;
import drr.standards.iso.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.WeatherUnitToISO20022UnitOfMeasure;
import javax.inject.Inject;

@ImplementedBy(value=PriceUnitOfMeasureRuleDefault.class)
public abstract class PriceUnitOfMeasureRule
implements ReportFunction<TransactionReportInstructionBase, String> {
    @Inject
    protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
    @Inject
    protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
    @Inject
    protected Price price;
    @Inject
    protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

    public String evaluate(TransactionReportInstructionBase input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstructionBase var1);

    public static class PriceUnitOfMeasureRuleDefault
    extends PriceUnitOfMeasureRule {
        @Override
        protected String doEvaluate(TransactionReportInstructionBase input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstructionBase input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.price.evaluate((ReportableEventBase)item.get())));
            output = (String)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.exists((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.capacityUnitToISO20022UnitOfMeasure.evaluate((CapacityUnitEnum)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
                }
                if (ExpressionOperators.exists((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.weatherUnitToISO20022UnitOfMeasure.evaluate((WeatherUnitEnum)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
                }
                if (ExpressionOperators.exists((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.financialUnitToISO20022UnitOfMeasure.evaluate((FinancialUnitEnum)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
                }
                if (ExpressionOperators.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.INTEREST_RATE), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.ofNull();
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

