/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.quantity.NotionalPeriod;
import drr.base.trade.quantity.reports.CustomScheduleRule;
import drr.base.trade.quantity.reports.QuantityScheduleRule;
import drr.base.util.datetime.functions.EnrichDatedValueWithEndDate;
import drr.standards.iso.functions.FormatToShortFraction5DecimalNumber;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=NotionalQuantityScheduleRuleDefault.class)
public abstract class NotionalQuantityScheduleRule
implements ReportFunction<PayoutLegWithAuxiliary, List<? extends NotionalPeriod>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CustomScheduleRule customScheduleRule;
    @Inject
    protected EnrichDatedValueWithEndDate enrichDatedValueWithEndDate;
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
    @Inject
    protected QuantityScheduleRule quantityScheduleRule;

    public List<? extends NotionalPeriod> evaluate(PayoutLegWithAuxiliary input) {
        List output;
        List<NotionalPeriod.NotionalPeriodBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(NotionalPeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(NotionalPeriod.class, output);
        }
        return output;
    }

    protected abstract List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(PayoutLegWithAuxiliary var1);

    public static class NotionalQuantityScheduleRuleDefault
    extends NotionalQuantityScheduleRule {
        @Override
        protected List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(PayoutLegWithAuxiliary input) {
            ArrayList<NotionalPeriod.NotionalPeriodBuilder> output = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<NotionalPeriod.NotionalPeriodBuilder> assignOutput(List<NotionalPeriod.NotionalPeriodBuilder> output, PayoutLegWithAuxiliary input) {
            NonNegativeQuantitySchedule nonNegativeQuantitySchedule = this.quantityScheduleRule.evaluate(input);
            MapperS thenArg0 = nonNegativeQuantitySchedule == null ? MapperS.ofNull() : MapperS.of((Object)ReferenceWithMetaNonNegativeQuantitySchedule.builder().setValue(nonNegativeQuantitySchedule).build());
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> ExpressionOperators.notExists((Mapper)item.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", _nonNegativeQuantitySchedule -> _nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get());
            output = this.toBuilder(MapperC.of(this.enrichDatedValueWithEndDate.evaluate(thenArg1.mapSingleToList(item -> item.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).mapC("getDatedValue", _nonNegativeQuantitySchedule -> _nonNegativeQuantitySchedule.getDatedValue())).getMulti(), this.customScheduleRule.evaluate(input))).mapItem(item -> {
                MapperS thenArg = item.map("getValue", valuePeriod -> valuePeriod.getValue());
                return MapperS.of((Object)NotionalPeriod.builder().setValue((BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg.get())).get()).setEffectiveDate((Date)item.map("getEffectiveDate", valuePeriod -> valuePeriod.getEffectiveDate()).get()).setEndDate((Date)item.map("getEndDate", valuePeriod -> valuePeriod.getEndDate()).get()).build());
            }).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

