/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.payment.PeriodicPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.base.trade.quantity.NotionalPeriod;
import drr.base.util.party.functions.CounterpartiesForEvent;
import drr.base.util.party.functions.CounterpartyRoleFromLEI;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.payment.functions.FixedInterestRatePayoutFromPayout;
import drr.regulation.common.trade.payment.functions.FloatingInterestRatePayoutFromPayout;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version2.execution.reports.SettlementCurrencyRule;
import drr.standards.iosco.cde.version2.party.functions.Direction2;
import drr.standards.iosco.cde.version2.party.reports.Counterparty1Rule;
import drr.standards.iosco.cde.version2.party.reports.Direction1Rule;
import drr.standards.iosco.cde.version2.payment.reports.DayCountConventionRule;
import drr.standards.iosco.cde.version2.payment.reports.PaymentFrequencyPeriodMultiplierRule;
import drr.standards.iosco.cde.version2.payment.reports.PaymentFrequencyPeriodRule;
import drr.standards.iosco.cde.version2.price.reports.FixedRateRule;
import drr.standards.iosco.cde.version2.price.reports.SpreadCurrencyRule;
import drr.standards.iosco.cde.version2.price.reports.SpreadValueRule;
import drr.standards.iosco.cde.version2.quantity.functions.NotionalAmountLeg1;
import drr.standards.iosco.cde.version2.quantity.functions.TotalNotionalQuantityLeg1;
import drr.standards.iosco.cde.version2.quantity.reports.NotionalAmountScheduleRule;
import drr.standards.iosco.cde.version2.quantity.reports.NotionalCurrencyLeg1Rule;
import drr.standards.iosco.cde.version2.quantity.reports.NotionalQuantityScheduleRule;
import drr.standards.iosco.cde.version2.quantity.reports.QuantityUnitOfMeasureRule;
import drr.standards.iso.Direction2Enum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Leg1Default.class)
public abstract class Leg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CounterpartiesForEvent counterpartiesForEvent;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected CounterpartyRoleFromLEI counterpartyRoleFromLEI;
    @Inject
    protected DayCountConventionRule dayCountConventionRule;
    @Inject
    protected Direction1Rule direction1Rule;
    @Inject
    protected Direction2 direction2;
    @Inject
    protected FixedInterestRatePayoutFromPayout fixedInterestRatePayoutFromPayout;
    @Inject
    protected FixedRateRule fixedRateRule;
    @Inject
    protected FloatingInterestRatePayoutFromPayout floatingInterestRatePayoutFromPayout;
    @Inject
    protected NotionalAmountLeg1 notionalAmountLeg1;
    @Inject
    protected NotionalAmountScheduleRule notionalAmountScheduleRule;
    @Inject
    protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
    @Inject
    protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
    @Inject
    protected PaymentFrequencyPeriodMultiplierRule paymentFrequencyPeriodMultiplierRule;
    @Inject
    protected PaymentFrequencyPeriodRule paymentFrequencyPeriodRule;
    @Inject
    protected PayoutLeg1Rule payoutLeg1Rule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected QuantityUnitOfMeasureRule quantityUnitOfMeasureRule;
    @Inject
    protected SettlementCurrencyRule settlementCurrencyRule;
    @Inject
    protected SpreadCurrencyRule spreadCurrencyRule;
    @Inject
    protected SpreadValueRule spreadValueRule;
    @Inject
    protected TotalNotionalQuantityLeg1 totalNotionalQuantityLeg1;

    public LegV2 evaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
        LegV2 leg;
        LegV2.LegV2Builder legBuilder = this.doEvaluate(transaction, spreadNotation, defaultValue);
        if (legBuilder == null) {
            leg = null;
        } else {
            leg = legBuilder.build();
            this.objectValidator.validate(LegV2.class, (RosettaModelObject)leg);
        }
        return leg;
    }

    protected abstract LegV2.LegV2Builder doEvaluate(TransactionReportInstruction var1, PriceNotationEnum var2, BigDecimal var3);

    public static class Leg1Default
    extends Leg1 {
        @Override
        protected LegV2.LegV2Builder doEvaluate(TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
            LegV2.LegV2Builder leg = LegV2.builder();
            return this.assignOutput(leg, transaction, spreadNotation, defaultValue);
        }

        protected LegV2.LegV2Builder assignOutput(LegV2.LegV2Builder leg, TransactionReportInstruction transaction, PriceNotationEnum spreadNotation, BigDecimal defaultValue) {
            leg = (LegV2.LegV2Builder)this.toBuilder((RosettaModelObject)MapperS.of((Object)transaction).mapSingleToItem(item -> {
                BigDecimal bigDecimal0 = this.paymentFrequencyPeriodMultiplierRule.evaluate(this.fixedInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())));
                BigDecimal bigDecimal1 = this.paymentFrequencyPeriodMultiplierRule.evaluate(this.floatingInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())));
                Direction2Enum ifThenElseResult = null;
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)((Object)this.direction1Rule.evaluate((TransactionReportInstruction)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = this.direction2.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get()), this.counterpartyRoleFromLEI.evaluate(this.counterpartiesForEvent.evaluate((ReportableEventBase)item.get()), this.counterparty1Rule.evaluate(transaction)));
                }
                return MapperS.of((Object)LegV2.builder().setPeriodicPayment(PeriodicPayment.builder().setFixedRateDayCountConvention(this.dayCountConventionRule.evaluate(this.fixedInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())))).setFloatingRateDayCountConvention(this.dayCountConventionRule.evaluate(this.floatingInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())))).setFixedRatePaymentFrequencyPeriod(this.paymentFrequencyPeriodRule.evaluate(this.fixedInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())))).setFloatingRatePaymentFrequencyPeriod(this.paymentFrequencyPeriodRule.evaluate(this.floatingInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())))).setFixedRatePaymentFrequencyPeriodMultiplier(bigDecimal0 == null ? null : Integer.valueOf(bigDecimal0.intValueExact())).setFloatingRatePaymentFrequencyPeriodMultiplier(bigDecimal1 == null ? null : Integer.valueOf(bigDecimal1.intValueExact())).build()).setFixedRate(this.fixedRateRule.evaluate(this.fixedInterestRatePayoutFromPayout.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())))).setNotionalAmount(this.notionalAmountLeg1.evaluate(transaction, defaultValue)).setNotionalCurrency(this.notionalCurrencyLeg1Rule.evaluate((TransactionReportInstructionBase)item.get())).setTotalNotionalQuantity(this.totalNotionalQuantityLeg1.evaluate(transaction, defaultValue)).setNotionalAmountSchedule(new ArrayList<NotionalPeriod>(this.notionalAmountScheduleRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())))).setNotionalQuantitySchedule(new ArrayList<NotionalPeriod>(this.notionalQuantityScheduleRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())))).setSettlementCurrency(this.settlementCurrencyRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get()))).setSpread((PriceFormat)item.mapSingleToItem(_item -> MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.spreadValueRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)_item.get())), spreadNotation))).get()).setSpreadNotation(spreadNotation).setSpreadCurrency(this.spreadCurrencyRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get()))).setQuantityUnitOfMeasure(this.quantityUnitOfMeasureRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get()))).setDirection2(ifThenElseResult).build());
            }).get());
            return Optional.ofNullable(leg).map(o -> o.prune()).orElse(null);
        }
    }
}

