/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version2.price.reports.PriceNotationRule;
import drr.standards.iosco.cde.version2.price.reports.PriceValueRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PriceFormatRuleDefault.class)
public abstract class PriceFormatRule
implements ReportFunction<TransactionReportInstructionBase, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected PriceValueRule priceValueRule;

    public PriceFormat evaluate(TransactionReportInstructionBase input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstructionBase var1);

    public static class PriceFormatRuleDefault
    extends PriceFormatRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstructionBase input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstructionBase input) {
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder(this.priceFormatFromNotation.evaluate(this.priceValueRule.evaluate(input), this.priceNotationRule.evaluate(input)));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

