/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.price.functions.CurrencyFromPrice;
import drr.standards.iosco.cde.version2.price.reports.SpreadRule;
import javax.inject.Inject;

@ImplementedBy(value=SpreadCurrencyRuleDefault.class)
public abstract class SpreadCurrencyRule
implements ReportFunction<PayoutLegWithAuxiliary, ISOCurrencyCodeEnum> {
    @Inject
    protected CurrencyFromPrice currencyFromPrice;
    @Inject
    protected SpreadRule spreadRule;

    public ISOCurrencyCodeEnum evaluate(PayoutLegWithAuxiliary input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(PayoutLegWithAuxiliary var1);

    public static class SpreadCurrencyRuleDefault
    extends SpreadCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(PayoutLegWithAuxiliary input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, PayoutLegWithAuxiliary input) {
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.currencyFromPrice.evaluate(this.spreadRule.evaluate((PayoutLegWithAuxiliary)item.get())))).get();
            return output;
        }
    }
}

