/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.quantity.functions;

import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.ReportableInformationBase;
import drr.base.trade.quantity.functions.GetProductForQuantity;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.functions.PayoutFromProductLeg2;
import drr.standards.iosco.cde.version2.quantity.functions.NotionalAmountFormat;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=NotionalAmountLeg2Default.class)
public abstract class NotionalAmountLeg2
implements RosettaFunction {
    @Inject
    protected GetProductForQuantity getProductForQuantity;
    @Inject
    protected NotionalAmountFormat notionalAmountFormat;
    @Inject
    protected PayoutFromProductLeg2 payoutFromProductLeg2;

    public BigDecimal evaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
        BigDecimal notionalAmountLeg2 = this.doEvaluate(transactionReportInstruction, defaultValue);
        return notionalAmountLeg2;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1, BigDecimal var2);

    protected abstract MapperS<? extends PayoutLegWithAuxiliary> payout(TransactionReportInstruction var1, BigDecimal var2);

    public static class NotionalAmountLeg2Default
    extends NotionalAmountLeg2 {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
            BigDecimal notionalAmountLeg2 = null;
            return this.assignOutput(notionalAmountLeg2, transactionReportInstruction, defaultValue);
        }

        protected BigDecimal assignOutput(BigDecimal notionalAmountLeg2, TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
            notionalAmountLeg2 = this.notionalAmountFormat.evaluate((PayoutLegWithAuxiliary)this.payout(transactionReportInstruction, defaultValue).get(), defaultValue);
            return notionalAmountLeg2;
        }

        @Override
        protected MapperS<? extends PayoutLegWithAuxiliary> payout(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
            MapperS thenArg = MapperS.of((Object)this.getProductForQuantity.evaluate(transactionReportInstruction));
            return thenArg.mapSingleToItem(item -> MapperS.of((Object)this.payoutFromProductLeg2.evaluate((Product)item.map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), (TradeLot)item.mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), (ReportableInformationBase)MapperS.of((Object)transactionReportInstruction).map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).get())));
        }
    }
}

