/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.hashing;

import com.regnosys.rosetta.common.hashing.IntegerHashGenerator;
import com.regnosys.rosetta.common.hashing.IntegerReport;
import com.regnosys.rosetta.common.util.SimpleProcessor;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.TemplateFields;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import java.util.Arrays;
import java.util.Optional;

public class NonNullHashCollector
extends SimpleProcessor {
    private final IntegerHashGenerator hashcodeGenerator = new IntegerHashGenerator();
    protected final IntegerReport report = new IntegerReport(0);
    private static final RosettaPath EXTERNAL_REFERENCE_PATH_ELEMENT = RosettaPath.valueOf((String)"externalReference");

    public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, R instance, RosettaModelObject parent, AttributeMeta ... metas) {
        Result result = this.shouldIncludeInHash(instance, parent, metas);
        if (result.includeInHash) {
            this.report.accumulate();
        }
        return result.continueProcessing;
    }

    @Override
    public <T> void processBasic(RosettaPath path, Class<? extends T> rosettaType, T instance, RosettaModelObject parent, AttributeMeta ... metas) {
        if (instance != null && (!this.metaContains(metas, AttributeMeta.META) || this.isExternalKeyOrReference(path, parent, metas))) {
            int hash = (Integer)this.hashcodeGenerator.generate(instance);
            this.report.accumulate(hash);
        }
    }

    public IntegerReport report() {
        return this.report;
    }

    private boolean isExternalKeyOrReference(RosettaPath path, RosettaModelObject parent, AttributeMeta[] metas) {
        return this.metaContains(metas, AttributeMeta.EXTERNAL_KEY) || ReferenceWithMeta.class.isInstance(parent) && path.endsWith(EXTERNAL_REFERENCE_PATH_ELEMENT);
    }

    private Result shouldIncludeInHash(RosettaModelObject instance, RosettaModelObject parent, AttributeMeta[] metas) {
        if (instance == null || !instance.toBuilder().hasData()) {
            return new Result(false, false);
        }
        if (this.isGlobalKeyFields(instance)) {
            return new Result(false, true);
        }
        if (this.isTemplateFields(instance)) {
            return new Result(false, false);
        }
        if (this.isReferenceWithMeta(instance)) {
            return new Result(false, true);
        }
        if (this.isReferenceWithMetaContainingReference(parent)) {
            return new Result(false, false);
        }
        if (this.metaContains(metas, AttributeMeta.GLOBAL_KEY) || this.metaContains(metas, AttributeMeta.GLOBAL_KEY_FIELD)) {
            return new Result(false, false);
        }
        return new Result(true, true);
    }

    private boolean isReferenceWithMetaContainingReference(RosettaModelObject instance) {
        if (this.isReferenceWithMeta(instance)) {
            ReferenceWithMeta refBuilder = (ReferenceWithMeta)instance;
            return Optional.ofNullable(refBuilder.getReference()).isPresent();
        }
        return false;
    }

    private boolean isReferenceWithMeta(RosettaModelObject instance) {
        return instance instanceof ReferenceWithMeta && ((ReferenceWithMeta)instance).getReference() != null;
    }

    private boolean isGlobalKeyFields(RosettaModelObject instance) {
        return instance instanceof GlobalKeyFields;
    }

    private boolean isTemplateFields(RosettaModelObject instance) {
        return instance instanceof TemplateFields;
    }

    private boolean metaContains(AttributeMeta[] metas, AttributeMeta attributeMeta) {
        return Arrays.stream(metas).anyMatch(m -> m == attributeMeta);
    }

    private static class Result {
        private final boolean includeInHash;
        private final boolean continueProcessing;

        public Result(boolean includeInHash, boolean continueProcessing) {
            this.includeInHash = includeInHash;
            this.continueProcessing = continueProcessing;
        }

        public String toString() {
            return "Result{includeInHash=" + this.includeInHash + ", continueProcessing=" + this.continueProcessing + '}';
        }
    }
}

