/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.util;

import com.google.common.collect.ImmutableList;
import com.regnosys.rosetta.common.util.UrlUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathUtils.class);

    public static List<Path> findPathsFromClassPath(Collection<String> classPathDirectories, String includeRegex, Optional<String> excludeRegex, ClassLoader classLoader) {
        List<Path> modelPaths = classPathDirectories.stream().flatMap(path -> ClassPathUtils.loadFromClasspath(path, classLoader)).collect(Collectors.toList());
        List<Path> expandedModelPaths = ClassPathUtils.expandPaths(modelPaths, includeRegex, excludeRegex);
        LOGGER.trace("Using paths: {}", expandedModelPaths);
        expandedModelPaths.forEach(x -> LOGGER.trace("   {}", x));
        return expandedModelPaths;
    }

    public static List<Path> findRosettaFilePaths() {
        return ClassPathUtils.findPathsFromClassPath((Collection<String>)ImmutableList.of((Object)"model", (Object)"cdm/rosetta"), ".*\\.rosetta", Optional.empty(), ClassPathUtils.class.getClassLoader());
    }

    public static List<Path> findStaticRosettaFilePaths() {
        return ClassPathUtils.findPathsFromClassPath((Collection<String>)ImmutableList.of((Object)"model"), ".*\\.rosetta", Optional.empty(), ClassPathUtils.class.getClassLoader());
    }

    public static List<Path> expandPaths(Collection<Path> paths, String includeRegex, Optional<String> excludeRegex) {
        return paths.stream().flatMap(ClassPathUtils::listFiles).filter(p -> p.getFileName().toString().matches(includeRegex)).filter(p -> !excludeRegex.isPresent() || !p.getFileName().toString().matches((String)excludeRegex.get())).collect(Collectors.toList());
    }

    public static URL getResource(Path path) {
        return ClassPathUtils.getResource(path, ClassPathUtils.class.getClassLoader());
    }

    public static URL getResource(Path path, ClassLoader classLoader) {
        return classLoader.getResource(UrlUtils.toPortableString(path));
    }

    public static Stream<Path> loadFromClasspath(String path) {
        return ClassPathUtils.loadFromClasspath(path, ClassPathUtils.class.getClassLoader());
    }

    public static Stream<Path> loadFromClasspath(String path, ClassLoader classLoader) {
        ArrayList<Path> paths = new ArrayList<Path>();
        try {
            for (URL resource : Collections.list(classLoader.getResources(path))) {
                if (resource.toURI().getScheme().equals("jar")) {
                    try {
                        FileSystems.getFileSystem(resource.toURI());
                    }
                    catch (FileSystemNotFoundException e) {
                        FileSystems.newFileSystem(resource.toURI(), Collections.emptyMap());
                    }
                }
                paths.add(UrlUtils.toPath(resource));
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return paths.stream();
    }

    public static Path loadSingleFromClasspath(String path) {
        return ClassPathUtils.loadSingleFromClasspath(path, ClassPathUtils.class.getClassLoader());
    }

    public static Path loadSingleFromClasspath(String path, ClassLoader classLoader) {
        try {
            URL resource = classLoader.getResource(path);
            if (resource.toURI().getScheme().equals("jar")) {
                try {
                    FileSystems.getFileSystem(resource.toURI());
                }
                catch (FileSystemNotFoundException e) {
                    FileSystems.newFileSystem(resource.toURI(), Collections.emptyMap());
                }
            }
            return UrlUtils.toPath(resource);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Path> pathsExist(List<Path> modelPaths) {
        List nonExistentPaths = modelPaths.stream().filter(p -> !Files.exists(p, new LinkOption[0])).collect(Collectors.toList());
        if (!nonExistentPaths.isEmpty()) {
            throw new IllegalArgumentException("Paths " + nonExistentPaths + " do not exist.");
        }
        return modelPaths;
    }

    private static Stream<Path> listFiles(Path path) {
        try {
            return Files.walk(path, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

