/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.daycount.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import javax.inject.Inject;

public class DayCountBasis
implements RosettaFunction {
    @Inject
    protected DayCountBasisACT_360 dayCountBasisACT_360;
    @Inject
    protected DayCountBasis_30_360 dayCountBasis_30_360;
    @Inject
    protected DayCountBasis_30E_360 dayCountBasis_30E_360;
    @Inject
    protected DayCountBasisACT_365L dayCountBasisACT_365L;
    @Inject
    protected DayCountBasisACT_365_FIXED dayCountBasisACT_365_FIXED;
    @Inject
    protected DayCountBasisACT_ACT_AFB dayCountBasisACT_ACT_AFB;
    @Inject
    protected DayCountBasisACT_ACT_ISDA dayCountBasisACT_ACT_ISDA;
    @Inject
    protected DayCountBasisACT_ACT_ICMA dayCountBasisACT_ACT_ICMA;
    @Inject
    protected DayCountBasisCAL_252 dayCountBasisCAL_252;

    public Integer evaluate(DayCountFractionEnum dcf) {
        switch (dcf) {
            case ACT_360: {
                return this.dayCountBasisACT_360.evaluate(dcf);
            }
            case _30_360: {
                return this.dayCountBasis_30_360.evaluate(dcf);
            }
            case _30E_360: {
                return this.dayCountBasis_30E_360.evaluate(dcf);
            }
            case ACT_365L: {
                return this.dayCountBasisACT_365L.evaluate(dcf);
            }
            case ACT_365_FIXED: {
                return this.dayCountBasisACT_365_FIXED.evaluate(dcf);
            }
            case ACT_ACT_AFB: {
                return this.dayCountBasisACT_ACT_AFB.evaluate(dcf);
            }
            case ACT_ACT_ISDA: {
                return this.dayCountBasisACT_ACT_ISDA.evaluate(dcf);
            }
            case ACT_ACT_ICMA: {
                return this.dayCountBasisACT_ACT_ICMA.evaluate(dcf);
            }
            case CAL_252: {
                return this.dayCountBasisCAL_252.evaluate(dcf);
            }
        }
        throw new IllegalArgumentException("Enum value not implemented: " + (Object)((Object)dcf));
    }

    @ImplementedBy(value=DayCountBasisACT_360Default.class)
    public static abstract class DayCountBasisACT_360
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasisACT_360Default
        extends DayCountBasisACT_360 {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 360;
                return basis;
            }
        }
    }

    @ImplementedBy(value=DayCountBasis_30_360Default.class)
    public static abstract class DayCountBasis_30_360
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasis_30_360Default
        extends DayCountBasis_30_360 {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 360;
                return basis;
            }
        }
    }

    @ImplementedBy(value=DayCountBasis_30E_360Default.class)
    public static abstract class DayCountBasis_30E_360
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasis_30E_360Default
        extends DayCountBasis_30E_360 {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 360;
                return basis;
            }
        }
    }

    @ImplementedBy(value=DayCountBasisACT_365LDefault.class)
    public static abstract class DayCountBasisACT_365L
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasisACT_365LDefault
        extends DayCountBasisACT_365L {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 365;
                return basis;
            }
        }
    }

    @ImplementedBy(value=DayCountBasisACT_365_FIXEDDefault.class)
    public static abstract class DayCountBasisACT_365_FIXED
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasisACT_365_FIXEDDefault
        extends DayCountBasisACT_365_FIXED {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 365;
                return basis;
            }
        }
    }

    @ImplementedBy(value=DayCountBasisACT_ACT_AFBDefault.class)
    public static abstract class DayCountBasisACT_ACT_AFB
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasisACT_ACT_AFBDefault
        extends DayCountBasisACT_ACT_AFB {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 365;
                return basis;
            }
        }
    }

    @ImplementedBy(value=DayCountBasisACT_ACT_ISDADefault.class)
    public static abstract class DayCountBasisACT_ACT_ISDA
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasisACT_ACT_ISDADefault
        extends DayCountBasisACT_ACT_ISDA {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 365;
                return basis;
            }
        }
    }

    @ImplementedBy(value=DayCountBasisACT_ACT_ICMADefault.class)
    public static abstract class DayCountBasisACT_ACT_ICMA
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasisACT_ACT_ICMADefault
        extends DayCountBasisACT_ACT_ICMA {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 365;
                return basis;
            }
        }
    }

    @ImplementedBy(value=DayCountBasisCAL_252Default.class)
    public static abstract class DayCountBasisCAL_252
    implements RosettaFunction {
        public Integer evaluate(DayCountFractionEnum dcf) {
            Integer basis = this.doEvaluate(dcf);
            return basis;
        }

        protected abstract Integer doEvaluate(DayCountFractionEnum var1);

        public static class DayCountBasisCAL_252Default
        extends DayCountBasisCAL_252 {
            @Override
            protected Integer doEvaluate(DayCountFractionEnum dcf) {
                Integer basis = null;
                return this.assignOutput(basis, dcf);
            }

            protected Integer assignOutput(Integer basis, DayCountFractionEnum dcf) {
                basis = 252;
                return basis;
            }
        }
    }
}

