/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.Transfer;
import cdm.event.common.meta.IndexTransitionInstructionMeta;
import cdm.product.common.settlement.PriceQuantity;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="IndexTransitionInstruction", builder=IndexTransitionInstructionBuilderImpl.class, version="5.29.0")
@RuneDataType(value="IndexTransitionInstruction", model="cdm", builder=IndexTransitionInstructionBuilderImpl.class, version="5.29.0")
public interface IndexTransitionInstruction
extends RosettaModelObject {
    public static final IndexTransitionInstructionMeta metaData = new IndexTransitionInstructionMeta();

    public List<? extends PriceQuantity> getPriceQuantity();

    public Date getEffectiveDate();

    public Transfer getCashTransfer();

    public IndexTransitionInstruction build();

    public IndexTransitionInstructionBuilder toBuilder();

    public static IndexTransitionInstructionBuilder builder() {
        return new IndexTransitionInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends IndexTransitionInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends IndexTransitionInstruction> getType() {
        return IndexTransitionInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashTransfer"), processor, Transfer.class, this.getCashTransfer(), new AttributeMeta[0]);
    }

    public static class IndexTransitionInstructionBuilderImpl
    implements IndexTransitionInstructionBuilder {
        protected List<PriceQuantity.PriceQuantityBuilder> priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
        protected Date effectiveDate;
        protected Transfer.TransferBuilder cashTransfer;

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int index) {
            if (this.priceQuantity == null) {
                this.priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            }
            return (PriceQuantity.PriceQuantityBuilder)this.getIndex(this.priceQuantity, index, () -> {
                PriceQuantity.PriceQuantityBuilder newPriceQuantity = PriceQuantity.builder();
                return newPriceQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="cashTransfer")
        @RuneAttribute(value="cashTransfer")
        public Transfer.TransferBuilder getCashTransfer() {
            return this.cashTransfer;
        }

        @Override
        public Transfer.TransferBuilder getOrCreateCashTransfer() {
            Transfer.TransferBuilder result = this.cashTransfer != null ? this.cashTransfer : (this.cashTransfer = Transfer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public IndexTransitionInstructionBuilder addPriceQuantity(PriceQuantity _priceQuantity) {
            if (_priceQuantity != null) {
                this.priceQuantity.add(_priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder addPriceQuantity(PriceQuantity _priceQuantity, int idx) {
            this.getIndex(this.priceQuantity, idx, () -> _priceQuantity.toBuilder());
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceQuantity")
        public IndexTransitionInstructionBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList<PriceQuantity.PriceQuantityBuilder>() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public IndexTransitionInstructionBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashTransfer")
        @RuneAttribute(value="cashTransfer")
        public IndexTransitionInstructionBuilder setCashTransfer(Transfer _cashTransfer) {
            this.cashTransfer = _cashTransfer == null ? null : _cashTransfer.toBuilder();
            return this;
        }

        @Override
        public IndexTransitionInstruction build() {
            return new IndexTransitionInstructionImpl(this);
        }

        @Override
        public IndexTransitionInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder prune() {
            this.priceQuantity = this.priceQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.cashTransfer != null && !this.cashTransfer.prune().hasData()) {
                this.cashTransfer = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPriceQuantity() != null && this.getPriceQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            return this.getCashTransfer() != null && this.getCashTransfer().hasData();
        }

        public IndexTransitionInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IndexTransitionInstructionBuilder o = (IndexTransitionInstructionBuilder)other;
            merger.mergeRosetta(this.getPriceQuantity(), o.getPriceQuantity(), this::getOrCreatePriceQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashTransfer(), (RosettaModelObjectBuilder)o.getCashTransfer(), this::setCashTransfer);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IndexTransitionInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.cashTransfer, _that.getCashTransfer());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.cashTransfer != null ? this.cashTransfer.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IndexTransitionInstructionBuilder {priceQuantity=" + this.priceQuantity + ", effectiveDate=" + this.effectiveDate + ", cashTransfer=" + this.cashTransfer + '}';
        }
    }

    public static interface IndexTransitionInstructionBuilder
    extends IndexTransitionInstruction,
    RosettaModelObjectBuilder {
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int var1);

        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity();

        public Transfer.TransferBuilder getOrCreateCashTransfer();

        @Override
        public Transfer.TransferBuilder getCashTransfer();

        public IndexTransitionInstructionBuilder addPriceQuantity(PriceQuantity var1);

        public IndexTransitionInstructionBuilder addPriceQuantity(PriceQuantity var1, int var2);

        public IndexTransitionInstructionBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        public IndexTransitionInstructionBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        public IndexTransitionInstructionBuilder setEffectiveDate(Date var1);

        public IndexTransitionInstructionBuilder setCashTransfer(Transfer var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashTransfer"), processor, Transfer.TransferBuilder.class, this.getCashTransfer(), new AttributeMeta[0]);
        }

        public IndexTransitionInstructionBuilder prune();
    }

    public static class IndexTransitionInstructionImpl
    implements IndexTransitionInstruction {
        private final List<? extends PriceQuantity> priceQuantity;
        private final Date effectiveDate;
        private final Transfer cashTransfer;

        protected IndexTransitionInstructionImpl(IndexTransitionInstructionBuilder builder) {
            this.priceQuantity = Optional.ofNullable(builder.getPriceQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.effectiveDate = builder.getEffectiveDate();
            this.cashTransfer = Optional.ofNullable(builder.getCashTransfer()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="cashTransfer")
        @RuneAttribute(value="cashTransfer")
        public Transfer getCashTransfer() {
            return this.cashTransfer;
        }

        @Override
        public IndexTransitionInstruction build() {
            return this;
        }

        @Override
        public IndexTransitionInstructionBuilder toBuilder() {
            IndexTransitionInstructionBuilder builder = IndexTransitionInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IndexTransitionInstructionBuilder builder) {
            Optional.ofNullable(this.getPriceQuantity()).ifPresent(builder::setPriceQuantity);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getCashTransfer()).ifPresent(builder::setCashTransfer);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            IndexTransitionInstruction _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.cashTransfer, _that.getCashTransfer());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.cashTransfer != null ? this.cashTransfer.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IndexTransitionInstruction {priceQuantity=" + this.priceQuantity + ", effectiveDate=" + this.effectiveDate + ", cashTransfer=" + this.cashTransfer + '}';
        }
    }
}

