/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.legaldocumentation.master.EquitySwapMasterConfirmation2018;
import cdm.observable.asset.ValuationDates;
import cdm.product.asset.ReturnTypeEnum;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=NewSingleNameEquityPerformancePayoutDefault.class)
public abstract class NewSingleNameEquityPerformancePayout
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;

    public PerformancePayout evaluate(Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
        PerformancePayout performancePayout;
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)security).map("getSecurityType", _security -> _security.getSecurityType()), (Mapper)MapperS.of((Object)((Object)SecurityTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All), "Security must be equity (single name).");
        PerformancePayout.PerformancePayoutBuilder performancePayoutBuilder = this.doEvaluate(security, masterConfirmation);
        if (performancePayoutBuilder == null) {
            performancePayout = null;
        } else {
            performancePayout = performancePayoutBuilder.build();
            this.objectValidator.validate(PerformancePayout.class, (RosettaModelObject)performancePayout);
        }
        return performancePayout;
    }

    protected abstract PerformancePayout.PerformancePayoutBuilder doEvaluate(Security var1, EquitySwapMasterConfirmation2018 var2);

    public static class NewSingleNameEquityPerformancePayoutDefault
    extends NewSingleNameEquityPerformancePayout {
        @Override
        protected PerformancePayout.PerformancePayoutBuilder doEvaluate(Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
            PerformancePayout.PerformancePayoutBuilder performancePayout = PerformancePayout.builder();
            return this.assignOutput(performancePayout, security, masterConfirmation);
        }

        protected PerformancePayout.PerformancePayoutBuilder assignOutput(PerformancePayout.PerformancePayoutBuilder performancePayout, Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
            performancePayout.getOrCreateReturnTerms().getOrCreatePriceReturnTerms().setReturnType((ReturnTypeEnum)((Object)MapperS.of((Object)masterConfirmation).map("getTypeOfSwapElection", equitySwapMasterConfirmation2018 -> equitySwapMasterConfirmation2018.getTypeOfSwapElection()).get()));
            performancePayout.setValuationDates((ValuationDates)MapperS.of((Object)masterConfirmation).map("getValuationDates", equitySwapMasterConfirmation2018 -> equitySwapMasterConfirmation2018.getValuationDates()).get());
            performancePayout.setPaymentDates((PaymentDates)MapperS.of((Object)masterConfirmation).map("getEquityCashSettlementDates", equitySwapMasterConfirmation2018 -> equitySwapMasterConfirmation2018.getEquityCashSettlementDates()).get());
            performancePayout.setSettlementTerms((SettlementTerms)MapperS.of((Object)masterConfirmation).map("getSettlementTerms", equitySwapMasterConfirmation2018 -> equitySwapMasterConfirmation2018.getSettlementTerms()).get());
            return Optional.ofNullable(performancePayout).map(o -> o.prune()).orElse(null);
        }
    }
}

