/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Trade;
import cdm.event.common.functions.EmptyExecutionDetails;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=TradeNoExecutionDetailsDefault.class)
public abstract class TradeNoExecutionDetails
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EmptyExecutionDetails emptyExecutionDetails;

    public Trade evaluate(Trade trade) {
        Trade newTrade;
        Trade.TradeBuilder newTradeBuilder = this.doEvaluate(trade);
        if (newTradeBuilder == null) {
            newTrade = null;
        } else {
            newTrade = newTradeBuilder.build();
            this.objectValidator.validate(Trade.class, (RosettaModelObject)newTrade);
        }
        return newTrade;
    }

    protected abstract Trade.TradeBuilder doEvaluate(Trade var1);

    public static class TradeNoExecutionDetailsDefault
    extends TradeNoExecutionDetails {
        @Override
        protected Trade.TradeBuilder doEvaluate(Trade trade) {
            Trade.TradeBuilder newTrade = Trade.builder();
            return this.assignOutput(newTrade, trade);
        }

        protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder newTrade, Trade trade) {
            newTrade = (Trade.TradeBuilder)this.toBuilder(trade, () -> Trade.builder());
            newTrade.setExecutionDetails(this.emptyExecutionDetails.evaluate());
            return Optional.ofNullable(newTrade).map(o -> o.prune()).orElse(null);
        }
    }
}

