/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position;

import cdm.event.common.TradeState;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.event.position.meta.PositionMeta;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.Product;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Position", builder=PositionBuilderImpl.class, version="5.29.0")
@RuneDataType(value="Position", model="cdm", builder=PositionBuilderImpl.class, version="5.29.0")
public interface Position
extends RosettaModelObject {
    public static final PositionMeta metaData = new PositionMeta();

    public List<? extends PriceQuantity> getPriceQuantity();

    public Product getProduct();

    public Money getCashBalance();

    public ReferenceWithMetaTradeState getTradeReference();

    public Position build();

    public PositionBuilder toBuilder();

    public static PositionBuilder builder() {
        return new PositionBuilderImpl();
    }

    default public RosettaMetaData<? extends Position> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Position> getType() {
        return Position.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashBalance"), processor, Money.class, this.getCashBalance(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.class, this.getTradeReference(), new AttributeMeta[0]);
    }

    public static class PositionBuilderImpl
    implements PositionBuilder {
        protected List<PriceQuantity.PriceQuantityBuilder> priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
        protected Product.ProductBuilder product;
        protected Money.MoneyBuilder cashBalance;
        protected ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder tradeReference;

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int index) {
            if (this.priceQuantity == null) {
                this.priceQuantity = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            }
            return (PriceQuantity.PriceQuantityBuilder)this.getIndex(this.priceQuantity, index, () -> {
                PriceQuantity.PriceQuantityBuilder newPriceQuantity = PriceQuantity.builder();
                return newPriceQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public Product.ProductBuilder getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct() {
            Product.ProductBuilder result = this.product != null ? this.product : (this.product = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashBalance")
        @RuneAttribute(value="cashBalance")
        public Money.MoneyBuilder getCashBalance() {
            return this.cashBalance;
        }

        @Override
        public Money.MoneyBuilder getOrCreateCashBalance() {
            Money.MoneyBuilder result = this.cashBalance != null ? this.cashBalance : (this.cashBalance = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeReference() {
            ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder result = this.tradeReference != null ? this.tradeReference : (this.tradeReference = ReferenceWithMetaTradeState.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public PositionBuilder addPriceQuantity(PriceQuantity _priceQuantity) {
            if (_priceQuantity != null) {
                this.priceQuantity.add(_priceQuantity.toBuilder());
            }
            return this;
        }

        @Override
        public PositionBuilder addPriceQuantity(PriceQuantity _priceQuantity, int idx) {
            this.getIndex(this.priceQuantity, idx, () -> _priceQuantity.toBuilder());
            return this;
        }

        @Override
        public PositionBuilder addPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            if (priceQuantitys != null) {
                for (PriceQuantity priceQuantity : priceQuantitys) {
                    this.priceQuantity.add(priceQuantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceQuantity")
        public PositionBuilder setPriceQuantity(List<? extends PriceQuantity> priceQuantitys) {
            this.priceQuantity = priceQuantitys == null ? new ArrayList<PriceQuantity.PriceQuantityBuilder>() : (List)priceQuantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public PositionBuilder setProduct(Product _product) {
            this.product = _product == null ? null : _product.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashBalance")
        @RuneAttribute(value="cashBalance")
        public PositionBuilder setCashBalance(Money _cashBalance) {
            this.cashBalance = _cashBalance == null ? null : _cashBalance.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public PositionBuilder setTradeReference(ReferenceWithMetaTradeState _tradeReference) {
            this.tradeReference = _tradeReference == null ? null : _tradeReference.toBuilder();
            return this;
        }

        @Override
        public PositionBuilder setTradeReferenceValue(TradeState _tradeReference) {
            this.getOrCreateTradeReference().setValue(_tradeReference);
            return this;
        }

        @Override
        public Position build() {
            return new PositionImpl(this);
        }

        @Override
        public PositionBuilder toBuilder() {
            return this;
        }

        @Override
        public PositionBuilder prune() {
            this.priceQuantity = this.priceQuantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.product != null && !this.product.prune().hasData()) {
                this.product = null;
            }
            if (this.cashBalance != null && !this.cashBalance.prune().hasData()) {
                this.cashBalance = null;
            }
            if (this.tradeReference != null && !this.tradeReference.prune().hasData()) {
                this.tradeReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPriceQuantity() != null && this.getPriceQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProduct() != null && this.getProduct().hasData()) {
                return true;
            }
            if (this.getCashBalance() != null && this.getCashBalance().hasData()) {
                return true;
            }
            return this.getTradeReference() != null && this.getTradeReference().hasData();
        }

        public PositionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PositionBuilder o = (PositionBuilder)other;
            merger.mergeRosetta(this.getPriceQuantity(), o.getPriceQuantity(), this::getOrCreatePriceQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProduct(), (RosettaModelObjectBuilder)o.getProduct(), this::setProduct);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashBalance(), (RosettaModelObjectBuilder)o.getCashBalance(), this::setCashBalance);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeReference(), (RosettaModelObjectBuilder)o.getTradeReference(), this::setTradeReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Position _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!Objects.equals(this.cashBalance, _that.getCashBalance())) {
                return false;
            }
            return Objects.equals(this.tradeReference, _that.getTradeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.cashBalance != null ? this.cashBalance.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PositionBuilder {priceQuantity=" + this.priceQuantity + ", product=" + this.product + ", cashBalance=" + this.cashBalance + ", tradeReference=" + this.tradeReference + '}';
        }
    }

    public static interface PositionBuilder
    extends Position,
    RosettaModelObjectBuilder {
        public PriceQuantity.PriceQuantityBuilder getOrCreatePriceQuantity(int var1);

        public List<? extends PriceQuantity.PriceQuantityBuilder> getPriceQuantity();

        public Product.ProductBuilder getOrCreateProduct();

        @Override
        public Product.ProductBuilder getProduct();

        public Money.MoneyBuilder getOrCreateCashBalance();

        @Override
        public Money.MoneyBuilder getCashBalance();

        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeReference();

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeReference();

        public PositionBuilder addPriceQuantity(PriceQuantity var1);

        public PositionBuilder addPriceQuantity(PriceQuantity var1, int var2);

        public PositionBuilder addPriceQuantity(List<? extends PriceQuantity> var1);

        public PositionBuilder setPriceQuantity(List<? extends PriceQuantity> var1);

        public PositionBuilder setProduct(Product var1);

        public PositionBuilder setCashBalance(Money var1);

        public PositionBuilder setTradeReference(ReferenceWithMetaTradeState var1);

        public PositionBuilder setTradeReferenceValue(TradeState var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("priceQuantity"), processor, PriceQuantity.PriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashBalance"), processor, Money.MoneyBuilder.class, this.getCashBalance(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder.class, this.getTradeReference(), new AttributeMeta[0]);
        }

        public PositionBuilder prune();
    }

    public static class PositionImpl
    implements Position {
        private final List<? extends PriceQuantity> priceQuantity;
        private final Product product;
        private final Money cashBalance;
        private final ReferenceWithMetaTradeState tradeReference;

        protected PositionImpl(PositionBuilder builder) {
            this.priceQuantity = Optional.ofNullable(builder.getPriceQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.product = Optional.ofNullable(builder.getProduct()).map(f -> f.build()).orElse(null);
            this.cashBalance = Optional.ofNullable(builder.getCashBalance()).map(f -> f.build()).orElse(null);
            this.tradeReference = Optional.ofNullable(builder.getTradeReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="priceQuantity", isRequired=true)
        @RuneAttribute(value="priceQuantity", isRequired=true)
        public List<? extends PriceQuantity> getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        @RosettaAttribute(value="product", isRequired=true)
        @RuneAttribute(value="product", isRequired=true)
        public Product getProduct() {
            return this.product;
        }

        @Override
        @RosettaAttribute(value="cashBalance")
        @RuneAttribute(value="cashBalance")
        public Money getCashBalance() {
            return this.cashBalance;
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public ReferenceWithMetaTradeState getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public Position build() {
            return this;
        }

        @Override
        public PositionBuilder toBuilder() {
            PositionBuilder builder = Position.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PositionBuilder builder) {
            Optional.ofNullable(this.getPriceQuantity()).ifPresent(builder::setPriceQuantity);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getCashBalance()).ifPresent(builder::setCashBalance);
            Optional.ofNullable(this.getTradeReference()).ifPresent(builder::setTradeReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Position _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            if (!Objects.equals(this.cashBalance, _that.getCashBalance())) {
                return false;
            }
            return Objects.equals(this.tradeReference, _that.getTradeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.cashBalance != null ? this.cashBalance.hashCode() : 0);
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Position {priceQuantity=" + this.priceQuantity + ", product=" + this.product + ", cashBalance=" + this.cashBalance + ", tradeReference=" + this.tradeReference + '}';
        }
    }
}

