/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.functions.AddBusinessDays;
import cdm.base.datetime.functions.GetAllBusinessCenters;
import cdm.observable.asset.calculatedrate.ObservationPeriodDatesEnum;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.ResetDates;
import cdm.product.common.schedule.ResetRelativeToEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Optional;
import javax.inject.Inject;

public class ComputeCalculationPeriod
implements RosettaFunction {
    @Inject
    protected ComputeCalculationPeriodSET_IN_ADVANCE computeCalculationPeriodSetInAdvance;
    @Inject
    protected ComputeCalculationPeriodSTANDARD computeCalculationPeriodStandard;
    @Inject
    protected ComputeCalculationPeriodFIXING_DATE computeCalculationPeriodFixingDate;

    public CalculationPeriodBase evaluate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
        switch (calculateRelativeTo) {
            case SET_IN_ADVANCE: {
                return this.computeCalculationPeriodSetInAdvance.evaluate(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            }
            case STANDARD: {
                return this.computeCalculationPeriodStandard.evaluate(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            }
            case FIXING_DATE: {
                return this.computeCalculationPeriodFixingDate.evaluate(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            }
        }
        throw new IllegalArgumentException("Enum value not implemented: " + (Object)((Object)calculateRelativeTo));
    }

    @ImplementedBy(value=ComputeCalculationPeriodSET_IN_ADVANCEDefault.class)
    public static abstract class ComputeCalculationPeriodSET_IN_ADVANCE
    implements RosettaFunction {
        @Inject
        protected ModelObjectValidator objectValidator;

        public CalculationPeriodBase evaluate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
            CalculationPeriodBase result;
            CalculationPeriodBase.CalculationPeriodBaseBuilder resultBuilder = this.doEvaluate(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            if (resultBuilder == null) {
                result = null;
            } else {
                result = resultBuilder.build();
                this.objectValidator.validate(CalculationPeriodBase.class, (RosettaModelObject)result);
            }
            return result;
        }

        protected abstract CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        public static class ComputeCalculationPeriodSET_IN_ADVANCEDefault
        extends ComputeCalculationPeriodSET_IN_ADVANCE {
            @Override
            protected CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                CalculationPeriodBase.CalculationPeriodBaseBuilder result = CalculationPeriodBase.builder();
                return this.assignOutput(result, calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            }

            protected CalculationPeriodBase.CalculationPeriodBaseBuilder assignOutput(CalculationPeriodBase.CalculationPeriodBaseBuilder result, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                result = (CalculationPeriodBase.CalculationPeriodBaseBuilder)this.toBuilder(priorCalculationPeriod);
                return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
            }
        }
    }

    @ImplementedBy(value=ComputeCalculationPeriodSTANDARDDefault.class)
    public static abstract class ComputeCalculationPeriodSTANDARD
    implements RosettaFunction {
        @Inject
        protected ModelObjectValidator objectValidator;

        public CalculationPeriodBase evaluate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
            CalculationPeriodBase result;
            CalculationPeriodBase.CalculationPeriodBaseBuilder resultBuilder = this.doEvaluate(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            if (resultBuilder == null) {
                result = null;
            } else {
                result = resultBuilder.build();
                this.objectValidator.validate(CalculationPeriodBase.class, (RosettaModelObject)result);
            }
            return result;
        }

        protected abstract CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        public static class ComputeCalculationPeriodSTANDARDDefault
        extends ComputeCalculationPeriodSTANDARD {
            @Override
            protected CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                CalculationPeriodBase.CalculationPeriodBaseBuilder result = CalculationPeriodBase.builder();
                return this.assignOutput(result, calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            }

            protected CalculationPeriodBase.CalculationPeriodBaseBuilder assignOutput(CalculationPeriodBase.CalculationPeriodBaseBuilder result, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                result = (CalculationPeriodBase.CalculationPeriodBaseBuilder)this.toBuilder(calculationPeriod);
                return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
            }
        }
    }

    @ImplementedBy(value=ComputeCalculationPeriodFIXING_DATEDefault.class)
    public static abstract class ComputeCalculationPeriodFIXING_DATE
    implements RosettaFunction {
        @Inject
        protected ModelObjectValidator objectValidator;
        @Inject
        protected AddBusinessDays addBusinessDays;
        @Inject
        protected GetAllBusinessCenters getAllBusinessCenters;

        public CalculationPeriodBase evaluate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
            CalculationPeriodBase result;
            CalculationPeriodBase.CalculationPeriodBaseBuilder resultBuilder = this.doEvaluate(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            if (resultBuilder == null) {
                result = null;
            } else {
                result = resultBuilder.build();
                this.objectValidator.validate(CalculationPeriodBase.class, (RosettaModelObject)result);
            }
            return result;
        }

        protected abstract CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        protected abstract MapperS<ResetRelativeToEnum> resetRelativeTo(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        protected abstract MapperS<Boolean> isStart(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        protected abstract MapperS<? extends CalculationPeriodBase> calcPd(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        protected abstract MapperS<Integer> fixingOffsetDays(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        protected abstract MapperC<BusinessCenterEnum> businessCenters(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        protected abstract MapperS<Date> endDate(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        protected abstract MapperS<Date> startDate(CalculationPeriodBase var1, CalculationPeriodBase var2, ObservationPeriodDatesEnum var3, ResetDates var4);

        public static class ComputeCalculationPeriodFIXING_DATEDefault
        extends ComputeCalculationPeriodFIXING_DATE {
            @Override
            protected CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                CalculationPeriodBase.CalculationPeriodBaseBuilder result = CalculationPeriodBase.builder();
                return this.assignOutput(result, calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates);
            }

            protected CalculationPeriodBase.CalculationPeriodBaseBuilder assignOutput(CalculationPeriodBase.CalculationPeriodBaseBuilder result, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                result.setAdjustedEndDate((Date)this.endDate(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).get());
                result.setAdjustedStartDate((Date)this.startDate(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).get());
                return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
            }

            @Override
            protected MapperS<ResetRelativeToEnum> resetRelativeTo(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                return MapperS.of((Object)resetDates).map("getResetRelativeTo", _resetDates -> _resetDates.getResetRelativeTo());
            }

            @Override
            protected MapperS<Boolean> isStart(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                return ExpressionOperators.areEqual(this.resetRelativeTo(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates), (Mapper)MapperS.of((Object)((Object)ResetRelativeToEnum.CALCULATION_PERIOD_START_DATE)), (CardinalityOperator)CardinalityOperator.All).asMapper();
            }

            @Override
            protected MapperS<? extends CalculationPeriodBase> calcPd(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                if (((Boolean)this.isStart(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).getOrDefault((Object)false)).booleanValue()) {
                    return MapperS.of((Object)priorCalculationPeriod);
                }
                return MapperS.of((Object)calculationPeriod);
            }

            @Override
            protected MapperS<Integer> fixingOffsetDays(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                return MapperS.of((Object)resetDates).map("getFixingDates", _resetDates -> _resetDates.getFixingDates()).map("getPeriodMultiplier", relativeDateOffset -> relativeDateOffset.getPeriodMultiplier());
            }

            @Override
            protected MapperC<BusinessCenterEnum> businessCenters(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                return MapperC.of(this.getAllBusinessCenters.evaluate((BusinessCenters)MapperS.of((Object)resetDates).map("getResetDatesAdjustments", _resetDates -> _resetDates.getResetDatesAdjustments()).map("getBusinessCenters", businessDayAdjustments -> businessDayAdjustments.getBusinessCenters()).get()));
            }

            @Override
            protected MapperS<Date> endDate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                return MapperS.of((Object)this.addBusinessDays.evaluate((Date)this.calcPd(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).map("getAdjustedEndDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedEndDate()).get(), (Integer)this.fixingOffsetDays(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).get(), this.businessCenters(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).getMulti()));
            }

            @Override
            protected MapperS<Date> startDate(CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, ObservationPeriodDatesEnum calculateRelativeTo, ResetDates resetDates) {
                return MapperS.of((Object)this.addBusinessDays.evaluate((Date)this.calcPd(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).map("getAdjustedStartDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedStartDate()).get(), (Integer)this.fixingOffsetDays(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).get(), this.businessCenters(calculationPeriod, priorCalculationPeriod, calculateRelativeTo, resetDates).getMulti()));
            }
        }
    }
}

