/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.SettlementDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SettlementDateDateChoice")
@ImplementedBy(value=Default.class)
public interface SettlementDateDateChoice
extends Validator<SettlementDate> {
    public static final String NAME = "SettlementDateDateChoice";
    public static final String DEFINITION = "optional choice adjustableOrRelativeDate, valueDate, adjustableDates, businessDateRange";

    public static class NoOp
    implements SettlementDateDateChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementDate settlementDate) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SettlementDateDateChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementDate settlementDate) {
            ComparisonResult result = this.executeDataRule(settlementDate);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SettlementDateDateChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementDate", (RosettaPath)path, (String)SettlementDateDateChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SettlementDateDateChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementDate", (RosettaPath)path, (String)SettlementDateDateChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SettlementDate settlementDate) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)settlementDate), Arrays.asList("adjustableOrRelativeDate", "valueDate", "adjustableDates", "businessDateRange"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

