/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PayoutPayRelativeTo")
@ImplementedBy(value=Default.class)
public interface PayoutPayRelativeTo
extends Validator<Payout> {
    public static final String NAME = "PayoutPayRelativeTo";
    public static final String DEFINITION = "if interestRatePayout count = 2 and interestRatePayout -> paymentDates exists then interestRatePayout -> paymentDates -> payRelativeTo exists";

    public static class NoOp
    implements PayoutPayRelativeTo {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PayoutPayRelativeTo {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PayoutPayRelativeTo.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutPayRelativeTo.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PayoutPayRelativeTo.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutPayRelativeTo.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).resultCount()), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).map("getPayRelativeTo", paymentDates -> paymentDates.getPayRelativeTo()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

