/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.base.CharMatcher;
import com.google.common.math.DoubleMath;
import com.opengamma.strata.collect.Messages;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public final class ArgChecker {
    private ArgChecker() {
    }

    public static void isTrue(boolean validIfTrue) {
        if (!validIfTrue) {
            throw new IllegalArgumentException("Invalid argument, expression must be true");
        }
    }

    public static void isTrue(boolean validIfTrue, String message) {
        if (!validIfTrue) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean validIfTrue, String message, Object ... arg) {
        if (!validIfTrue) {
            throw new IllegalArgumentException(Messages.format(message, arg));
        }
    }

    public static void isTrue(boolean validIfTrue, String message, long arg) {
        if (!validIfTrue) {
            throw new IllegalArgumentException(Messages.format(message, (Object)arg));
        }
    }

    public static void isTrue(boolean validIfTrue, String message, double arg) {
        if (!validIfTrue) {
            throw new IllegalArgumentException(Messages.format(message, (Object)arg));
        }
    }

    public static void isFalse(boolean validIfFalse, String message) {
        if (validIfFalse) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isFalse(boolean validIfFalse, String message, Object ... arg) {
        if (validIfFalse) {
            throw new IllegalArgumentException(Messages.format(message, arg));
        }
    }

    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(ArgChecker.notNullMsg(name));
        }
        return argument;
    }

    private static String notNullMsg(String name) {
        return "Argument '" + name + "' must not be null";
    }

    public static <T> T notNullItem(T argument) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument array/collection/map must not contain null");
        }
        return argument;
    }

    public static String matches(Pattern pattern, String argument, String name) {
        ArgChecker.notNull(pattern, "pattern");
        ArgChecker.notNull(argument, name);
        if (!pattern.matcher(argument).matches()) {
            throw new IllegalArgumentException(ArgChecker.matchesMsg(pattern, name, argument));
        }
        return argument;
    }

    private static String matchesMsg(Pattern pattern, String name, String value) {
        return "Argument '" + name + "' with value '" + value + "' must match pattern: " + pattern;
    }

    public static String matches(CharMatcher matcher, int minLength, int maxLength, String argument, String name, String equivalentRegex) {
        ArgChecker.notNull(matcher, "pattern");
        ArgChecker.notNull(argument, name);
        if (argument.length() < minLength || argument.length() > maxLength || !matcher.matchesAllOf((CharSequence)argument)) {
            throw new IllegalArgumentException(ArgChecker.matchesMsg(matcher, name, argument, equivalentRegex));
        }
        return argument;
    }

    private static String matchesMsg(CharMatcher matcher, String name, String value, String equivalentRegex) {
        return "Argument '" + name + "' with value '" + value + "' must match pattern: " + equivalentRegex;
    }

    public static String notBlank(String argument, String name) {
        ArgChecker.notNull(argument, name);
        if (argument.trim().isEmpty()) {
            throw new IllegalArgumentException(ArgChecker.notBlankMsg(name));
        }
        return argument;
    }

    private static String notBlankMsg(String name) {
        return "Argument '" + name + "' must not be blank";
    }

    public static String notEmpty(String argument, String name) {
        ArgChecker.notNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(ArgChecker.notEmptyMsg(name));
        }
        return argument;
    }

    private static String notEmptyMsg(String name) {
        return "Argument '" + name + "' must not be empty";
    }

    public static <T> T[] notEmpty(T[] argument, String name) {
        ArgChecker.notNull(argument, name);
        if (argument.length == 0) {
            throw new IllegalArgumentException(ArgChecker.notEmptyArrayMsg(name));
        }
        return argument;
    }

    private static String notEmptyArrayMsg(String name) {
        return "Argument array '" + name + "' must not be empty";
    }

    public static int[] notEmpty(int[] argument, String name) {
        ArgChecker.notNull(argument, name);
        if (argument.length == 0) {
            throw new IllegalArgumentException(ArgChecker.notEmptyArrayMsg(name));
        }
        return argument;
    }

    public static long[] notEmpty(long[] argument, String name) {
        ArgChecker.notNull(argument, name);
        if (argument.length == 0) {
            throw new IllegalArgumentException(ArgChecker.notEmptyArrayMsg(name));
        }
        return argument;
    }

    public static double[] notEmpty(double[] argument, String name) {
        ArgChecker.notNull(argument, name);
        if (argument.length == 0) {
            throw new IllegalArgumentException(ArgChecker.notEmptyArrayMsg(name));
        }
        return argument;
    }

    public static <T, I extends Iterable<T>> I notEmpty(I argument, String name) {
        ArgChecker.notNull(argument, name);
        if (!argument.iterator().hasNext()) {
            throw new IllegalArgumentException(ArgChecker.notEmptyIterableMsg(name));
        }
        return argument;
    }

    private static String notEmptyIterableMsg(String name) {
        return "Argument iterable '" + name + "' must not be empty";
    }

    public static <T, C extends Collection<T>> C notEmpty(C argument, String name) {
        ArgChecker.notNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(ArgChecker.notEmptyCollectionMsg(name));
        }
        return argument;
    }

    private static String notEmptyCollectionMsg(String name) {
        return "Argument collection '" + name + "' must not be empty";
    }

    public static <K, V, M extends Map<K, V>> M notEmpty(M argument, String name) {
        ArgChecker.notNull(argument, name);
        if (argument.isEmpty()) {
            throw new IllegalArgumentException(ArgChecker.notEmptyMapMsg(name));
        }
        return argument;
    }

    private static String notEmptyMapMsg(String name) {
        return "Argument map '" + name + "' must not be empty";
    }

    public static <T> T[] noNulls(T[] argument, String name) {
        ArgChecker.notNull(argument, name);
        for (int i = 0; i < argument.length; ++i) {
            if (argument[i] != null) continue;
            throw new IllegalArgumentException("Argument array '" + name + "' must not contain null at index " + i);
        }
        return argument;
    }

    public static <T, I extends Iterable<T>> I noNulls(I argument, String name) {
        ArgChecker.notNull(argument, name);
        for (T obj : argument) {
            if (obj != null) continue;
            throw new IllegalArgumentException("Argument iterable '" + name + "' must not contain null");
        }
        return argument;
    }

    public static <K, V, M extends Map<K, V>> M noNulls(M argument, String name) {
        ArgChecker.notNull(argument, name);
        for (Map.Entry<K, V> entry : argument.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("Argument map '" + name + "' must not contain a null key");
            }
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("Argument map '" + name + "' must not contain a null value");
        }
        return argument;
    }

    public static int notNegative(int argument, String name) {
        if (argument < 0) {
            throw new IllegalArgumentException(ArgChecker.notNegativeMsg(name));
        }
        return argument;
    }

    private static String notNegativeMsg(String name) {
        return "Argument '" + name + "' must not be negative";
    }

    public static long notNegative(long argument, String name) {
        if (argument < 0L) {
            throw new IllegalArgumentException(ArgChecker.notNegativeMsg(name));
        }
        return argument;
    }

    public static double notNegative(double argument, String name) {
        if (argument < 0.0) {
            throw new IllegalArgumentException(ArgChecker.notNegativeMsg(name));
        }
        return argument;
    }

    public static int notNegativeOrZero(int argument, String name) {
        if (argument <= 0) {
            throw new IllegalArgumentException(ArgChecker.notNegativeOrZeroMsg(name, argument));
        }
        return argument;
    }

    private static String notNegativeOrZeroMsg(String name, double argument) {
        return "Argument '" + name + "' must not be negative or zero but has value " + argument;
    }

    public static long notNegativeOrZero(long argument, String name) {
        if (argument <= 0L) {
            throw new IllegalArgumentException(ArgChecker.notNegativeOrZeroMsg(name, argument));
        }
        return argument;
    }

    public static double notNegativeOrZero(double argument, String name) {
        if (argument <= 0.0) {
            throw new IllegalArgumentException(ArgChecker.notNegativeOrZeroMsg(name, argument));
        }
        return argument;
    }

    public static double notNegativeOrZero(double argument, double tolerance, String name) {
        if (DoubleMath.fuzzyEquals((double)argument, (double)0.0, (double)tolerance)) {
            throw new IllegalArgumentException("Argument '" + name + "' must not be zero");
        }
        if (argument < 0.0) {
            throw new IllegalArgumentException("Argument '" + name + "' must be greater than zero but has value " + argument);
        }
        return argument;
    }

    public static double notZero(double argument, double tolerance, String name) {
        if (DoubleMath.fuzzyEquals((double)argument, (double)0.0, (double)tolerance)) {
            throw new IllegalArgumentException("Argument '" + name + "' must not be zero");
        }
        return argument;
    }

    public static double inRange(double argument, double lowInclusive, double highExclusive, String name) {
        if (argument < lowInclusive || argument >= highExclusive) {
            throw new IllegalArgumentException(Messages.format("Expected {} <= '{}' < {}, but found {}", lowInclusive, name, highExclusive, argument));
        }
        return argument;
    }

    public static double inRangeInclusive(double argument, double lowInclusive, double highInclusive, String name) {
        if (argument < lowInclusive || argument > highInclusive) {
            throw new IllegalArgumentException(Messages.format("Expected {} <= '{}' <= {}, but found {}", lowInclusive, name, highInclusive, argument));
        }
        return argument;
    }

    public static double inRangeExclusive(double argument, double lowExclusive, double highExclusive, String name) {
        if (argument <= lowExclusive || argument >= highExclusive) {
            throw new IllegalArgumentException(Messages.format("Expected {} < '{}' < {}, but found {}", lowExclusive, name, highExclusive, argument));
        }
        return argument;
    }

    public static int inRange(int argument, int lowInclusive, int highExclusive, String name) {
        if (argument < lowInclusive || argument >= highExclusive) {
            throw new IllegalArgumentException(Messages.format("Expected {} <= '{}' < {}, but found {}", lowInclusive, name, highExclusive, argument));
        }
        return argument;
    }

    public static int inRangeInclusive(int argument, int lowInclusive, int highInclusive, String name) {
        if (argument < lowInclusive || argument > highInclusive) {
            throw new IllegalArgumentException(Messages.format("Expected {} <= '{}' <= {}, but found {}", lowInclusive, name, highInclusive, argument));
        }
        return argument;
    }

    public static int inRangeExclusive(int argument, int lowExclusive, int highExclusive, String name) {
        if (argument <= lowExclusive || argument >= highExclusive) {
            throw new IllegalArgumentException(Messages.format("Expected {} < '{}' < {}, but found {}", lowExclusive, name, highExclusive, argument));
        }
        return argument;
    }

    public static <T> void inOrderNotEqual(Comparable<? super T> obj1, T obj2, String name1, String name2) {
        ArgChecker.notNull(obj1, name1);
        ArgChecker.notNull(obj2, name2);
        if (obj1.compareTo(obj2) >= 0) {
            throw new IllegalArgumentException(Messages.format("Invalid order: Expected '{}' < '{}', but found: '{}' >= '{}", name1, name2, obj1, obj2));
        }
    }

    public static <T> void inOrderOrEqual(Comparable<? super T> obj1, T obj2, String name1, String name2) {
        ArgChecker.notNull(obj1, name1);
        ArgChecker.notNull(obj2, name2);
        if (obj1.compareTo(obj2) > 0) {
            throw new IllegalArgumentException(Messages.format("Invalid order: Expected '{}' <= '{}', but found: '{}' > '{}", name1, name2, obj1, obj2));
        }
    }
}

