/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.named;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.io.IniFile;
import com.opengamma.strata.collect.io.PropertySet;
import com.opengamma.strata.collect.io.ResourceConfig;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.collect.named.NamedLookup;
import com.opengamma.strata.collect.tuple.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.convert.RenameHandler;

public final class ExtendedEnum<T extends Named> {
    private static final Logger log = Logger.getLogger(ExtendedEnum.class.getName());
    private static final String PROVIDERS_SECTION = "providers";
    private static final String ALTERNATES_SECTION = "alternates";
    private static final String EXTERNALS_SECTION = "externals.";
    private static final String LENIENT_PATTERNS_SECTION = "lenientPatterns";
    private final Class<T> type;
    private final ImmutableList<NamedLookup<T>> lookups;
    private final ImmutableMap<String, String> alternateNames;
    private final ImmutableMap<String, ImmutableMap<String, String>> externalNames;
    private final ImmutableList<Pair<Pattern, String>> lenientRegex;

    public static <R extends Named> ExtendedEnum<R> of(Class<R> type) {
        try {
            String name = type.getSimpleName() + ".ini";
            IniFile config = ResourceConfig.combinedIniFile(name);
            ImmutableList lookups = ExtendedEnum.parseProviders(config, type);
            ImmutableMap<String, String> alternateNames = ExtendedEnum.parseAlternates(config);
            ImmutableMap<String, ImmutableMap<String, String>> externalNames = ExtendedEnum.parseExternals(config);
            ImmutableList<Pair<Pattern, String>> lenientRegex = ExtendedEnum.parseLenientPatterns(config);
            log.fine(() -> "Loaded extended enum: " + name + ", providers: " + lookups);
            return new ExtendedEnum<R>(type, lookups, alternateNames, externalNames, lenientRegex);
        }
        catch (RuntimeException ex) {
            log.severe("Failed to load ExtendedEnum for " + type + ": " + Throwables.getStackTraceAsString((Throwable)ex));
            return new ExtendedEnum<R>(type, ImmutableList.of(), (ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableMap<String, ImmutableMap<String, String>>)ImmutableMap.of(), (ImmutableList<Pair<Pattern, String>>)ImmutableList.of());
        }
    }

    private static <R extends Named> ImmutableList<NamedLookup<R>> parseProviders(IniFile config, Class<R> enumType) {
        if (!config.contains(PROVIDERS_SECTION)) {
            return ImmutableList.of();
        }
        PropertySet section = config.section(PROVIDERS_SECTION);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : section.keys()) {
            Class cls;
            try {
                cls = RenameHandler.INSTANCE.lookupType(key);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to find enum provider class: " + key, ex);
            }
            String value = section.value(key);
            if (value.equals("constants")) {
                builder.add(ExtendedEnum.parseConstants(enumType, cls));
                continue;
            }
            if (value.equals("lookup")) {
                if (!NamedLookup.class.isAssignableFrom(cls)) {
                    throw new IllegalArgumentException("Enum provider class must implement NamedLookup " + cls.getName());
                }
                try {
                    Constructor cons = cls.getDeclaredConstructor(new Class[0]);
                    if (!Modifier.isPublic(cls.getModifiers())) {
                        cons.setAccessible(true);
                    }
                    builder.add((Object)((NamedLookup)cons.newInstance(new Object[0])));
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid enum provider constructor: new " + cls.getName() + "()", ex);
                }
            }
            if (value.equals("instance")) {
                try {
                    Field field = cls.getDeclaredField("INSTANCE");
                    if (!Modifier.isStatic(field.getModifiers()) || !NamedLookup.class.isAssignableFrom(field.getType())) {
                        throw new IllegalArgumentException("Invalid enum provider instance: " + cls.getName() + ".INSTANCE");
                    }
                    if (!Modifier.isPublic(cls.getModifiers()) || !Modifier.isPublic(field.getModifiers())) {
                        field.setAccessible(true);
                    }
                    builder.add((Object)((NamedLookup)field.get(null)));
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Invalid enum provider instance: " + cls.getName() + ".INSTANCE", ex);
                }
            }
            throw new IllegalArgumentException("Provider value must be either 'constants' or 'lookup'");
        }
        return builder.build();
    }

    private static <R extends Named> NamedLookup<R> parseConstants(Class<R> enumType, Class<?> constantsType) {
        Field[] fields = constantsType.getDeclaredFields();
        HashMap<String, Named> instances = new HashMap<String, Named>();
        for (Field field : fields) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !enumType.isAssignableFrom(field.getType())) continue;
            if (!Modifier.isPublic(constantsType.getModifiers())) {
                field.setAccessible(true);
            }
            try {
                Named instance = (Named)enumType.cast(field.get(null));
                instances.putIfAbsent(instance.getName(), instance);
                instances.putIfAbsent(instance.getName().toUpperCase(Locale.ENGLISH), instance);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to query field: " + field, ex);
            }
        }
        final ImmutableMap constants = ImmutableMap.copyOf(instances);
        return new NamedLookup<R>(){

            @Override
            public ImmutableMap<String, R> lookupAll() {
                return constants;
            }
        };
    }

    private static ImmutableMap<String, String> parseAlternates(IniFile config) {
        if (!config.contains(ALTERNATES_SECTION)) {
            return ImmutableMap.of();
        }
        HashMap alternates = new HashMap();
        for (Map.Entry entry : config.section(ALTERNATES_SECTION).asMap().entrySet()) {
            alternates.put(entry.getKey(), entry.getValue());
            alternates.putIfAbsent(((String)entry.getKey()).toUpperCase(Locale.ENGLISH), entry.getValue());
        }
        return ImmutableMap.copyOf(alternates);
    }

    private static ImmutableMap<String, ImmutableMap<String, String>> parseExternals(IniFile config) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String sectionName : config.sections()) {
            if (!sectionName.startsWith(EXTERNALS_SECTION)) continue;
            String group = sectionName.substring(EXTERNALS_SECTION.length());
            builder.put((Object)group, config.section(sectionName).asMap());
        }
        return builder.build();
    }

    private static ImmutableList<Pair<Pattern, String>> parseLenientPatterns(IniFile config) {
        if (!config.contains(LENIENT_PATTERNS_SECTION)) {
            return ImmutableList.of();
        }
        ArrayList alternates = new ArrayList();
        for (Map.Entry entry : config.section(LENIENT_PATTERNS_SECTION).asMap().entrySet()) {
            alternates.add(Pair.of(Pattern.compile((String)entry.getKey(), 2), entry.getValue()));
        }
        return ImmutableList.copyOf(alternates);
    }

    private ExtendedEnum(Class<T> type, ImmutableList<NamedLookup<T>> lookups, ImmutableMap<String, String> alternateNames, ImmutableMap<String, ImmutableMap<String, String>> externalNames, ImmutableList<Pair<Pattern, String>> lenientRegex) {
        this.type = ArgChecker.notNull(type, "type");
        this.lookups = ArgChecker.notNull(lookups, "lookups");
        this.alternateNames = ArgChecker.notNull(alternateNames, "alternateNames");
        this.externalNames = ArgChecker.notNull(externalNames, "externalNames");
        this.lenientRegex = ArgChecker.notNull(lenientRegex, "lenientRegex");
    }

    public Optional<T> find(String name) {
        String standardName = (String)this.alternateNames.getOrDefault((Object)name, (Object)name);
        for (NamedLookup lookup : this.lookups) {
            Object instance = lookup.lookup(standardName);
            if (instance == null) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public T lookup(String name) {
        String standardName = (String)this.alternateNames.getOrDefault((Object)name, (Object)name);
        for (NamedLookup lookup : this.lookups) {
            Object instance = lookup.lookup(standardName);
            if (instance == null) continue;
            return instance;
        }
        throw new IllegalArgumentException(this.type.getSimpleName() + " name not found: " + name);
    }

    public <S extends T> S lookup(String name, Class<S> subtype) {
        T result = this.lookup(name);
        if (!subtype.isInstance(result)) {
            throw new IllegalArgumentException(this.type.getSimpleName() + " name found but did not match expected type: " + name);
        }
        return (S)((Named)subtype.cast(result));
    }

    public ImmutableMap<String, T> lookupAll() {
        HashMap map = new HashMap();
        for (NamedLookup lookup : this.lookups) {
            Map lookupMap = lookup.lookupAll();
            for (Map.Entry entry : lookupMap.entrySet()) {
                map.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        return ImmutableMap.copyOf(map);
    }

    public ImmutableMap<String, T> lookupAllNormalized() {
        HashMap result = new HashMap();
        HashMap others = new HashMap();
        for (Map.Entry entry : this.lookupAll().entrySet()) {
            String normalizedName = ((Named)entry.getValue()).getName();
            if (((String)entry.getKey()).equals(normalizedName)) {
                result.put(normalizedName, entry.getValue());
                continue;
            }
            others.put(normalizedName, entry.getValue());
        }
        others.values().forEach(v -> result.putIfAbsent(v.getName(), v));
        return ImmutableMap.copyOf(result);
    }

    public ImmutableMap<String, String> alternateNames() {
        return this.alternateNames;
    }

    public ImmutableSet<String> externalNameGroups() {
        return this.externalNames.keySet();
    }

    public ExternalEnumNames<T> externalNames(String group) {
        ImmutableMap externals = (ImmutableMap)this.externalNames.get((Object)group);
        if (externals == null) {
            throw new IllegalArgumentException(this.type.getSimpleName() + " group not found: " + group);
        }
        return new ExternalEnumNames(this, group, externals);
    }

    public Optional<T> findLenient(String name) {
        Optional<T> alreadyValid = this.find(name);
        if (alreadyValid.isPresent()) {
            return alreadyValid;
        }
        String current = name.toUpperCase(Locale.ENGLISH);
        for (Pair pair : this.lenientRegex) {
            Matcher matcher = ((Pattern)pair.getFirst()).matcher(current);
            if (!matcher.matches()) continue;
            current = matcher.replaceFirst((String)pair.getSecond());
        }
        return this.find(current);
    }

    public String toString() {
        return "ExtendedEnum[" + this.type.getSimpleName() + "]";
    }

    public static final class ExternalEnumNames<T extends Named> {
        private ExtendedEnum<T> extendedEnum;
        private String group;
        private ImmutableMap<String, String> externalNames;

        private ExternalEnumNames(ExtendedEnum<T> extendedEnum, String group, ImmutableMap<String, String> externalNames) {
            this.extendedEnum = extendedEnum;
            this.group = group;
            this.externalNames = externalNames;
        }

        public T lookup(String name) {
            String standardName = (String)this.externalNames.getOrDefault((Object)name, (Object)name);
            try {
                return this.extendedEnum.lookup(standardName);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(Messages.format("{}:{} unable to find external name: {}", ((ExtendedEnum)this.extendedEnum).type.getSimpleName(), this.group, name));
            }
        }

        public <S extends T> S lookup(String name, Class<S> subtype) {
            T result = this.lookup(name);
            if (!subtype.isInstance(result)) {
                throw new IllegalArgumentException(Messages.format("{}:{} external name found but did not match expected type: {}", ((ExtendedEnum)this.extendedEnum).type.getSimpleName(), this.group, name));
            }
            return (S)((Named)subtype.cast(result));
        }

        public ImmutableMap<String, String> externalNames() {
            return this.externalNames;
        }

        public String reverseLookup(T namedEnum) {
            String name = namedEnum.getName();
            for (Map.Entry entry : this.externalNames.entrySet()) {
                if (!((String)entry.getValue()).equals(name)) continue;
                return (String)entry.getKey();
            }
            throw new IllegalArgumentException(Messages.format("{}:{} external name not found for standard name: {}", ((ExtendedEnum)this.extendedEnum).type.getSimpleName(), this.group, name));
        }

        public String toString() {
            return "ExternalEnumNames[" + ((ExtendedEnum)this.extendedEnum).type.getSimpleName() + ":" + this.group + "]";
        }
    }
}

