/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.flatten;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.path.RosettaPathValue;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ModelObjectFlattener {
    public List<RosettaPathValue> flatten(RosettaModelObject modelObject) {
        FlattenerBuilderProcessor processor = new FlattenerBuilderProcessor();
        modelObject.toBuilder().process(RosettaPath.valueOf(modelObject.getType().getSimpleName()), processor);
        List<RosettaPath> metaPaths = processor.getMetaPaths();
        List<RosettaPathValue> pathValues = processor.getRosettaPathValue();
        return this.removeAllMetaPaths(metaPaths, pathValues);
    }

    private List<RosettaPathValue> removeAllMetaPaths(List<RosettaPath> metaPaths, List<RosettaPathValue> pathValues) {
        return pathValues.stream().map(pathValue -> new RosettaPathValue(this.removeAllMetaPaths(metaPaths, pathValue.getPath()), pathValue.getValue())).collect(Collectors.toList());
    }

    private RosettaPath removeAllMetaPaths(List<RosettaPath> metaPaths, RosettaPath path) {
        LinkedList<RosettaPath.Element> elements = path.allElements();
        metaPaths.stream().filter(path::startsWith).map(RosettaPath::allElements).map(LinkedList::size).map(i -> i - 1).distinct().sorted(Comparator.reverseOrder()).forEach(i -> elements.remove((int)i));
        RosettaPath newPath = RosettaPath.createPathFromElements(elements);
        return newPath.trimFirst();
    }

    private static class FlattenerBuilderProcessor
    implements BuilderProcessor {
        private final List<RosettaPathValue> rosettaPathValues = new ArrayList<RosettaPathValue>();
        private final List<RosettaPath> metaPaths = new ArrayList<RosettaPath>();

        private FlattenerBuilderProcessor() {
        }

        public List<RosettaPath> getMetaPaths() {
            return this.metaPaths;
        }

        public List<RosettaPathValue> getRosettaPathValue() {
            return this.rosettaPathValues;
        }

        @Override
        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            if (builder != null && parent instanceof FieldWithMeta) {
                this.metaPaths.add(path);
            }
            return true;
        }

        @Override
        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            int i = 0;
            for (RosettaModelObjectBuilder rosettaModelObjectBuilder : builders) {
                this.processRosetta(path.withIndex(i++), rosettaType, rosettaModelObjectBuilder, parent, metas);
            }
            return true;
        }

        @Override
        public <T> void processBasic(RosettaPath path, Class<T> rosettaType, T instance, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            if (instance != null) {
                if (parent instanceof FieldWithMeta) {
                    this.rosettaPathValues.add(new RosettaPathValue(path.getParent(), instance));
                } else {
                    this.rosettaPathValues.add(new RosettaPathValue(path, instance));
                }
            }
        }

        @Override
        public <T> void processBasic(RosettaPath path, Class<T> rosettaType, Collection<? extends T> instances, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            int i = 0;
            for (T instance : instances) {
                this.processBasic(path.withIndex(i++), rosettaType, instance, parent, metas);
            }
        }

        @Override
        public BuilderProcessor.Report report() {
            return null;
        }
    }
}

