# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['FloatingRateOption']


class FloatingRateOption(BaseDataClass):
    """
    Specification of a floating rate option as a floating rate index and tenor.
    """
    floatingRateIndex: Optional[AttributeWithMeta[cdm.base.staticdata.asset.rates.FloatingRateIndexEnum.FloatingRateIndexEnum] | cdm.base.staticdata.asset.rates.FloatingRateIndexEnum.FloatingRateIndexEnum] = Field(None, description="The reference index that is used to specify the floating interest rate. The FpML standard maintains the list of such indices, which are positioned as enumeration values as part of the CDM.")
    """
    The reference index that is used to specify the floating interest rate. The FpML standard maintains the list of such indices, which are positioned as enumeration values as part of the CDM.
    """
    inflationRateIndex: Optional[AttributeWithMeta[cdm.base.staticdata.asset.rates.InflationRateIndexEnum.InflationRateIndexEnum] | cdm.base.staticdata.asset.rates.InflationRateIndexEnum.InflationRateIndexEnum] = Field(None, description="The reference index that is used to specify the inflation interest rate. The FpML standard maintains the list of such indices, which are positioned as enumeration values as part of the CDM.")
    """
    The reference index that is used to specify the inflation interest rate. The FpML standard maintains the list of such indices, which are positioned as enumeration values as part of the CDM.
    """
    indexTenor: Optional[cdm.base.datetime.Period.Period] = Field(None, description="The ISDA Designated Maturity, i.e. the floating rate tenor.")
    """
    The ISDA Designated Maturity, i.e. the floating rate tenor.
    """
    indexReferenceInformation: Optional[cdm.base.staticdata.asset.common.IndexReferenceInformation.IndexReferenceInformation] = Field(None, description="This Attribute contains all the terms relevant to defining an Index.")
    """
    This Attribute contains all the terms relevant to defining an Index.
    """
    
    @rosetta_condition
    def condition_0_FloatingRateIndex(self):
        """
        floating rate and inflation rate index are mutually exclusive
        """
        item = self
        return rosetta_check_one_of(self, 'floatingRateIndex', 'inflationRateIndex', necessity=False)
    
    @rosetta_condition
    def condition_1_IndexRefInfo(self):
        """
        If both floating rate and inflation rate index are absent, then indexReferenceInformation is required
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "indexReferenceInformation"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(((not rosetta_attr_exists(rosetta_resolve_attr(self, "floatingRateIndex"))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "inflationRateIndex")))), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum
import cdm.base.staticdata.asset.rates.InflationRateIndexEnum
import cdm.base.datetime.Period
import cdm.base.staticdata.asset.common.IndexReferenceInformation
